/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import org.geotoolkit.internal.sql.table.Query;
import org.geotoolkit.internal.sql.table.QueryType;
import org.geotoolkit.util.Strings;

public abstract class ColumnOrParameter {
    private final short[] index;
    private EnumMap<QueryType, String> functions;

    ColumnOrParameter() {
        this.index = null;
    }

    ColumnOrParameter(Query query, QueryType ... queryTypeArray) {
        this(query, queryTypeArray != null && queryTypeArray.length != 0 ? EnumSet.copyOf(Arrays.asList(queryTypeArray)) : EnumSet.noneOf(QueryType.class));
    }

    private ColumnOrParameter(Query query, EnumSet<QueryType> enumSet) {
        int n = 0;
        for (Object object : enumSet) {
            int n2 = object.ordinal();
            if (n2 < n) continue;
            n = n2 + 1;
        }
        this.index = new short[n];
        ColumnOrParameter[] columnOrParameterArray = query.add(this);
        block1: for (QueryType queryType : enumSet) {
            int n3 = queryType.ordinal();
            int n4 = columnOrParameterArray.length;
            while (--n4 >= 0) {
                short s2;
                ColumnOrParameter columnOrParameter = columnOrParameterArray[n4];
                if (n3 >= columnOrParameter.index.length || (s2 = columnOrParameter.index[n3]) == 0) continue;
                if ((s2 = (short)(s2 + 1)) < 0) {
                    throw new ArithmeticException("Overflow");
                }
                this.index[n3] = s2;
                continue block1;
            }
            this.index[n3] = 1;
        }
    }

    public final int indexOf(QueryType queryType) {
        int n = queryType.ordinal();
        if (n >= 0 && n < this.index.length) {
            return this.index[n];
        }
        return 0;
    }

    final String getFunction(QueryType queryType) {
        return this.functions != null ? this.functions.get((Object)queryType) : null;
    }

    final void setFunction(int n, String string, QueryType ... queryTypeArray) {
        if (Strings.count(string, '?') != n) {
            throw new IllegalArgumentException(string);
        }
        if (this.functions == null) {
            this.functions = new EnumMap(QueryType.class);
        }
        for (QueryType queryType : queryTypeArray) {
            this.functions.put(queryType, string);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.index);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ColumnOrParameter columnOrParameter = (ColumnOrParameter)object;
            return Arrays.equals(this.index, columnOrParameter.index);
        }
        return false;
    }
}

