/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.quality;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.quality.AbstractCompleteness;
import org.geotoolkit.metadata.iso.quality.AbstractLogicalConsistency;
import org.geotoolkit.metadata.iso.quality.AbstractPositionalAccuracy;
import org.geotoolkit.metadata.iso.quality.AbstractTemporalAccuracy;
import org.geotoolkit.metadata.iso.quality.AbstractThematicAccuracy;
import org.geotoolkit.metadata.iso.quality.DefaultUsability;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Completeness;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.LogicalConsistency;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.quality.TemporalAccuracy;
import org.opengis.metadata.quality.ThematicAccuracy;
import org.opengis.metadata.quality.Usability;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="AbstractDQ_Element_Type", propOrder={"namesOfMeasure", "measureIdentification", "measureDescription", "evaluationMethodType", "evaluationMethodDescription", "evaluationProcedure", "dates", "results"})
@XmlRootElement(name="DQ_Element")
@XmlSeeAlso(value={AbstractCompleteness.class, AbstractLogicalConsistency.class, AbstractPositionalAccuracy.class, AbstractThematicAccuracy.class, AbstractTemporalAccuracy.class, DefaultUsability.class})
public class AbstractElement
extends MetadataEntity
implements Element {
    private static final long serialVersionUID = -3542504624077298894L;
    private Collection<InternationalString> namesOfMeasure;
    private Identifier measureIdentification;
    private InternationalString measureDescription;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private long date1;
    private long date2;
    private Collection<Result> results;

    public AbstractElement() {
        this.date1 = Long.MIN_VALUE;
        this.date2 = Long.MIN_VALUE;
    }

    public AbstractElement(Element element) {
        super(element);
        if (element != null && this.date1 == 0L && this.date2 == 0L && XCollections.isNullOrEmpty(element.getDates())) {
            this.date1 = Long.MIN_VALUE;
            this.date2 = Long.MIN_VALUE;
        }
    }

    public AbstractElement(Result result) {
        this();
        this.setResults(Collections.singleton(result));
    }

    public static AbstractElement castOrCopy(Element element) {
        if (element instanceof PositionalAccuracy) {
            return AbstractPositionalAccuracy.castOrCopy((PositionalAccuracy)element);
        }
        if (element instanceof TemporalAccuracy) {
            return AbstractTemporalAccuracy.castOrCopy((TemporalAccuracy)element);
        }
        if (element instanceof ThematicAccuracy) {
            return AbstractThematicAccuracy.castOrCopy((ThematicAccuracy)element);
        }
        if (element instanceof LogicalConsistency) {
            return AbstractLogicalConsistency.castOrCopy((LogicalConsistency)element);
        }
        if (element instanceof Completeness) {
            return AbstractCompleteness.castOrCopy((Completeness)element);
        }
        if (element instanceof Usability) {
            return DefaultUsability.castOrCopy((Usability)element);
        }
        return element == null || element instanceof AbstractElement ? (AbstractElement)element : new AbstractElement(element);
    }

    @XmlElement(name="nameOfMeasure")
    public synchronized Collection<InternationalString> getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public synchronized void setNamesOfMeasure(Collection<? extends InternationalString> collection) {
        this.namesOfMeasure = this.copyCollection(collection, this.namesOfMeasure, InternationalString.class);
    }

    @Override
    @XmlElement(name="measureIdentification")
    public synchronized Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public synchronized void setMeasureIdentification(Identifier identifier) {
        this.checkWritePermission();
        this.measureIdentification = identifier;
    }

    @Override
    @XmlElement(name="measureDescription")
    public synchronized InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public synchronized void setMeasureDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.measureDescription = internationalString;
    }

    @Override
    @XmlElement(name="evaluationMethodType")
    public synchronized EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public synchronized void setEvaluationMethodType(EvaluationMethodType evaluationMethodType) {
        this.checkWritePermission();
        this.evaluationMethodType = evaluationMethodType;
    }

    @Override
    @XmlElement(name="evaluationMethodDescription")
    public synchronized InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public synchronized void setEvaluationMethodDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.evaluationMethodDescription = internationalString;
    }

    @Override
    @XmlElement(name="evaluationProcedure")
    public synchronized Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public synchronized void setEvaluationProcedure(Citation citation) {
        this.checkWritePermission();
        this.evaluationProcedure = citation;
    }

    @XmlElement(name="dateTime")
    public synchronized Collection<Date> getDates() {
        if (this.date1 == Long.MIN_VALUE) {
            return Collections.emptyList();
        }
        if (this.date2 == Long.MIN_VALUE) {
            return Collections.singleton(new Date(this.date1));
        }
        return Arrays.asList(new Date(this.date1), new Date(this.date2));
    }

    public synchronized void setDates(Collection<Date> collection) {
        Iterator<Date> iterator;
        this.checkWritePermission();
        this.date2 = Long.MIN_VALUE;
        this.date1 = Long.MIN_VALUE;
        if (collection != null && (iterator = collection.iterator()).hasNext()) {
            this.date1 = iterator.next().getTime();
            if (iterator.hasNext()) {
                this.date2 = iterator.next().getTime();
                if (iterator.hasNext()) {
                    throw new IllegalArgumentException(Errors.format(109));
                }
            }
        }
    }

    @XmlElement(name="result", required=true)
    public synchronized Collection<Result> getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public synchronized void setResults(Collection<? extends Result> collection) {
        this.results = this.copyCollection(collection, this.results, Result.class);
    }
}

