/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.naming;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import net.jcip.annotations.Immutable;
import org.geotoolkit.naming.AbstractName;
import org.geotoolkit.naming.DefaultLocalName;
import org.geotoolkit.naming.DefaultScopedName;
import org.geotoolkit.naming.GlobalNameSpace;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.WeakValueHashMap;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@Immutable
public class DefaultNameSpace
implements NameSpace,
Serializable {
    private static final long serialVersionUID = -3064358267398624306L;
    public static final char DEFAULT_SEPARATOR = ':';
    static final String DEFAULT_SEPARATOR_STRING = ":";
    final DefaultNameSpace parent;
    private final CharSequence name;
    final String headSeparator;
    final String separator;
    private transient AbstractName path;
    private transient WeakValueHashMap<String, Object> childs;

    DefaultNameSpace() {
        this.parent = null;
        this.name = "global";
        this.headSeparator = DEFAULT_SEPARATOR_STRING;
        this.separator = DEFAULT_SEPARATOR_STRING;
        this.init();
    }

    protected DefaultNameSpace(DefaultNameSpace defaultNameSpace, CharSequence charSequence, String string, String string2) {
        this.parent = defaultNameSpace;
        ArgumentChecks.ensureNonNull("name", charSequence);
        ArgumentChecks.ensureNonNull("headSeparator", string);
        ArgumentChecks.ensureNonNull("separator", string2);
        if (!(charSequence instanceof InternationalString)) {
            charSequence = ((Object)charSequence).toString();
        }
        this.name = charSequence;
        this.headSeparator = string;
        this.separator = string2;
        this.init();
    }

    private void init() {
        this.childs = new WeakValueHashMap();
    }

    static DefaultNameSpace wrap(NameSpace nameSpace) {
        if (nameSpace == null) {
            return GlobalNameSpace.GLOBAL;
        }
        if (nameSpace instanceof DefaultNameSpace) {
            return (DefaultNameSpace)nameSpace;
        }
        return DefaultNameSpace.forName(nameSpace.name(), DEFAULT_SEPARATOR_STRING, DEFAULT_SEPARATOR_STRING);
    }

    static DefaultNameSpace forName(GenericName genericName, String string, String string2) {
        NameSpace nameSpace;
        if (genericName == null) {
            return null;
        }
        List<? extends LocalName> list = genericName.getParsedNames();
        ListIterator<? extends LocalName> listIterator = list.listIterator(list.size());
        do {
            if (listIterator.hasPrevious()) continue;
            nameSpace = GlobalNameSpace.GLOBAL;
            break;
        } while (!((nameSpace = listIterator.previous().scope()) instanceof DefaultNameSpace));
        DefaultNameSpace defaultNameSpace = nameSpace;
        while (listIterator.hasNext()) {
            LocalName localName = listIterator.next();
            defaultNameSpace = defaultNameSpace.child(((Object)localName).toString(), localName.toInternationalString(), string, string2);
        }
        return defaultNameSpace;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    private static int depth(DefaultNameSpace defaultNameSpace) {
        int n = 0;
        if (defaultNameSpace != null) {
            do {
                ++n;
            } while ((defaultNameSpace = defaultNameSpace.parent) != null && !defaultNameSpace.isGlobal());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericName name() {
        Object object;
        Object object2;
        int n;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.path != null) {
                return this.path;
            }
            n = DefaultNameSpace.depth(this);
            object2 = new DefaultLocalName[n];
            object = this;
            int n2 = n;
            while (--n2 >= 0) {
                object2[n2] = new DefaultLocalName(((DefaultNameSpace)object).parent, ((DefaultNameSpace)object).name);
                object = ((DefaultNameSpace)object).parent;
            }
            assert (DefaultNameSpace.depth((DefaultNameSpace)object) == 0 || ((DefaultNameSpace)object).isGlobal());
            AbstractName abstractName = this.path = DefaultScopedName.create(UnmodifiableArrayList.wrap(object2));
            int n3 = n;
            while (--n3 >= 0) {
                object2[n3].fullyQualified = abstractName;
                abstractName = abstractName instanceof ScopedName ? ((ScopedName)((Object)abstractName)).path() : null;
            }
        }
        serializable = this.path;
        object2 = this.parent;
        while (object2 != null && !((DefaultNameSpace)object2).isGlobal()) {
            serializable = (AbstractName)((ScopedName)((Object)serializable)).path();
            object = object2;
            synchronized (object) {
                if (((DefaultNameSpace)object2).path == null || ((DefaultNameSpace)object2).path.arraySize() < n) {
                    ((DefaultNameSpace)object2).path = serializable;
                }
            }
            object2 = ((DefaultNameSpace)object2).parent;
        }
        return this.path;
    }

    final DefaultNameSpace child(CharSequence charSequence) {
        return this.child(DefaultNameSpace.key(charSequence), charSequence, this.separator, this.separator);
    }

    private static String key(CharSequence charSequence) {
        return charSequence instanceof InternationalString ? ((InternationalString)charSequence).toString(null) : ((Object)charSequence).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultNameSpace child(String string, CharSequence charSequence, String string2, String string3) {
        DefaultNameSpace defaultNameSpace;
        ArgumentChecks.ensureNonNull("key", string);
        if (charSequence == null) {
            charSequence = string;
        }
        WeakValueHashMap<String, Object> weakValueHashMap = this.childs;
        synchronized (weakValueHashMap) {
            Object object = this.childs.get(string);
            if (object instanceof DefaultNameSpace) {
                defaultNameSpace = (DefaultNameSpace)object;
                if (!(defaultNameSpace.separator.equals(string3) && defaultNameSpace.headSeparator.equals(string2) && defaultNameSpace.name.equals(charSequence))) {
                    defaultNameSpace = new DefaultNameSpace(this, charSequence, string2, string3);
                }
            } else {
                defaultNameSpace = new DefaultNameSpace(this, charSequence, string2, string3);
                if (this.childs.put(string, defaultNameSpace) != object) {
                    throw new AssertionError();
                }
            }
        }
        assert (defaultNameSpace.parent == this);
        return defaultNameSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DefaultLocalName local(CharSequence charSequence, DefaultLocalName defaultLocalName) {
        DefaultLocalName defaultLocalName2;
        ArgumentChecks.ensureNonNull("name", charSequence);
        String string = ((Object)charSequence).toString();
        WeakValueHashMap<String, Object> weakValueHashMap = this.childs;
        synchronized (weakValueHashMap) {
            Object object = this.childs.get(string);
            if (object instanceof DefaultLocalName) {
                defaultLocalName2 = (DefaultLocalName)object;
                if (charSequence.equals(defaultLocalName2.name)) {
                    assert ((defaultLocalName2.scope != null ? defaultLocalName2.scope : GlobalNameSpace.GLOBAL) == this);
                    return defaultLocalName2;
                }
            }
            defaultLocalName2 = defaultLocalName != null ? defaultLocalName : new DefaultLocalName(this, charSequence);
            if (!(object instanceof DefaultNameSpace) && this.childs.put(string, defaultLocalName2) != object) {
                throw new AssertionError();
            }
        }
        return defaultLocalName2;
    }

    public String toString() {
        return "NameSpace[\"" + this.name() + "\"]";
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DefaultNameSpace defaultNameSpace = (DefaultNameSpace)object;
            return this.equalsIgnoreParent(defaultNameSpace) && Utilities.equals(this.parent, defaultNameSpace.parent);
        }
        return false;
    }

    private boolean equalsIgnoreParent(DefaultNameSpace defaultNameSpace) {
        return Utilities.equals(this.headSeparator, defaultNameSpace.headSeparator) && Utilities.equals(this.separator, defaultNameSpace.separator) && Utilities.equals(this.name, defaultNameSpace.name);
    }

    public int hashCode() {
        return Utilities.hash(this.parent, this.name.hashCode() + this.separator.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object readResolve() throws ObjectStreamException {
        WeakValueHashMap<String, Object> weakValueHashMap;
        DefaultNameSpace defaultNameSpace = this.parent != null ? this.parent : GlobalNameSpace.GLOBAL;
        String string = DefaultNameSpace.key(this.name);
        WeakValueHashMap<String, Object> weakValueHashMap2 = weakValueHashMap = defaultNameSpace.childs;
        synchronized (weakValueHashMap2) {
            Object object = weakValueHashMap.get(string);
            if (object instanceof DefaultNameSpace) {
                if (this.equalsIgnoreParent((DefaultNameSpace)object)) {
                    return object;
                }
            } else {
                this.init();
                if (weakValueHashMap.put(string, this) != object) {
                    throw new AssertionError();
                }
                return this;
            }
        }
        this.init();
        return this;
    }
}

