/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.wkt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.referencing.factory.wkt.WKTParsingAuthorityFactory;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;

@ThreadSafe
public class PropertyAuthorityFactory
extends WKTParsingAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory {
    public PropertyAuthorityFactory(Hints hints, URL uRL, Citation ... citationArray) throws IOException {
        this(hints, citationArray);
        if (uRL != null) {
            this.load(Collections.singleton(uRL));
        }
    }

    public PropertyAuthorityFactory(Hints hints, Collection<URL> collection, Citation ... citationArray) throws IOException {
        this(hints, citationArray);
        this.load(collection);
    }

    public PropertyAuthorityFactory(Hints hints, Hints.FileKey fileKey, Class<?> clazz, String string, Citation ... citationArray) throws IOException {
        this(hints, citationArray);
        ArrayList<URL> arrayList;
        Object object;
        File file = null;
        if (fileKey != null) {
            if (hints != null) {
                object = hints.get(fileKey);
                if (object instanceof File) {
                    file = (File)object;
                } else if (object instanceof String) {
                    file = new File((String)object);
                }
            }
            this.hints.put(fileKey, file);
        }
        object = string;
        ArrayList<URL> arrayList2 = new ArrayList<URL>(4);
        if (file != null) {
            try {
                arrayList = new File(file, string);
                object = ((File)((Object)arrayList)).getPath();
                if (((File)((Object)arrayList)).isFile()) {
                    arrayList2.add(((File)((Object)arrayList)).toURI().toURL());
                }
            }
            catch (SecurityException securityException) {
                Logging.unexpectedException(LOGGER, PropertyAuthorityFactory.class, "<init>", securityException);
            }
        }
        if (clazz != null) {
            arrayList = Collections.emptyList();
            object = clazz.getName();
            object = ((String)object).substring(0, ((String)object).lastIndexOf(46) + 1).replace('.', '/') + string;
            try {
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader != null) {
                    arrayList = Collections.list(classLoader.getResources((String)object));
                }
            }
            catch (SecurityException securityException) {
                Logging.recoverableException(LOGGER, PropertyAuthorityFactory.class, "<init>", securityException);
            }
            arrayList2.addAll((Collection<URL>)arrayList);
            if (arrayList.isEmpty()) {
                XCollections.addIfNonNull(arrayList2, clazz.getResource(string));
            }
        }
        if (arrayList2.isEmpty()) {
            PropertyAuthorityFactory.log(false, 11, null, object);
        }
        this.load(arrayList2);
    }

    protected PropertyAuthorityFactory(Hints hints, Citation ... citationArray) {
        super(hints, new Properties(), citationArray);
    }

    protected synchronized void load(Collection<URL> collection) throws IOException {
        Properties properties;
        PropertyAuthorityFactory.ensureNonNull("definitionFiles", collection);
        Properties properties2 = properties = (Properties)this.definitions;
        boolean bl = false;
        block0: for (URL uRL : collection) {
            Object object;
            if (!properties2.isEmpty()) {
                if (properties2 == properties) {
                    properties2 = new Properties();
                } else {
                    properties2.clear();
                }
            }
            InputStream inputStream = uRL.openStream();
            properties2.load(inputStream);
            inputStream.close();
            if (!properties2.isEmpty()) {
                object = String.valueOf(Citations.getIdentifier(this.authorities[0]));
                PropertyAuthorityFactory.log(false, 59, uRL, object);
            }
            if (properties2 != properties) {
                if (properties2.keySet().removeAll(properties.keySet())) {
                    PropertyAuthorityFactory.log(true, 22, uRL, null);
                }
                properties.putAll((Map<?, ?>)properties2);
            }
            if (bl) continue;
            object = Symbols.DEFAULT;
            for (Object object2 : properties.values()) {
                if (!((Symbols)object).containsAxis((String)object2)) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            this.hints.remove(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
            this.hints.remove(Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        }
    }

    private static void log(boolean bl, int n, URL uRL, Object object) {
        LogRecord logRecord;
        Level level;
        Level level2 = level = bl ? Level.WARNING : Level.CONFIG;
        if (uRL != null) {
            String string = uRL.getPath();
            string = string.substring(string.lastIndexOf(47) + 1);
            logRecord = object != null ? Loggings.format(level, n, string, object) : Loggings.format(level, n, string);
        } else {
            logRecord = Loggings.format(level, n, object);
        }
        logRecord.setSourceClassName(PropertyAuthorityFactory.class.getName());
        logRecord.setSourceMethodName("load");
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    @Override
    protected synchronized void dispose(boolean bl) {
        this.definitions.clear();
        super.dispose(bl);
    }
}

