/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.EquatorialStereographic;
import org.geotoolkit.referencing.operation.projection.ObliqueStereographic;
import org.geotoolkit.referencing.operation.projection.PolarStereographic;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class Stereographic
extends UnitaryProjection {
    private static final long serialVersionUID = 948619442800459872L;
    static final double EPSILON = 1.0E-6;
    final double \u03c60;
    final double sin\u03c60;
    final double cos\u03c60;
    private final double \u03c71;
    private final double sin\u03c71;
    private final double cos\u03c71;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        Stereographic stereographic;
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        double d = Math.toRadians(parameters.latitudeOfOrigin);
        if (Math.abs(d - 1.5707963267948966) < 1.0E-6) {
            stereographic = PolarStereographic.create(parameters);
        } else {
            boolean bl = parameters.isSpherical();
            boolean bl2 = parameters.nameMatches(org.geotoolkit.referencing.operation.provider.ObliqueStereographic.PARAMETERS);
            stereographic = Math.abs(d) < 1.0E-6 ? (bl ? new EquatorialStereographic.Spherical(parameters) : (!bl2 ? new EquatorialStereographic(parameters) : new ObliqueStereographic(parameters))) : (bl ? new Spherical(parameters) : (!bl2 ? new Stereographic(parameters) : new ObliqueStereographic(parameters)));
        }
        return stereographic.createConcatenatedTransform();
    }

    protected Stereographic(UnitaryProjection.Parameters parameters) {
        this(parameters, parameters.latitudeOfOrigin);
        double d = 2.0 * this.msfn(this.sin\u03c60, this.cos\u03c60) / this.cos\u03c71;
        if (this.excentricity == 0.0) {
            d = 2.0;
        }
        parameters.validate();
        parameters.normalize(false).scale(d, d);
        this.finish();
    }

    Stereographic(UnitaryProjection.Parameters parameters, double d) {
        super(parameters);
        double d2 = Math.toRadians(d);
        if (Math.abs(d2) < 1.0E-6) {
            d2 = 0.0;
            this.cos\u03c60 = 1.0;
            this.sin\u03c60 = 0.0;
            this.\u03c71 = 0.0;
            this.cos\u03c71 = 1.0;
            this.sin\u03c71 = 0.0;
        } else {
            this.cos\u03c60 = Math.cos(d2);
            this.sin\u03c60 = Math.sin(d2);
            this.\u03c71 = 2.0 * Math.atan(this.ssfn(d2, this.sin\u03c60)) - 1.5707963267948966;
            this.cos\u03c71 = Math.cos(this.\u03c71);
            this.sin\u03c71 = Math.sin(this.\u03c71);
        }
        this.\u03c60 = d2;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = this.rollLongitude(dArray[n]);
        double d7 = dArray[n + 1];
        double d8 = Math.sin(d7);
        double d9 = Math.sin(d6);
        double d10 = Math.cos(d6);
        double d11 = this.ssfn(d7, d8);
        if (dArray2 != null) {
            d5 = 2.0 * Math.atan(d11) - 1.5707963267948966;
            d4 = Math.sin(d5);
            d3 = Math.cos(d5);
            d2 = d3 * d10;
            d = 1.0 + this.sin\u03c71 * d4 + this.cos\u03c71 * d2;
            dArray2[n2] = d3 * d9 / d;
            dArray2[n2 + 1] = (this.cos\u03c71 * d4 - this.sin\u03c71 * d2) / d;
        }
        if (!bl) {
            return null;
        }
        d5 = Math.cos(d7);
        d4 = d11 - 1.0 / d11;
        d3 = 1.0 + d11 * d11;
        d2 = 2.0 * this.dssfn_d\u03c6(d7, d8, d5) * d11;
        d = d3 / d11 + d4 * this.sin\u03c71 + 2.0 * d10 * this.cos\u03c71;
        double d12 = -2.0 * this.cos\u03c71 * d9 / d;
        double d13 = (2.0 * this.sin\u03c71 - d4 * d10 * this.cos\u03c71) / (d3 * d);
        double d14 = this.cos\u03c71 * d4 - 2.0 * d10 * this.sin\u03c71;
        return new Matrix2(2.0 * (d10 - d9 * d12) / d, -d9 * d2 * (d4 / d3 + 2.0 * d13) / d, (2.0 * d9 * this.sin\u03c71 - d12 * d14) / d, d2 * ((2.0 * this.cos\u03c71 + this.sin\u03c71 * d10 * d4) / d3 - d13 * d14) / d);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3;
        block1: {
            double d4 = dArray[n];
            double d5 = dArray[n + 1];
            double d6 = Math.hypot(d4, d5);
            double d7 = 2.0 * Math.atan(d6);
            double d8 = Math.cos(d7);
            double d9 = Math.sin(d7);
            double d10 = d6 < 1.0E-6 ? this.\u03c71 : Math.asin(d8 * this.sin\u03c71 + d5 * d9 * this.cos\u03c71 / d6);
            double d11 = Math.tan(0.7853981633974483 + 0.5 * d10);
            d3 = d4 * d9;
            d2 = d6 * this.cos\u03c71 * d8 - d5 * this.sin\u03c71 * d9;
            double d12 = 0.5 * this.excentricity;
            d = d10;
            int n3 = 15;
            do {
                double d13;
                double d14 = this.excentricity * Math.sin(d);
                double d15 = 2.0 * Math.atan(d11 * Math.pow((1.0 + d14) / (1.0 - d14), d12)) - 1.5707963267948966;
                double d16 = d;
                d = d15;
                if (Math.abs(d16 - d13) < 1.0E-10) break block1;
            } while (--n3 >= 0);
            throw new ProjectionException(152);
        }
        dArray2[n2] = this.unrollLongitude(Math.atan2(d3, d2));
        dArray2[n2 + 1] = d;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            Stereographic stereographic = (Stereographic)object;
            return InternalUtilities.epsilonEqual(this.\u03c60, stereographic.\u03c60, comparisonMode);
        }
        return false;
    }

    @Immutable
    static final class Spherical
    extends Stereographic {
        private static final long serialVersionUID = -8558594307755820783L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d);
            double d6 = Math.cos(d);
            double d7 = this.cos\u03c60 * d4;
            double d8 = this.sin\u03c60 * d3;
            double d9 = 1.0 + d7 * d6 + d8;
            double d10 = d4 * d5 / d9;
            double d11 = (this.cos\u03c60 * d3 - this.sin\u03c60 * d4 * d6) / d9;
            Matrix2 matrix2 = null;
            if (bl) {
                double d12 = this.cos\u03c60 * d3;
                double d13 = this.sin\u03c60 * d4;
                double d14 = d7 * d5 / d9;
                double d15 = (d12 * d6 - d13) / d9;
                double d16 = d12 - d13 * d6;
                matrix2 = new Matrix2(d4 * (d14 * d5 + d6) / d9, d5 * (d15 * d4 - d3) / d9, (d14 * d16 + d13 * d5) / d9, (d15 * d16 + (d8 * d6 + d7)) / d9);
            }
            assert (Assertions.checkDerivative(matrix2, super.transform(dArray, n, dArray2, n2, bl)) && Assertions.checkTransform(dArray2, n2, d10, d11));
            if (dArray2 != null) {
                dArray2[n2] = d10;
                dArray2[n2 + 1] = d11;
            }
            return matrix2;
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d;
            double d2;
            double d3 = dArray[n];
            double d4 = dArray[n + 1];
            double d5 = Math.hypot(d3, d4);
            if (Math.abs(d5) < 1.0E-6) {
                d2 = this.\u03c60;
                d = 0.0;
            } else {
                double d6 = 2.0 * Math.atan(d5);
                double d7 = Math.cos(d6);
                double d8 = Math.sin(d6);
                double d9 = d5 * this.cos\u03c60 * d7 - d4 * this.sin\u03c60 * d8;
                double d10 = d3 * d8;
                d2 = Math.asin(d7 * this.sin\u03c60 + d4 * d8 * this.cos\u03c60 / d5);
                d = Math.atan2(d10, d9);
            }
            d = this.unrollLongitude(d);
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

