/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class NewZealandMapGrid
extends MapProjection {
    private static final long serialVersionUID = -7716733400419275656L;
    @Deprecated
    public static final ParameterDescriptor<Double> SEMI_MAJOR;
    @Deprecated
    public static final ParameterDescriptor<Double> SEMI_MINOR;
    @Deprecated
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    @Deprecated
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS;

    public NewZealandMapGrid() {
        super(PARAMETERS);
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.NewZealandMapGrid.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.ESRI, Citations.NETCDF};
        SEMI_MAJOR = UniversalParameters.SEMI_MAJOR.select(true, 6378388.0, citationArray, null, new String[0]);
        SEMI_MINOR = UniversalParameters.SEMI_MINOR.select(true, 6356911.9461279465, citationArray, null, new String[0]);
        CENTRAL_MERIDIAN = UniversalParameters.CENTRAL_MERIDIAN.select(true, 173.0, citationArray, null, "Longitude of natural origin", "central_meridian", "NatOriginLong");
        LATITUDE_OF_ORIGIN = UniversalParameters.LATITUDE_OF_ORIGIN.select(true, -41.0, citationArray, null, "Latitude of natural origin", "latitude_of_origin", "NatOriginLat");
        FALSE_EASTING = UniversalParameters.FALSE_EASTING.select(true, 2510000.0, citationArray, null, "False easting", "FalseEasting");
        FALSE_NORTHING = UniversalParameters.FALSE_NORTHING.select(true, 6023150.0, citationArray, null, "False northing", "FalseNorthing");
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "New_Zealand_Map_Grid"), new NamedIdentifier(Citations.EPSG, "New Zealand Map Grid"), new IdentifierCode(Citations.EPSG, 9811), new NamedIdentifier(Citations.GEOTIFF, "CT_NewZealandMapGrid"), new IdentifierCode(Citations.GEOTIFF, 26), new NamedIdentifier(Citations.PROJ4, "nzmg")}, null, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING}, 1);
    }
}

