/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.util.Arrays;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.SeparableTransform;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.LenientComparable;
import org.geotoolkit.util.XArrays;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public class DimensionFilter {
    public static final Hints.Key INSTANCE = new Hints.Key(DimensionFilter.class);
    private int[] sourceDimensions;
    private int[] targetDimensions;
    private final MathTransformFactory factory;

    public DimensionFilter() {
        this(FactoryFinder.getMathTransformFactory(null));
    }

    public DimensionFilter(Hints hints) {
        this(FactoryFinder.getMathTransformFactory(hints));
    }

    public DimensionFilter(MathTransformFactory mathTransformFactory) {
        this.factory = mathTransformFactory;
    }

    public static DimensionFilter getInstance(Hints hints) {
        DimensionFilter dimensionFilter;
        if (hints != null && (dimensionFilter = (DimensionFilter)hints.get(INSTANCE)) != null) {
            dimensionFilter.clear();
            return dimensionFilter;
        }
        return new DimensionFilter(hints);
    }

    public void clear() {
        this.sourceDimensions = null;
        this.targetDimensions = null;
    }

    public void addSourceDimension(int n) throws IllegalArgumentException {
        this.sourceDimensions = DimensionFilter.add(this.sourceDimensions, n);
    }

    public void addSourceDimensions(int ... nArray) throws IllegalArgumentException {
        this.sourceDimensions = DimensionFilter.add(this.sourceDimensions, nArray);
    }

    public void addSourceDimensionRange(int n, int n2) throws IllegalArgumentException {
        this.sourceDimensions = DimensionFilter.add(this.sourceDimensions, n, n2);
    }

    public int[] getSourceDimensions() throws IllegalStateException {
        if (this.sourceDimensions != null) {
            return (int[])this.sourceDimensions.clone();
        }
        throw new IllegalStateException();
    }

    public void addTargetDimension(int n) throws IllegalArgumentException {
        this.targetDimensions = DimensionFilter.add(this.targetDimensions, n);
    }

    public void addTargetDimensions(int ... nArray) throws IllegalArgumentException {
        this.targetDimensions = DimensionFilter.add(this.targetDimensions, nArray);
    }

    public void addTargetDimensionRange(int n, int n2) throws IllegalArgumentException {
        this.targetDimensions = DimensionFilter.add(this.targetDimensions, n, n2);
    }

    public int[] getTargetDimensions() throws IllegalStateException {
        if (this.targetDimensions != null) {
            return (int[])this.targetDimensions.clone();
        }
        throw new IllegalStateException();
    }

    public MathTransform separate(MathTransform mathTransform) throws FactoryException {
        Object object;
        if (mathTransform instanceof SeparableTransform && (object = (Object)((SeparableTransform)((Object)mathTransform)).subTransform(this.sourceDimensions, this.targetDimensions)) != null) {
            if (this.sourceDimensions == null) {
                this.sourceDimensions = this.targetDimensions;
            }
            if (this.targetDimensions == null) {
                this.targetDimensions = this.sourceDimensions;
            }
            return object;
        }
        if (this.sourceDimensions == null) {
            this.sourceDimensions = DimensionFilter.series(0, mathTransform.getSourceDimensions());
            if (this.targetDimensions == null) {
                this.targetDimensions = DimensionFilter.series(0, mathTransform.getTargetDimensions());
                return mathTransform;
            }
            return this.separateOutput(mathTransform);
        }
        object = this.targetDimensions;
        mathTransform = this.separateInput(mathTransform);
        assert (XArrays.isSorted(this.targetDimensions, true));
        if (object != null) {
            int[] nArray = this.targetDimensions;
            this.targetDimensions = new int[((int[])object).length];
            for (int i = 0; i < ((int[])object).length; ++i) {
                int n = Arrays.binarySearch(nArray, object[i]);
                if (n < 0) {
                    throw new FactoryException(Errors.format(98));
                }
                this.targetDimensions[i] = n;
            }
            mathTransform = this.separateOutput(mathTransform);
            this.targetDimensions = object;
        }
        assert (this.sourceDimensions.length == mathTransform.getSourceDimensions()) : mathTransform;
        assert (this.targetDimensions.length == mathTransform.getTargetDimensions()) : mathTransform;
        return mathTransform;
    }

    private MathTransform separateInput(MathTransform mathTransform) throws FactoryException {
        int n;
        Object object;
        int n2;
        int n3;
        MathTransform mathTransform2;
        if (mathTransform instanceof SeparableTransform && (mathTransform2 = ((SeparableTransform)((Object)mathTransform)).subTransform(this.sourceDimensions, this.targetDimensions)) != null) {
            if (this.sourceDimensions == null) {
                this.sourceDimensions = this.targetDimensions;
            }
            if (this.targetDimensions == null) {
                this.targetDimensions = this.sourceDimensions;
            }
            return mathTransform2;
        }
        int n4 = mathTransform.getSourceDimensions();
        int n5 = mathTransform.getTargetDimensions();
        int n6 = this.sourceDimensions.length;
        int n7 = this.sourceDimensions[0];
        int n8 = this.sourceDimensions[n6 - 1] + 1;
        assert (XArrays.isSorted(this.sourceDimensions, true));
        if (n8 > n4) {
            throw new IllegalArgumentException(Errors.format(73, "sourceDimensions", n8 - 1));
        }
        if (n6 == n4) {
            assert (n7 == 0 && n8 == n4);
            this.targetDimensions = DimensionFilter.series(0, n5);
            return mathTransform;
        }
        if (mathTransform.isIdentity()) {
            this.targetDimensions = this.sourceDimensions;
            return this.factory.createAffineTransform(Matrices.create(n6 + 1));
        }
        if (mathTransform instanceof ConcatenatedTransform) {
            ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)mathTransform;
            int[] nArray = this.sourceDimensions;
            MathTransform mathTransform3 = this.separateInput(concatenatedTransform.transform1);
            this.sourceDimensions = this.targetDimensions;
            MathTransform mathTransform4 = this.separateInput(concatenatedTransform.transform2);
            this.sourceDimensions = nArray;
            return this.factory.createConcatenatedTransform(mathTransform3, mathTransform4);
        }
        if (mathTransform instanceof PassThroughTransform) {
            PassThroughTransform passThroughTransform = (PassThroughTransform)mathTransform;
            n3 = passThroughTransform.subTransform.getSourceDimensions();
            int n9 = passThroughTransform.subTransform.getTargetDimensions() - n3;
            int n10 = passThroughTransform.firstAffectedOrdinate;
            n2 = n10 + n3;
            object = new DimensionFilter(this.factory);
            for (int i = 0; i < this.sourceDimensions.length; ++i) {
                n = this.sourceDimensions[i];
                if (n >= n10 && n < n2) {
                    ((DimensionFilter)object).addSourceDimension(n - n10);
                    continue;
                }
                if (n >= n2) {
                    n += n9;
                }
                this.targetDimensions = DimensionFilter.add(this.targetDimensions, n);
            }
            if (((DimensionFilter)object).sourceDimensions == null) {
                return this.factory.createAffineTransform(Matrices.create(n6 + 1));
            }
            MathTransform mathTransform5 = super.separateInput(passThroughTransform.subTransform);
            n = 0;
            while (n < ((DimensionFilter)object).targetDimensions.length) {
                int n11 = n++;
                ((DimensionFilter)object).targetDimensions[n11] = ((DimensionFilter)object).targetDimensions[n11] + n10;
            }
            this.targetDimensions = DimensionFilter.add(this.targetDimensions, ((DimensionFilter)object).targetDimensions);
            if (DimensionFilter.containsAll(this.sourceDimensions, n7, n10) && DimensionFilter.containsAll(this.sourceDimensions, n2, n8)) {
                n = Math.max(0, n10 - n7);
                int n12 = Math.max(0, n8 - n2);
                return this.factory.createPassThroughTransform(n, mathTransform5, n12);
            }
            this.targetDimensions = null;
        }
        if (mathTransform instanceof LinearTransform) {
            int n13 = 0;
            n3 = 0;
            Matrix matrix = ((LinearTransform)mathTransform).getMatrix();
            assert (n4 + 1 == matrix.getNumCol() && n5 + 1 == matrix.getNumRow()) : matrix;
            Object object2 = new double[n5 + 1][];
            block2: for (n2 = 0; n2 < ((double[][])object2).length; ++n2) {
                object = new double[n6 + 1];
                int n14 = 0;
                n = 0;
                for (int i = 0; i < n4; ++i) {
                    double d = matrix.getElement(n2, i);
                    if (n < this.sourceDimensions.length && this.sourceDimensions[n] == i) {
                        object[n14++] = d;
                        ++n;
                        continue;
                    }
                    if (d != 0.0) continue block2;
                }
                object[n14++] = matrix.getElement(n2, n4);
                assert (n14 == ((Object)object).length) : n14;
                if (n2 == n5) {
                    n3 = 1;
                } else {
                    this.targetDimensions = DimensionFilter.add(this.targetDimensions, n2);
                }
                object2[n13++] = (double[])object;
            }
            object2 = (double[][])XArrays.resize(object2, n13);
            if (n3 != 0) {
                return this.factory.createAffineTransform(new GeneralMatrix((double[][])object2));
            }
        }
        throw new FactoryException(Errors.format(98));
    }

    private MathTransform separateOutput(MathTransform mathTransform) throws FactoryException {
        int n;
        int n2;
        LenientComparable lenientComparable;
        int n3 = mathTransform.getSourceDimensions();
        int n4 = mathTransform.getTargetDimensions();
        int n5 = this.targetDimensions.length;
        int n6 = this.targetDimensions[0];
        int n7 = this.targetDimensions[n5 - 1];
        assert (XArrays.isSorted(this.targetDimensions, true));
        if (n7 > n4) {
            throw new IllegalArgumentException(Errors.format(73, "targetDimensions", n7));
        }
        if (n5 == n4) {
            assert (n6 == 0 && n7 == n4);
            return mathTransform;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = n4;
        if (mathTransform instanceof PassThroughTransform) {
            lenientComparable = (PassThroughTransform)mathTransform;
            n2 = ((PassThroughTransform)lenientComparable).firstAffectedOrdinate;
            n = n2 + ((PassThroughTransform)lenientComparable).subTransform.getTargetDimensions();
            if (!DimensionFilter.containsAny(this.targetDimensions, n2, n)) {
                mathTransform = null;
                n10 = n3;
                n8 = n2;
                n9 = n2 + ((PassThroughTransform)lenientComparable).subTransform.getSourceDimensions() - n;
            }
        }
        lenientComparable = Matrices.create(n5 + 1, n10 + 1);
        lenientComparable.setZero();
        for (n2 = 0; n2 < n5; ++n2) {
            n = this.targetDimensions[n2];
            if (n >= n8) {
                n += n9;
            }
            lenientComparable.setElement(n2, n, 1.0);
        }
        lenientComparable.setElement(n5, n10, 1.0);
        MathTransform mathTransform2 = this.factory.createAffineTransform((Matrix)((Object)lenientComparable));
        if (mathTransform != null) {
            mathTransform2 = this.factory.createConcatenatedTransform(mathTransform, mathTransform2);
        }
        return mathTransform2;
    }

    private static boolean containsAll(int[] nArray, int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (nArray != null) {
            assert (XArrays.isSorted(nArray, true));
            int n3 = Arrays.binarySearch(nArray, n);
            if (n3 >= 0 && (n3 += --n2 - n) >= 0 && n3 < nArray.length) {
                return nArray[n3] == n2;
            }
        }
        return false;
    }

    private static boolean containsAny(int[] nArray, int n, int n2) {
        if (n2 == n) {
            return true;
        }
        if (nArray != null) {
            assert (XArrays.isSorted(nArray, true));
            int n3 = Arrays.binarySearch(nArray, n);
            if (n3 >= 0) {
                return true;
            }
            return (n3 ^= 0xFFFFFFFF) < nArray.length && nArray[n3] < n2;
        }
        return false;
    }

    private static int[] add(int[] nArray, int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format(73, "dimension", n));
        }
        if (nArray == null) {
            return new int[]{n};
        }
        assert (XArrays.isSorted(nArray, true));
        int n2 = Arrays.binarySearch(nArray, n);
        if (n2 < 0) {
            nArray = XArrays.insert(nArray, n2 ^= 0xFFFFFFFF, 1);
            nArray[n2] = n;
        }
        assert (Arrays.binarySearch(nArray, n) == n2);
        return nArray;
    }

    private static int[] add(int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (nArray2.length != 0) {
            DimensionFilter.ensureValidSeries(nArray2);
            if (nArray == null) {
                nArray = (int[])nArray2.clone();
            } else {
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray = DimensionFilter.add(nArray, nArray2[i]);
                }
            }
        }
        return nArray;
    }

    private static int[] add(int[] nArray, int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException(Errors.format(14, n, n2));
        }
        if (nArray == null) {
            nArray = DimensionFilter.series(n, n2);
        } else {
            while (n < n2) {
                nArray = DimensionFilter.add(nArray, n++);
            }
        }
        assert (DimensionFilter.containsAll(nArray, n, n2));
        return nArray;
    }

    private static int[] series(int n, int n2) throws IllegalArgumentException {
        int[] nArray = new int[n2 - n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + n;
        }
        return nArray;
    }

    private static void ensureValidSeries(int[] nArray) throws IllegalArgumentException {
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 <= n) {
                throw new IllegalArgumentException(Errors.format(73, "dimensions[" + i + ']', n2));
            }
            n = n2;
        }
    }
}

