/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import org.geotoolkit.temporal.object.DefaultDuration;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

public class DefaultPeriodDuration
extends DefaultDuration
implements PeriodDuration {
    private static final InternationalString DESIGNATOR = new SimpleInternationalString("P");
    private InternationalString years;
    private InternationalString months;
    private InternationalString weeks;
    private InternationalString days;
    private static final InternationalString TIME_INDICATOR = new SimpleInternationalString("T");
    private InternationalString hours;
    private InternationalString minutes;
    private InternationalString seconds;

    public DefaultPeriodDuration(InternationalString years, InternationalString months, InternationalString weeks, InternationalString days, InternationalString hours, InternationalString minutes, InternationalString seconds) {
        this.years = years;
        this.months = months;
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public DefaultPeriodDuration(long durationInMilliSeconds) {
        SimpleInternationalString _years = null;
        SimpleInternationalString _months = null;
        SimpleInternationalString _week = null;
        SimpleInternationalString _days = null;
        SimpleInternationalString _hours = null;
        SimpleInternationalString _minutes = null;
        SimpleInternationalString _seconds = null;
        long temp = durationInMilliSeconds / 31536000000L;
        if (temp >= 1L) {
            _years = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * 31536000000L;
        }
        this.years = _years;
        temp = durationInMilliSeconds / 2628000000L;
        if (temp >= 1L) {
            _months = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * 2628000000L;
        }
        this.months = _months;
        temp = durationInMilliSeconds / 604800000L;
        if (temp >= 1L) {
            _week = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * 604800000L;
        }
        this.weeks = _week;
        temp = durationInMilliSeconds / 86400000L;
        if (temp >= 1L) {
            _days = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * 86400000L;
        }
        this.days = _days;
        temp = durationInMilliSeconds / 3600000L;
        if (temp >= 1L) {
            _hours = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * 3600000L;
        }
        this.hours = _hours;
        temp = durationInMilliSeconds / 60000L;
        if (temp >= 1L) {
            _minutes = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * 60000L;
        }
        this.minutes = _minutes;
        temp = durationInMilliSeconds / 1000L;
        if (temp >= 1L) {
            _seconds = new SimpleInternationalString(String.valueOf(temp));
            durationInMilliSeconds -= temp * 1000L;
        }
        this.seconds = _seconds;
    }

    @Override
    public InternationalString getDesignator() {
        return DESIGNATOR;
    }

    @Override
    public InternationalString getYears() {
        return this.years;
    }

    @Override
    public InternationalString getMonths() {
        return this.months;
    }

    @Override
    public InternationalString getDays() {
        return this.days;
    }

    @Override
    public InternationalString getTimeIndicator() {
        return TIME_INDICATOR;
    }

    @Override
    public InternationalString getHours() {
        return this.hours;
    }

    @Override
    public InternationalString getMinutes() {
        return this.minutes;
    }

    @Override
    public InternationalString getSeconds() {
        return this.seconds;
    }

    public void setYears(InternationalString years) {
        this.years = years;
    }

    public void setMonths(InternationalString months) {
        this.months = months;
    }

    public void setDays(InternationalString days) {
        this.days = days;
    }

    public void setHours(InternationalString hours) {
        this.hours = hours;
    }

    public void setMinutes(InternationalString minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(InternationalString seconds) {
        this.seconds = seconds;
    }

    public InternationalString getWeek() {
        return this.weeks;
    }

    public void setWeek(InternationalString week) {
        this.weeks = week;
    }

    @Override
    public long getTimeInMillis() {
        String periodDescription = this.toString();
        long response = 0L;
        if ((periodDescription = periodDescription.substring(1)).indexOf(89) != -1) {
            int nbYear = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(89)));
            response += (long)nbYear * 31536000000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(89) + 1);
        }
        if (periodDescription.indexOf(77) != -1 && periodDescription.indexOf(84) == -1 || periodDescription.indexOf(84) != -1 && periodDescription.indexOf(77) < periodDescription.indexOf(84) && periodDescription.indexOf(77) != -1) {
            int nbMonth = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(77)));
            response += (long)nbMonth * 2628000000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(77) + 1);
        }
        if (periodDescription.indexOf(87) != -1) {
            int nbWeek = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(87)));
            response += (long)nbWeek * 604800000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(87) + 1);
        }
        if (periodDescription.indexOf(68) != -1) {
            int nbDay = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(68)));
            response += (long)nbDay * 86400000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(68) + 1);
        }
        if (periodDescription.indexOf(84) != -1) {
            periodDescription = periodDescription.substring(1);
        }
        if (periodDescription.indexOf(72) != -1) {
            int nbHour = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(72)));
            response += (long)nbHour * 3600000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(72) + 1);
        }
        if (periodDescription.indexOf(77) != -1) {
            int nbMin = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(77)));
            response += (long)nbMin * 60000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(77) + 1);
        }
        if (periodDescription.indexOf(83) != -1) {
            int nbSec = Integer.parseInt(periodDescription.substring(0, periodDescription.indexOf(83)));
            response += (long)nbSec * 1000L;
            periodDescription = periodDescription.substring(periodDescription.indexOf(83) + 1);
        }
        if (periodDescription.length() != 0) {
            throw new IllegalArgumentException("The period duration string is malformed");
        }
        return response;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultPeriodDuration) {
            DefaultPeriodDuration that = (DefaultPeriodDuration)object;
            return Utilities.equals(this.days, that.days) && Utilities.equals(this.hours, that.hours) && Utilities.equals(this.minutes, that.minutes) && Utilities.equals(this.months, that.months) && Utilities.equals(this.seconds, that.seconds) && Utilities.equals(this.years, that.years);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.days != null ? this.days.hashCode() : 0);
        hash = 37 * hash + (this.hours != null ? this.hours.hashCode() : 0);
        hash = 37 * hash + (this.minutes != null ? this.minutes.hashCode() : 0);
        hash = 37 * hash + (this.months != null ? this.months.hashCode() : 0);
        hash = 37 * hash + (this.seconds != null ? this.seconds.hashCode() : 0);
        hash = 37 * hash + (this.years != null ? this.years.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append(DESIGNATOR);
        if (this.years != null) {
            s2.append(this.years).append('Y');
        }
        if (this.months != null) {
            s2.append(this.months).append('M');
        }
        if (this.weeks != null) {
            s2.append(this.weeks).append('W');
        }
        if (this.days != null) {
            s2.append(this.days).append('D');
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            s2.append(TIME_INDICATOR);
        }
        if (this.hours != null) {
            s2.append(this.hours).append('H');
        }
        if (this.minutes != null) {
            s2.append(this.minutes).append('M');
        }
        if (this.seconds != null) {
            s2.append(this.seconds).append('S');
        }
        return s2.toString();
    }
}

