/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import net.jcip.annotations.Immutable;
import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Range;
import org.geotoolkit.util.converter.Numbers;

@Immutable
public class NumberRange<T extends Number>
extends Range<T> {
    private static final long serialVersionUID = -818167965963008231L;

    public static NumberRange<Byte> create(byte by, byte by2) {
        return NumberRange.create(by, true, by2, true);
    }

    public static NumberRange<Byte> create(byte by, boolean bl, byte by2, boolean bl2) {
        return new NumberRange<Byte>(Byte.class, by, bl, by2, bl2);
    }

    public static NumberRange<Short> create(short s2, short s3) {
        return NumberRange.create(s2, true, s3, true);
    }

    public static NumberRange<Short> create(short s2, boolean bl, short s3, boolean bl2) {
        return new NumberRange<Short>(Short.class, s2, bl, s3, bl2);
    }

    public static NumberRange<Integer> create(int n, int n2) {
        return NumberRange.create(n, true, n2, true);
    }

    public static NumberRange<Integer> create(int n, boolean bl, int n2, boolean bl2) {
        return new NumberRange<Integer>(Integer.class, n, bl, n2, bl2);
    }

    public static NumberRange<Long> create(long l, long l2) {
        return NumberRange.create(l, true, l2, true);
    }

    public static NumberRange<Long> create(long l, boolean bl, long l2, boolean bl2) {
        return new NumberRange<Long>(Long.class, l, bl, l2, bl2);
    }

    public static NumberRange<Float> create(float f, float f2) {
        return NumberRange.create(f, true, f2, true);
    }

    public static NumberRange<Float> create(float f, boolean bl, float f2, boolean bl2) {
        return new NumberRange<Float>(Float.class, NumberRange.valueOf(f, Float.NEGATIVE_INFINITY), bl, NumberRange.valueOf(f2, Float.POSITIVE_INFINITY), bl2);
    }

    public static NumberRange<Double> create(double d, double d2) {
        return NumberRange.create(d, true, d2, true);
    }

    public static NumberRange<Double> create(double d, boolean bl, double d2, boolean bl2) {
        return new NumberRange<Double>(Double.class, NumberRange.valueOf(d, Double.NEGATIVE_INFINITY), bl, NumberRange.valueOf(d2, Double.POSITIVE_INFINITY), bl2);
    }

    public static NumberRange<?> createBestFit(Number number, boolean bl, Number number2, boolean bl2) {
        Class<? extends Number> clazz = Numbers.widestClass(Numbers.finestClass(number), Numbers.finestClass(number2));
        return clazz == null ? null : new NumberRange<Number>(clazz, Numbers.cast(number, clazz), bl, Numbers.cast(number2, clazz), bl2);
    }

    public NumberRange(Class<T> clazz, T t, T t2) {
        super(clazz, (Comparable)t, (Comparable)t2);
    }

    public NumberRange(Class<T> clazz, T t, boolean bl, T t2, boolean bl2) {
        super(clazz, (Comparable)t, bl, (Comparable)t2, bl2);
    }

    public NumberRange(Class<T> clazz, ValueRange valueRange) {
        super(clazz, (Comparable)Numbers.cast(NumberRange.valueOf(valueRange.minimum(), Double.NEGATIVE_INFINITY), clazz), valueRange.isMinIncluded(), (Comparable)Numbers.cast(NumberRange.valueOf(valueRange.maximum(), Double.POSITIVE_INFINITY), clazz), valueRange.isMaxIncluded());
    }

    NumberRange(Class<T> clazz, Range<? extends Number> range) throws IllegalArgumentException {
        this(clazz, Numbers.cast(range.getMinValue(), clazz), range.isMinIncluded(), Numbers.cast(range.getMaxValue(), clazz), range.isMaxIncluded());
    }

    public NumberRange(Range<T> range) {
        super(range.getElementType(), range.getMinValue(), range.isMinIncluded(), range.getMaxValue(), range.isMaxIncluded());
    }

    @Override
    NumberRange<T> create(T t, boolean bl, T t2, boolean bl2) {
        return new NumberRange<T>(this.elementClass, t, bl, t2, bl2);
    }

    private static Float valueOf(float f, float f2) {
        return f != f2 ? Float.valueOf(f) : null;
    }

    private static Double valueOf(double d, double d2) {
        return d != d2 ? Double.valueOf(d) : null;
    }

    @Override
    final void checkElementClass() throws IllegalArgumentException {
        NumberRange.ensureNumberClass(this.elementClass);
        super.checkElementClass();
    }

    private static Class<? extends Number> getElementType(Range<?> range) {
        ArgumentChecks.ensureNonNull("range", range);
        Class clazz = range.elementClass;
        NumberRange.ensureNumberClass(clazz);
        return clazz;
    }

    private static void ensureNumberClass(Class<?> clazz) throws IllegalArgumentException {
        if (!Number.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Errors.format(76, clazz, Number.class));
        }
    }

    public static <N extends Number> NumberRange<N> wrap(Range<N> range) {
        if (range instanceof NumberRange) {
            return (NumberRange)range;
        }
        return new NumberRange<N>(range);
    }

    <N extends Number> NumberRange<N> convertAndCast(Range<? extends Number> range, Class<N> clazz) throws IllegalArgumentException {
        if (clazz.equals(range.getElementType())) {
            return NumberRange.wrap(range);
        }
        return new NumberRange<N>(clazz, range);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> clazz) throws IllegalArgumentException {
        return this.convertAndCast(this, clazz);
    }

    NumberRange<T>[] newArray(int n) {
        return new NumberRange[n];
    }

    public boolean contains(Number number) throws IllegalArgumentException {
        if (number != null && !(number instanceof Comparable)) {
            throw new IllegalArgumentException(Errors.format(146, number.getClass()));
        }
        return this.contains((Comparable)((Object)number));
    }

    @Override
    public boolean contains(Comparable<?> comparable) throws IllegalArgumentException {
        if (comparable == null) {
            return false;
        }
        ArgumentChecks.ensureCanCast("value", Number.class, comparable);
        Number number = (Number)((Object)comparable);
        Class<? extends Number> clazz = Numbers.widestClass(this.elementClass, number.getClass());
        number = Numbers.cast(number, clazz);
        return this.castTo(clazz).containsNC((Number)((Object)((Comparable)((Object)number))));
    }

    @Override
    public boolean contains(Range<?> range) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementClass, NumberRange.getElementType(range));
        range = this.convertAndCast(range, clazz);
        return this.castTo(clazz).containsNC(range);
    }

    @Override
    public boolean intersects(Range<?> range) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementClass, NumberRange.getElementType(range));
        range = this.convertAndCast(range, clazz);
        return this.castTo(clazz).intersectsNC(range);
    }

    @Override
    public NumberRange<?> union(Range<?> range) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementClass, NumberRange.getElementType(range));
        range = this.convertAndCast(range, clazz);
        return (NumberRange)this.castTo(clazz).unionNC(range);
    }

    @Override
    public NumberRange<?> intersect(Range<?> range) throws IllegalArgumentException {
        Class<Number> clazz = NumberRange.getElementType(range);
        Class<? extends Number> clazz2 = Numbers.widestClass(this.elementClass, clazz);
        range = this.castTo(clazz2).intersectNC(this.convertAndCast(range, clazz2));
        clazz2 = Numbers.finestClass(this.elementClass, clazz);
        clazz2 = Numbers.widestClass(clazz2, Numbers.finestClass((Number)range.minValue));
        clazz2 = Numbers.widestClass(clazz2, Numbers.finestClass((Number)range.maxValue));
        return this.convertAndCast(range, clazz2);
    }

    public NumberRange<?>[] subtract(Range<?> range) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementClass, NumberRange.getElementType(range));
        return (NumberRange[])this.castTo(clazz).subtractNC(this.convertAndCast(range, clazz));
    }

    public double getMinimum() {
        Number number = (Number)this.getMinValue();
        return number != null ? number.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinimum(boolean bl) {
        double d = this.getMinimum();
        if (bl != this.isMinIncluded()) {
            d = NumberRange.next(this.getElementType(), d, bl);
        }
        return d;
    }

    public double getMaximum() {
        Number number = (Number)this.getMaxValue();
        return number != null ? number.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaximum(boolean bl) {
        double d = this.getMaximum();
        if (bl != this.isMaxIncluded()) {
            d = NumberRange.next(this.getElementType(), d, !bl);
        }
        return d;
    }

    private static double next(Class<?> clazz, double d, boolean bl) {
        if (!bl) {
            d = -d;
        }
        if (Numbers.isInteger(clazz)) {
            d += 1.0;
        } else if (clazz.equals(Float.class)) {
            d = Math.nextUp((float)d);
        } else if (clazz.equals(Double.class)) {
            d = Math.nextUp(d);
        } else {
            throw new IllegalStateException(Errors.format(226, clazz));
        }
        if (!bl) {
            d = -d;
        }
        return d;
    }
}

