/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.util.XArrays;

public final class StringUtilities {
    public static final String TREE_BLANK = "\u00a0\u00a0\u00a0\u00a0";
    public static final String TREE_LINE = "\u00a0\u00a0\u2502\u00a0";
    public static final String TREE_CROSS = "\u00a0\u00a0\u251c\u2500";
    public static final String TREE_END = "\u00a0\u00a0\u2514\u2500";
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final String[] URLhex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};

    private StringUtilities() {
    }

    public static String encodeToUTF8URL(String s2) {
        StringBuilder sbuf = new StringBuilder();
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char ch = s2.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
                continue;
            }
            if (ch == ' ') {
                sbuf.append('+');
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                sbuf.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                sbuf.append(URLhex[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                sbuf.append(URLhex[0xC0 | ch >> 6]);
                sbuf.append(URLhex[0x80 | ch & 0x3F]);
                continue;
            }
            sbuf.append(URLhex[0xE0 | ch >> 12]);
            sbuf.append(URLhex[0x80 | ch >> 6 & 0x3F]);
            sbuf.append(URLhex[0x80 | ch & 0x3F]);
        }
        return sbuf.toString();
    }

    public static String decodeUTF8URL(String s2) {
        StringBuilder sbuf = new StringBuilder();
        int l = s2.length();
        int ch = -1;
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            int b;
            char c = s2.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    ch = s2.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s2.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                case '+': {
                    b = 32;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more != 0) continue;
                sbuf.append((char)sumb);
                continue;
            }
            if ((b & 0x80) == 0) {
                sbuf.append((char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
                continue;
            }
            if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
                continue;
            }
            if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
                continue;
            }
            if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
                continue;
            }
            sumb = b & 1;
            more = 5;
        }
        return sbuf.toString();
    }

    public static String MD5encode(String key) {
        byte[] uniqueKey = key.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("no MD5 support in this VM");
        }
        StringBuffer hashString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
                continue;
            }
            hashString.append(hex.substring(hex.length() - 2));
        }
        return hashString.toString();
    }

    @Deprecated
    public static String cleanString(String str) {
        if (str != null) {
            str = str.replaceAll("\u00c3\u00a9", "\u00e9");
            str = str.replaceAll("\u00c3\u00aa", "\u00ea");
            str = str.replaceAll("\u00c3\u00a8", "\u00e8");
            str = str.replaceAll("\"", "'");
            str = str.replaceAll("\u00c2\u00b0", "\u00b0");
            str = str.replaceAll("\u00c3\u00af", "\u00ef");
            str = str.replaceAll("\u00c3\u00b4", "\u00f4");
            str = str.replaceAll("\u00e0\u00a7", "\u00e7");
            str = str.replaceAll("\u00c3", "\u00e0");
            str = str.replaceAll("\u00c2", "");
        }
        return str;
    }

    @Deprecated
    public static String cleanSpecialCharacter(String s2) {
        if (s2 != null) {
            s2 = s2.replace('\u00e9', 'e');
            s2 = s2.replace('\u00e8', 'e');
            s2 = s2.replace('\u00e0', 'a');
            s2 = s2.replace('\u00c9', 'E');
        }
        return s2;
    }

    public static String clean(String s2) {
        s2 = s2.trim();
        s2 = s2.replace("\t", "");
        s2 = s2.replace("\n", "");
        s2 = s2.replace("\r", "");
        return s2;
    }

    public static List<String> cleanStrings(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s2 : list) {
            s2 = s2.replace(" ", "");
            s2 = s2.replace("\t", "");
            s2 = s2.replace("\n", "");
            result.add(s2);
        }
        return result;
    }

    public static boolean containsIgnoreCase(List<String> list, String str) {
        boolean strAvailable = false;
        if (list != null) {
            for (String s2 : list) {
                if (!s2.equalsIgnoreCase(str)) continue;
                strAvailable = true;
                break;
            }
        }
        return strAvailable;
    }

    @Deprecated
    public static String convertSpacesForUrl(String s2) {
        return s2.replaceAll(" ", "%20");
    }

    public static String firstToUpper(String s2) {
        if (s2 != null && !s2.isEmpty()) {
            String first = s2.substring(0, 1);
            String result = s2.substring(1);
            result = first.toUpperCase() + result;
            return result;
        }
        return s2;
    }

    public static int[] getIndexes(String s2, char occ) {
        int pos = s2.indexOf(occ);
        if (pos < 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] indexes = new int[]{pos};
        pos = s2.indexOf(occ, pos + 1);
        while (pos >= 0) {
            int end = indexes.length;
            indexes = XArrays.resize(indexes, end + 1);
            indexes[end] = pos;
            pos = s2.indexOf(occ, pos + 1);
        }
        return indexes;
    }

    public static String htmlEncodeSpecialChars(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c > '\u007f') {
                sb.append("&#").append((int)c).append(";");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean matchesStringfromList(List<String> list, String str) {
        boolean strAvailable = false;
        for (String s2 : list) {
            Pattern pattern = Pattern.compile(str, 130);
            Matcher matcher = pattern.matcher(s2);
            if (!matcher.find()) continue;
            strAvailable = true;
        }
        return strAvailable;
    }

    public static String replacePrefix(String s2, String localPart, String prefix) {
        return s2.replaceAll("[a-zA-Z0-9]*:" + localPart, prefix + ":" + localPart);
    }

    public static String removeXmlns(String xml) {
        String s2 = xml;
        s2 = s2.replaceAll("xmlns=\"[^\"]*\" ", "");
        s2 = s2.replaceAll("xmlns=\"[^\"]*\"", "");
        s2 = s2.replaceAll("xmlns:[^=]*=\"[^\"]*\" ", "");
        s2 = s2.replaceAll("xmlns:[^=]*=\"[^\"]*\"", "");
        return s2;
    }

    public static String removePrefix(String s2) {
        int i = s2.indexOf(58);
        if (i != -1) {
            s2 = s2.substring(i + 1, s2.length());
        }
        return s2;
    }

    @Deprecated
    public static boolean startsWithIgnoreCase(String string1, String string2) {
        return string1.toUpperCase().startsWith(string2.toUpperCase());
    }

    public static String toCommaSeparatedValues(Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object obj : values) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(obj);
        }
        return builder.toString();
    }

    public static String toCommaSeparatedValues(Object ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(values[i]);
        }
        return builder.toString();
    }

    public static List<String> toStringList(String commaSeparatedString) {
        return StringUtilities.toStringList(commaSeparatedString, ',');
    }

    @Deprecated
    public static List<String> toStringList(String toSplit, char separator) {
        if (toSplit == null) {
            return Collections.emptyList();
        }
        ArrayList<String> strings = new ArrayList<String>();
        int last = 0;
        toSplit = toSplit.trim();
        int i = toSplit.indexOf(separator);
        while (i >= 0) {
            strings.add(toSplit.substring(last, i).trim());
            last = ++i;
            i = toSplit.indexOf(separator, i);
        }
        strings.add(toSplit.substring(last).trim());
        return strings;
    }

    public static String transformCodeName(String code) {
        StringBuilder result = new StringBuilder();
        while (code.indexOf(95) != -1) {
            String tmp = code.substring(0, code.indexOf(95)).toLowerCase();
            result.append(StringUtilities.firstToUpper(tmp));
            code = code.substring(code.indexOf(95) + 1, code.length());
        }
        code = code.toLowerCase();
        result.append(StringUtilities.firstToUpper(code));
        return result.toString();
    }

    public static String toStringTree(Object ... objects) {
        return Trees.toString("", Arrays.asList(objects));
    }
}

