/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSClient;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseFixture {
    protected static final String ETS_PKG = "/org/opengis/cite/iso19142";
    private static final int MAX_RSP_ATTR_LENGTH = 4096;
    private static final String REQ_ATTR = "request";
    private static final String REQ_POST_ATTR = "post-request";
    private static final String RSP_ATTR = "response";
    protected Document wfsMetadata;
    protected WFSClient wfsClient;
    protected Set<ProtocolBinding> supportedBindings;
    protected List<QName> featureTypes;
    protected Map<QName, FeatureTypeInfo> featureInfo;
    protected DocumentBuilder docBuilder;
    protected static final String TNS_PREFIX = "tns";
    protected Document reqEntity;
    protected Document rspEntity;
    protected String wfsVersion;

    public void setWfsClient(WFSClient wfsClient) {
        this.wfsClient = wfsClient;
    }

    @BeforeClass(alwaysRun=true)
    public void initBaseFixture(ITestContext testContext) {
        if (null != this.featureTypes && !this.featureTypes.isEmpty()) {
            return;
        }
        this.wfsVersion = (String)testContext.getSuite().getAttribute(SuiteAttribute.WFS_VERSION.getName());
        this.wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        this.wfsClient = new WFSClient(this.wfsMetadata);
        Set<ProtocolBinding> protoBindings = ServiceMetadataUtils.getGlobalBindings(this.wfsMetadata);
        if (protoBindings.isEmpty()) {
            TestSuiteLogger.log(Level.WARNING, "No protocol bindings found in capabilities document.");
        }
        this.supportedBindings = protoBindings;
        this.featureTypes = ServiceMetadataUtils.getFeatureTypes(this.wfsMetadata);
        this.featureInfo = (Map)testContext.getSuite().getAttribute(SuiteAttribute.FEATURE_INFO.getName());
    }

    @BeforeClass
    public void initParser() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create DOM parser", e);
        }
    }

    @AfterMethod
    public void addAttributesOnTestFailure(ITestResult result) {
        if (result.getStatus() != 2) {
            return;
        }
        if (null != this.reqEntity) {
            String request = "";
            Object[] params = result.getParameters();
            if (WFSMessage.containsGetProtocolBinding(params)) {
                request = WFSMessage.transformEntityToKVP(new DOMSource(this.reqEntity));
            } else {
                ProtocolBinding binding = ProtocolBinding.POST;
                try {
                    String methodName = this.reqEntity.getFirstChild().getLocalName();
                    URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, methodName, binding);
                    result.setAttribute(REQ_POST_ATTR, endpoint.toString());
                }
                catch (Exception e) {
                    TestSuiteLogger.log(Level.WARNING, "Could not get POST endpoint URI", e);
                }
                request = XMLUtils.writeNodeToString(this.reqEntity);
            }
            result.setAttribute(REQ_ATTR, request);
        }
        if (null != this.rspEntity) {
            StringBuilder response = new StringBuilder(XMLUtils.writeNodeToString(this.rspEntity));
            if (response.length() > 4096) {
                response.delete(4096, response.length());
            }
            result.setAttribute(RSP_ATTR, response.toString());
        }
    }

    @DataProvider(name="protocol-binding")
    public Object[][] getProtocolBindings(ITestContext testContext) {
        if (null == this.supportedBindings) {
            this.initBaseFixture(testContext);
        }
        Object[][] bindings = new Object[this.supportedBindings.size()][];
        Iterator<ProtocolBinding> itr = this.supportedBindings.iterator();
        for (int i = 0; i < bindings.length; ++i) {
            bindings[i] = new Object[]{itr.next()};
        }
        return bindings;
    }

    @DataProvider(name="feature-types")
    public Object[][] getFeatureTypes() {
        Object[][] typeNames = new Object[this.featureTypes.size()][];
        Iterator<QName> itr = this.featureTypes.iterator();
        for (int i = 0; i < typeNames.length; ++i) {
            typeNames[i] = new Object[]{itr.next()};
        }
        return typeNames;
    }

    @DataProvider(name="instantiated-feature-types")
    public Iterator<Object[]> getInstantiatedFeatureTypes() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (QName typeName : this.featureTypes) {
            if (!this.featureInfo.get(typeName).isInstantiated()) continue;
            data.add(new Object[]{typeName});
        }
        return data.iterator();
    }

    @DataProvider(name="all-protocols-featureTypes")
    public Iterator<Object[]> allProtocolsAndFeatureTypes() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (ProtocolBinding binding : this.supportedBindings) {
            for (QName typeName : this.featureTypes) {
                params.add(new Object[]{binding, typeName});
            }
        }
        return params.iterator();
    }

    @DataProvider(name="protocol-featureType")
    public Iterator<Object[]> bindingAndAvailFeatureTypeProductSet(ITestContext testContext) {
        ISuite suite = testContext.getSuite();
        Document wfsMetadata = (Document)suite.getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null == wfsMetadata) {
            throw new NullPointerException("Service description not found in ITestContext");
        }
        Set<ProtocolBinding> globalBindings = ServiceMetadataUtils.getGlobalBindings(wfsMetadata);
        DataSampler sampler = (DataSampler)suite.getAttribute(SuiteAttribute.SAMPLER.getName());
        Map<QName, FeatureTypeInfo> featureInfo = sampler.getFeatureTypeInfo();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (ProtocolBinding binding : globalBindings) {
            for (FeatureTypeInfo typeInfo : featureInfo.values()) {
                if (!typeInfo.isInstantiated()) continue;
                Object[] tuple = new Object[]{binding, typeInfo.getTypeName()};
                paramList.add(tuple);
            }
        }
        return paramList.iterator();
    }

    protected Document extractBodyAsDocument(ClientResponse rsp) {
        Document entity = rsp.getEntity(Document.class);
        try {
            Element soapBody = (Element)XMLUtils.evaluateXPath(entity, "//soap11:Body/*[1] | //soap:Body/*[1]", null, XPathConstants.NODE);
            if (null != soapBody) {
                entity.replaceChild(soapBody, entity.getDocumentElement());
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        return entity;
    }
}

