/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.WFSClient;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ETSAssert {
    private static final Logger LOGR = Logger.getLogger(ETSAssert.class.getName());

    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName qName) {
        Assert.assertEquals(node.getLocalName(), qName.getLocalPart(), ErrorMessage.get("LocalName"));
        Assert.assertEquals(node.getNamespaceURI(), qName.getNamespaceURI(), ErrorMessage.get("NamespaceName"));
    }

    public static void assertXPath(String expr, Node context, Map<String, String> nsBindings) {
        boolean result = ETSAssert.evaluateXPathToBoolean(expr, context, nsBindings);
        Assert.assertTrue(result, ErrorMessage.format("XPathResult", context.getNodeName(), expr));
    }

    public static boolean evaluateXPathToBoolean(String expr, Node context, Map<String, String> nsBindings) {
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        LOGR.log(Level.FINE, "Evaluating \"{0}\" against context node:\n{1}", new Object[]{expr, XMLUtils.writeNodeToString(context)});
        try {
            boolean result = (Boolean)XMLUtils.evaluateXPath(context, expr, nsBindings, XPathConstants.BOOLEAN);
            LOGR.log(Level.FINE, "XPath result: " + result);
            return result;
        }
        catch (XPathExpressionException e) {
            String msg = ErrorMessage.format("XPathError", expr);
            LOGR.log(Level.WARNING, msg, e);
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertXPath2(String expr, Source source, Map<String, String> namespaceBindings) {
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, "Asserting XPath expression {0} against {1} ({2})", new Object[]{expr, source.getClass().getName(), source.getSystemId()});
        }
        XdmValue result = null;
        try {
            result = XMLUtils.evaluateXPath2(source, expr, namespaceBindings);
        }
        catch (SaxonApiException e) {
            throw new AssertionError((Object)ErrorMessage.format("XPathError", expr + e.getMessage()));
        }
        Assert.assertTrue(result.size() > 0, ErrorMessage.format("XPathResult", source.getSystemId(), expr));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse(errHandler.errorsDetected(), ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource) {
        SchematronValidator validator;
        try {
            validator = new SchematronValidator(new StreamSource(schemaRef.toString()), "#ALL");
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        Result result = validator.validate(xmlSource);
        Assert.assertFalse(validator.ruleViolationsDetected(), ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    public static void assertFeatureAvailability(String id, boolean isAvailable, WFSClient wfsClient) {
        NodeList result;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        Document rsp = wfsClient.invokeStoredQuery("http://www.opengis.net/def/query/OGC-WFS/0/GetFeatureById", params);
        String xpath = String.format("/*[@gml:id = '%s']", id);
        try {
            result = XMLUtils.evaluateXPath(rsp, xpath, null);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        if (isAvailable && result.getLength() == 0) {
            throw new AssertionError((Object)ErrorMessage.format("FeatureAvailability", result.getLength(), id));
        }
        if (!isAvailable && result.getLength() > 0) {
            throw new AssertionError((Object)ErrorMessage.format("FeatureAvailability", result.getLength(), id));
        }
    }

    public static void assertSimpleProperties(Element feature, Map<XSElementDeclaration, Object> expectedValues, Map<String, String> nsBindings) {
        for (Map.Entry<XSElementDeclaration, Object> property : expectedValues.entrySet()) {
            XSSimpleTypeDefinition propType;
            XSElementDeclaration propDecl = property.getKey();
            if (propDecl.getTypeDefinition().getTypeCategory() == 16) {
                propType = (XSSimpleTypeDefinition)propDecl.getTypeDefinition();
            } else {
                XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)propDecl.getTypeDefinition();
                propType = complexType.getSimpleType();
            }
            String expectedValue = XMLUtils.expandReferencesInText(property.getValue().toString());
            String expr = null;
            String nsPrefix = propDecl.getNamespace().equals("http://www.opengis.net/gml/3.2") ? "gml" : nsBindings.get(propDecl.getNamespace());
            expr = propType.getNumeric() ? String.format("number(%s:%s[1]) eq %s", nsPrefix, propDecl.getName(), expectedValue) : String.format("%s:%s[1] eq \"%s\"", nsPrefix, propDecl.getName(), expectedValue);
            ETSAssert.assertXPath2(expr, new DOMSource(feature), nsBindings);
        }
    }

    public static void assertDescendantElementCount(Document xmlEntity, QName elementName, int expectedCount) {
        NodeList features = xmlEntity.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals(features.getLength(), expectedCount, String.format("Unexpected number of %s descendant elements.", elementName));
    }

    public static void assertStatusCode(int actualCode, int[] expectedCodes) {
        Arrays.sort(expectedCodes);
        Assert.assertTrue(Arrays.binarySearch(expectedCodes, actualCode) >= 0, String.format("Expected status code(s) %s but received %d.", Arrays.toString(expectedCodes), actualCode));
    }

    public static void assertSimpleWFSCapabilities(Document doc) {
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("wfs-capabilities-2.0.sch", "SimpleWFSPhase");
        Result result = validator.validate(new DOMSource(doc, doc.getDocumentURI()), false);
        Assert.assertFalse(validator.ruleViolationsDetected(), ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    public static void assertFeatureCount(Document featureCollection, QName featureType, int expectedCount) {
        if (null != featureType) {
            NodeList features = featureCollection.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
            Assert.assertEquals(features.getLength(), expectedCount, String.format("Unexpected number of %s feature instances in response.", featureType));
        } else {
            NodeList features = featureCollection.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "member");
            Assert.assertEquals(features.getLength(), expectedCount, "Unexpected number of feature members in response.");
        }
    }

    public static void assertExceptionReport(Document rspEntity, String exceptionCode, String locator) {
        String expr = String.format("//ows11:Exception[@exceptionCode = '%s']", exceptionCode);
        NodeList nodeList = null;
        try {
            nodeList = XMLUtils.evaluateXPath(rspEntity, expr, Collections.singletonMap("http://www.opengis.net/ows/1.1", "ows11"));
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        Assert.assertTrue(nodeList.getLength() > 0, "Exception not found in response: " + expr);
        if (null != locator && !locator.isEmpty()) {
            Element exception = (Element)nodeList.item(0);
            String locatorValue = exception.getAttribute("locator").toLowerCase();
            Assert.assertTrue(locatorValue.contains(locator.toLowerCase()), String.format("Expected locator attribute to contain '%s']", locator));
        }
    }

    public static void assertSpatialReference(Document entity, String crsId) {
        NodeList srsNameNodes = null;
        try {
            srsNameNodes = XMLUtils.evaluateXPath(entity, "//*/@srsName", null);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        for (int i = 0; i < srsNameNodes.getLength(); ++i) {
            Attr attr = (Attr)srsNameNodes.item(i);
            Assert.assertEquals(attr.getValue(), crsId, String.format("Unexpected @srsName value on element %s", new QName(attr.getNamespaceURI(), attr.getLocalName())));
        }
    }

    public static void assertResultSetNotEmpty(Document entity, QName featureType) {
        NodeList features = null != featureType ? entity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart()) : entity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "member");
        Assert.assertTrue(features.getLength() > 0, String.format("Expected one or more feature instances in response (type: %s).", null != featureType ? featureType : "any"));
    }
}

