/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.lang.reflect.Method;
import java.util.List;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.RunInfo;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

class TestClass
extends NoOpTestClass
implements ITestClass {
    private static final long serialVersionUID = -8077917128278361294L;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient ITestMethodFinder m_testMethodFinder = null;
    private IClass m_iClass = null;
    private RunInfo m_runInfo = null;
    private String m_testName;
    private XmlTest m_xmlTest;
    private XmlClass m_xmlClass;

    protected TestClass(IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, RunInfo runInfo, XmlTest xmlTest, XmlClass xmlClass) {
        this.init(cls, testMethodFinder, annotationFinder, runInfo, xmlTest, xmlClass);
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    private void init(IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, RunInfo runInfo, XmlTest xmlTest, XmlClass xmlClass) {
        this.log(3, "Creating TestClass for " + cls);
        this.m_iClass = cls;
        this.m_testClass = cls.getRealClass();
        this.m_xmlTest = xmlTest;
        this.m_xmlClass = xmlClass;
        this.m_runInfo = runInfo;
        this.m_testMethodFinder = testMethodFinder;
        this.m_annotationFinder = annotationFinder;
        this.initTestClassesAndInstances();
        this.initMethods();
    }

    private void initTestClassesAndInstances() {
        Object[] instances;
        for (Object instance : instances = this.getInstances(false)) {
            if (!(instance instanceof ITest)) continue;
            this.m_testName = ((ITest)instance).getTestName();
            break;
        }
        if (this.m_testName == null) {
            this.m_testName = this.m_iClass.getTestName();
        }
    }

    @Override
    public Object[] getInstances(boolean create) {
        return this.m_iClass.getInstances(create);
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_iClass.getInstanceHashCodes();
    }

    @Override
    public int getInstanceCount() {
        return this.m_iClass.getInstanceCount();
    }

    @Override
    public void addInstance(Object instance) {
        this.m_iClass.addInstance(instance);
    }

    private void initMethods() {
        ITestNGMethod[] methods = this.m_testMethodFinder.getTestMethods(this.m_testClass, this.m_xmlTest);
        this.m_testMethods = this.createTestMethods(methods);
        for (Object instance : this.m_iClass.getInstances(false)) {
            this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.m_testMethodFinder.getBeforeSuiteMethods(this.m_testClass), this.m_annotationFinder, true, instance);
            this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.m_testMethodFinder.getAfterSuiteMethods(this.m_testClass), this.m_annotationFinder, false, instance);
            this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.m_testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), this.m_annotationFinder, true, instance);
            this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.m_testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), this.m_annotationFinder, false, instance);
            this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.m_testMethodFinder.getBeforeClassMethods(this.m_testClass), this.m_annotationFinder, true, instance);
            this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.m_testMethodFinder.getAfterClassMethods(this.m_testClass), this.m_annotationFinder, false, instance);
            this.m_beforeGroupsMethods = ConfigurationMethod.createBeforeConfigurationMethods(this.m_testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), this.m_annotationFinder, true, instance);
            this.m_afterGroupsMethods = ConfigurationMethod.createAfterConfigurationMethods(this.m_testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), this.m_annotationFinder, false, instance);
            this.m_beforeTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.m_testMethodFinder.getBeforeTestMethods(this.m_testClass), this.m_annotationFinder, true, instance);
            this.m_afterTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.m_testMethodFinder.getAfterTestMethods(this.m_testClass), this.m_annotationFinder, false, instance);
        }
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] methods) {
        List vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            Method m3 = tm.getMethod();
            if (m3.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                for (Object o : this.m_iClass.getInstances(false)) {
                    this.log(4, "Adding method " + tm + " on TestClass " + this.m_testClass);
                    vResult.add(new TestNGMethod(m3, this.m_annotationFinder, this.m_xmlTest, o));
                }
                continue;
            }
            this.log(4, "Rejecting method " + tm + " for TestClass " + this.m_testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private RunInfo getRunInfo() {
        return this.m_runInfo;
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.m_testMethodFinder;
    }

    private void log(int level, String s2) {
        Utils.log("TestClass", level, s2);
    }

    private static void ppp(String s2) {
        System.out.println("[TestClass] " + s2);
    }

    protected void dump() {
        System.out.println("===== Test class\n" + this.m_testClass.getName());
        for (ITestNGMethod m3 : this.m_beforeClassMethods) {
            System.out.println("  @BeforeClass " + m3);
        }
        for (ITestNGMethod m3 : this.m_beforeTestMethods) {
            System.out.println("  @BeforeMethod " + m3);
        }
        for (ITestNGMethod m3 : this.m_testMethods) {
            System.out.println("    @Test " + m3);
        }
        for (ITestNGMethod m3 : this.m_afterTestMethods) {
            System.out.println("  @AfterMethod " + m3);
        }
        for (ITestNGMethod m3 : this.m_afterClassMethods) {
            System.out.println("  @AfterClass " + m3);
        }
        System.out.println("======");
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.m_testClass).toString();
    }

    public IClass getIClass() {
        return this.m_iClass;
    }
}

