/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.querymgmt;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateStoredQueryTests
extends BaseFixture {
    public static final String QRY_GET_FEATURE_BY_TYPE = "urn:example:wfs2-query:GetFeatureByTypeName";
    public static final String QRY_GET_FEATURE_BY_NAME = "urn:example:wfs2-query:GetFeatureByName";
    public static final String QRY_INVALID_LANG = "urn:example:wfs2-query:InvalidLang";
    private List<String> createdStoredQueries = new ArrayList<String>(2);
    private DataSampler dataSampler;

    @BeforeClass
    public void initQueryFilterFixture(ITestContext testContext) {
        ISuite suite = testContext.getSuite();
        this.dataSampler = (DataSampler)suite.getAttribute(SuiteAttribute.SAMPLER.getName());
    }

    @BeforeClass
    public void deleteQueriesAtStart() {
        List<String> knownQueries = this.wfsClient.listStoredQueries();
        for (String queryId : new String[]{QRY_GET_FEATURE_BY_TYPE, QRY_GET_FEATURE_BY_NAME, QRY_INVALID_LANG}) {
            int status;
            if (!knownQueries.contains(queryId) || (status = this.wfsClient.deleteStoredQuery(queryId)) < 400) continue;
            throw new SkipException(String.format("[%s] Error dropping stored query: %s (status code was %d)", this.getClass().getName(), queryId, status));
        }
    }

    @AfterClass
    public void deleteQueriesAtEnd() {
        for (String queryId : this.createdStoredQueries) {
            int status = this.wfsClient.deleteStoredQuery(queryId);
            if (status < 400) continue;
            TestSuiteLogger.log(Level.WARNING, String.format("[%s] Error dropping stored query: %s (status code was %d)", this.getClass().getName(), queryId, status));
        }
        this.createdStoredQueries.clear();
    }

    @Test(description="See OGC 09-025: 14.2, 14.5.2")
    public void createGetFeatureByTypeName() {
        this.reqEntity = WFSMessage.createRequestEntity("/org/opengis/cite/iso19142/querymgmt/CreateStoredQuery-GetFeatureByTypeName", this.wfsVersion);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "CreateStoredQuery", ProtocolBinding.POST);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "CreateStoredQueryResponse"));
        this.createdStoredQueries.add(QRY_GET_FEATURE_BY_TYPE);
        for (QName featureTypeName : this.featureInfo.keySet()) {
            if (!((FeatureTypeInfo)this.featureInfo.get(featureTypeName)).isInstantiated()) continue;
            Map<String, Object> params = Collections.singletonMap("typeName", featureTypeName);
            Document doc = this.wfsClient.invokeStoredQuery(QRY_GET_FEATURE_BY_TYPE, params);
            ETSAssert.assertResultSetNotEmpty(doc, featureTypeName);
        }
    }

    @Test(description="See OGC 09-025: 14.2.2.5.3, 14.7")
    public void createStoredQueryWithUnsupportedQueryLanguage() {
        this.reqEntity = WFSMessage.createRequestEntity("/org/opengis/cite/iso19142/querymgmt/CreateStoredQuery-GetFeatureByTypeName", this.wfsVersion);
        Element qryDefn = (Element)this.reqEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "StoredQueryDefinition").item(0);
        qryDefn.setAttribute("id", QRY_INVALID_LANG);
        Element qryExpr = (Element)this.reqEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "QueryExpressionText").item(0);
        qryExpr.setAttribute("language", "http://qry.example.org");
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "CreateStoredQuery", ProtocolBinding.POST);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        ETSAssert.assertExceptionReport(this.rspEntity, "InvalidParameterValue", "language");
    }

    @Test(description="See OGC 09-025: Table 3")
    public void duplicateQuery() {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "CreateStoredQuery", ProtocolBinding.POST);
        this.reqEntity = WFSMessage.createRequestEntity("/org/opengis/cite/iso19142/querymgmt/CreateStoredQuery-GetFeatureByName", this.wfsVersion);
        WFSMessage.setReturnTypesAndTypeNamesAttribute(this.reqEntity, this.dataSampler.selectFeatureType());
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "CreateStoredQueryResponse"));
        this.createdStoredQueries.add(QRY_GET_FEATURE_BY_NAME);
        rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        ETSAssert.assertExceptionReport(this.rspEntity, "DuplicateStoredQueryIdValue", QRY_GET_FEATURE_BY_NAME);
    }
}

