/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.geomatics.SpatialOperator;
import org.opengis.cite.iso19142.ConformanceClass;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.NamespaceBindings;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.geometry.Envelope;
import org.opengis.util.FactoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceMetadataUtils {
    private static final Logger LOGR = Logger.getLogger(ServiceMetadataUtils.class.getPackage().getName());

    public static String getServiceTitle(Document wfsMetadata) {
        Node titleNode = wfsMetadata.getElementsByTagNameNS("http://www.opengis.net/ows/1.1", "Title").item(0);
        return null != titleNode ? titleNode.getTextContent() : "Not specified";
    }

    public static URI getOperationEndpoint(Document wfsMetadata, String opName, ProtocolBinding binding) {
        if (null == binding || binding.equals((Object)ProtocolBinding.ANY)) {
            binding = ServiceMetadataUtils.getOperationBindings(wfsMetadata, opName).iterator().next();
        }
        ProtocolBinding originalBinding = binding;
        if (binding.equals((Object)ProtocolBinding.SOAP)) {
            binding = ProtocolBinding.POST;
        }
        StringBuilder method = new StringBuilder(binding.toString());
        method.replace(1, method.length(), method.substring(1).toLowerCase());
        NamespaceBindings nsBindings = new NamespaceBindings();
        nsBindings.addNamespaceBinding("http://www.opengis.net/ows/1.1", "ows");
        nsBindings.addNamespaceBinding("http://www.w3.org/1999/xlink", "xlink");
        String expr = String.format("//ows:Operation[@name='%s']//ows:%s/@xlink:href", opName, method.toString());
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        URI endpoint = null;
        try {
            String pathToEvaluate = String.format("//ows:Operation[@name='%s']//ows:%s/ows:Constraint/ows:AllowedValues/ows:Value", opName, method.toString());
            Object evalResult = xpath.evaluate(pathToEvaluate, wfsMetadata, XPathConstants.NODESET);
            NodeList allowedValues = (NodeList)evalResult;
            if (originalBinding.equals((Object)ProtocolBinding.SOAP) && allowedValues.getLength() > 0) {
                evalResult = xpath.evaluate(expr, wfsMetadata, XPathConstants.NODESET);
                NodeList hrefList = (NodeList)evalResult;
                for (int i = 0; i < hrefList.getLength(); ++i) {
                    if (!allowedValues.item(i).getTextContent().equalsIgnoreCase("soap")) continue;
                    String href = hrefList.item(i).getNodeValue();
                    endpoint = URI.create(href);
                }
                if (null == endpoint) {
                    String href = xpath.evaluate(expr, wfsMetadata);
                    endpoint = URI.create(href);
                }
            } else {
                String href = xpath.evaluate(expr, wfsMetadata);
                endpoint = URI.create(href);
            }
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log(Level.INFO, ex.getMessage());
        }
        String queryString = endpoint.getQuery();
        if (null != queryString) {
            String uri = endpoint.toString();
            if (queryString.trim().isEmpty()) {
                endpoint = URI.create(uri.substring(0, uri.indexOf(63)));
            } else if (!uri.endsWith("&")) {
                endpoint = URI.create(uri + "&");
            }
        }
        return endpoint;
    }

    public static Map<String, URI> getRequestEndpoints(Document wfsMetadata, String reqName) {
        NamespaceBindings nsBindings = NamespaceBindings.withStandardBindings();
        String expr = String.format("//ows:Operation[@name='%s']/descendant::*[@xlink:href]", reqName);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        HashMap<String, URI> endpoints = null;
        try {
            NodeList methodNodes = (NodeList)xpath.evaluate(expr, wfsMetadata, XPathConstants.NODESET);
            if (null == methodNodes || methodNodes.getLength() == 0) {
                return null;
            }
            endpoints = new HashMap<String, URI>();
            for (int i = 0; i < methodNodes.getLength(); ++i) {
                Element methodElem = (Element)methodNodes.item(i);
                String methodName = methodElem.getLocalName().toUpperCase();
                String href = methodElem.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                if (href.indexOf(63) > 0) {
                    href = href.substring(0, href.indexOf(63));
                }
                endpoints.put(methodName, URI.create(href));
            }
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.INFO, xpe.getMessage());
        }
        return endpoints;
    }

    public static List<QName> getFeatureTypes(Document wfsMetadata) {
        String xpath = "//wfs:FeatureType/wfs:Name";
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        NodeList typeNames = null;
        try {
            typeNames = XMLUtils.evaluateXPath(wfsMetadata, xpath, nsBindings);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.INFO, "Failed to evaluate XPath expression: " + xpath, xpe);
        }
        ArrayList<QName> featureTypes = new ArrayList<QName>();
        for (int i = 0; i < typeNames.getLength(); ++i) {
            Node typeName = typeNames.item(i);
            featureTypes.add(ServiceMetadataUtils.buildQName(typeName));
        }
        LOGR.fine(((Object)featureTypes).toString());
        return featureTypes;
    }

    public static Map<QName, FeatureTypeInfo> extractFeatureTypeInfo(Document wfsCapabilities) {
        HashMap<QName, FeatureTypeInfo> featureInfo = new HashMap<QName, FeatureTypeInfo>();
        NodeList featureTypes = wfsCapabilities.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "FeatureType");
        for (int i = 0; i < featureTypes.getLength(); ++i) {
            NodeList otherCRSNodes;
            FeatureTypeInfo typeInfo = new FeatureTypeInfo();
            Element featureTypeElem = (Element)featureTypes.item(i);
            Node nameNode = featureTypeElem.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Name").item(0);
            QName typeName = ServiceMetadataUtils.buildQName(nameNode);
            typeInfo.setTypeName(typeName);
            Node defaultCRSNode = featureTypeElem.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "DefaultCRS").item(0);
            if (null != defaultCRSNode) {
                typeInfo.addCRSIdentifiers(defaultCRSNode.getTextContent());
            }
            if ((otherCRSNodes = featureTypeElem.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "OtherCRS")).getLength() > 0) {
                for (int n = 0; n < otherCRSNodes.getLength(); ++n) {
                    typeInfo.addCRSIdentifiers(otherCRSNodes.item(n).getTextContent());
                }
            }
            Node bboxNode = featureTypeElem.getElementsByTagNameNS("http://www.opengis.net/ows/1.1", "WGS84BoundingBox").item(0);
            try {
                if (null != bboxNode) {
                    Envelope envelope = Extents.createEnvelope((Node)bboxNode);
                    typeInfo.setSpatialExtent(envelope);
                }
            }
            catch (FactoryException e) {
                TestSuiteLogger.log(Level.WARNING, e.getMessage());
            }
            featureInfo.put(typeInfo.getTypeName(), typeInfo);
        }
        return featureInfo;
    }

    public static QName buildQName(Node node) {
        String localPart;
        String nsName = null;
        String prefix = null;
        String name = node.getTextContent();
        int indexOfColon = name.indexOf(58);
        if (indexOfColon > 0) {
            localPart = name.substring(indexOfColon + 1);
            nsName = node.lookupNamespaceURI(name.substring(0, indexOfColon));
            prefix = node.lookupPrefix(nsName);
        } else {
            localPart = name;
            nsName = node.lookupNamespaceURI(null);
        }
        if (null != prefix) {
            return new QName(nsName, localPart, prefix);
        }
        return new QName(nsName, localPart);
    }

    public static Set<ProtocolBinding> getGlobalBindings(Document wfsMetadata) {
        if (null == wfsMetadata) {
            throw new NullPointerException("WFS metadata document is null.");
        }
        EnumSet<ProtocolBinding> globalBindings = EnumSet.noneOf(ProtocolBinding.class);
        String xpath = "//ows:OperationsMetadata/ows:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]";
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/ows/1.1", "ows");
        try {
            if (XMLUtils.evaluateXPath(wfsMetadata, String.format(xpath, "KVPEncoding"), nsBindings).getLength() > 0) {
                globalBindings.add(ProtocolBinding.GET);
            }
            if (XMLUtils.evaluateXPath(wfsMetadata, String.format(xpath, "XMLEncoding"), nsBindings).getLength() > 0) {
                globalBindings.add(ProtocolBinding.POST);
            }
            if (XMLUtils.evaluateXPath(wfsMetadata, String.format(xpath, "SOAPEncoding"), nsBindings).getLength() > 0) {
                globalBindings.add(ProtocolBinding.SOAP);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
        }
        return globalBindings;
    }

    public static Set<ProtocolBinding> getOperationBindings(Document wfsMetadata, String opName) {
        HashSet<ProtocolBinding> protoBindings = new HashSet<ProtocolBinding>();
        String expr = "//ows:Operation[@name='%s']/ows:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]";
        for (ProtocolBinding binding : EnumSet.allOf(ProtocolBinding.class)) {
            String xpath = String.format(expr, opName, binding.getConstraintName());
            try {
                if (XMLUtils.evaluateXPath(wfsMetadata, xpath, null).getLength() <= 0) continue;
                protoBindings.add(ProtocolBinding.GET);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
            }
        }
        protoBindings.addAll(ServiceMetadataUtils.getGlobalBindings(wfsMetadata));
        if (opName.equals("Transaction")) {
            protoBindings.remove((Object)ProtocolBinding.GET);
        }
        return protoBindings;
    }

    public static Set<ConformanceClass> getConformanceClaims(Document wfsMetadata) {
        EnumSet<ConformanceClass> conformanceSet = EnumSet.allOf(ConformanceClass.class);
        String expr = "//ows:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]";
        for (ConformanceClass conformClass : conformanceSet) {
            NodeList result;
            String xpath = String.format(expr, conformClass.getConstraintName());
            try {
                result = XMLUtils.evaluateXPath(wfsMetadata, xpath, null);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException("Error evaluating XPath expression against capabilities doc. " + xpath, xpe);
            }
            if (result.getLength() != 0) continue;
            conformanceSet.remove((Object)conformClass);
        }
        return conformanceSet;
    }

    public static boolean implementsSpatialOperator(Document wfsMetadata, String operatorName) {
        String expr = String.format("//fes:SpatialOperator[@name='%s']", operatorName);
        NodeList results = null;
        try {
            results = XMLUtils.evaluateXPath(wfsMetadata, expr, null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return results.getLength() > 0;
    }

    public static Map<SpatialOperator, Set<QName>> getSpatialCapabilities(Document wfsMetadata) {
        NodeList nodeList = null;
        try {
            nodeList = XMLUtils.evaluateXPath(wfsMetadata, "//fes:Spatial_Capabilities/fes:GeometryOperands/fes:GeometryOperand", null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        Set<QName> commonOperands = ServiceMetadataUtils.geometryOperands(nodeList);
        EnumMap<SpatialOperator, Set<QName>> spatialCapabilities = new EnumMap<SpatialOperator, Set<QName>>(SpatialOperator.class);
        nodeList = wfsMetadata.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "SpatialOperator");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element operator = (Element)nodeList.item(i);
            SpatialOperator op = SpatialOperator.valueOf((String)operator.getAttribute("name").toUpperCase());
            NodeList operands = operator.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "GeometryOperand");
            Set<QName> specificOperands = ServiceMetadataUtils.geometryOperands(operands);
            specificOperands.addAll(commonOperands);
            spatialCapabilities.put(op, specificOperands);
        }
        return spatialCapabilities;
    }

    public static Set<QName> geometryOperands(NodeList operandList) {
        HashSet<QName> operands = new HashSet<QName>();
        for (int i = 0; i < operandList.getLength(); ++i) {
            Element operand = (Element)operandList.item(i);
            String[] geomType = operand.getAttribute("name").split(":");
            if (geomType.length != 2) continue;
            operands.add(new QName(operand.lookupNamespaceURI(geomType[0]), geomType[1]));
        }
        return operands;
    }

    public static boolean implementsTemporalOperator(Document wfsMetadata, String operatorName) {
        String expr = String.format("//fes:TemporalOperator[@name='%s']", operatorName);
        NodeList results = null;
        try {
            results = XMLUtils.evaluateXPath(wfsMetadata, expr, null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return results.getLength() > 0;
    }

    public static boolean implementsConformanceClass(Document wfsMetadata, String conformanceClass) {
        String expr = String.format("(//ows:Constraint | //fes:Constraint)[@name='%s' and (.//ows:Value = 'TRUE' or ows:DefaultValue = 'TRUE')]", conformanceClass);
        NodeList result = null;
        try {
            result = XMLUtils.evaluateXPath(wfsMetadata, expr, null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return result.getLength() > 0;
    }

    public static String getConstraintValue(Document wfsMetadata, String constraintName) {
        String xpath = " (//ows:Value[1] | //ows:DefaultValue)[ancestor::ows:Constraint[@name='%s']]";
        NodeList items = null;
        try {
            items = XMLUtils.evaluateXPath(wfsMetadata, String.format(xpath, constraintName), null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        String value = "";
        for (int i = 0; i < items.getLength(); ++i) {
            Node valueNode = items.item(i);
            if (valueNode.getLocalName().equals("DefaultValue")) {
                value = valueNode.getTextContent().trim();
                break;
            }
            value = valueNode.getTextContent().trim();
        }
        return value;
    }
}

