/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources;

import com.occamlab.te.spi.jaxrs.ErrorResponseBuilder;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import com.occamlab.te.spi.jaxrs.TestSuiteRegistry;
import com.occamlab.te.spi.util.TestRunUtils;
import com.occamlab.te.util.LogUtils;
import com.sun.jersey.multipart.FormDataParam;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="suites/{etsCode}/run")
public class TestRunResource {
    private static final Logger LOGR = Logger.getLogger(TestRunResource.class.getPackage().getName());
    private static final String TEST_RUN_ARGUMENTS = "Test run arguments - ";
    private static final String ENTITY_MEDIA_TYPE = "Entity media type: ";
    private static final String FILE_LOCATION = "File location: ";
    private static final String APPLICATION_RDF_XML = "application/rdf+xml";
    private static final String APPLICATION_ZIP = "application/zip";
    private static final String APPLICATION_XML = "application/xml";
    @Context
    private UriInfo reqUriInfo;
    @Context
    private HttpHeaders headers;

    @GET
    @Produces(value={"application/rdf+xml;qs=0.75;charset='utf-8'"})
    public Source handleGetRdf(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion) {
        return this.handleGet(etsCode, etsVersion, APPLICATION_RDF_XML);
    }

    @GET
    @Produces(value={"application/xml;qs=0.5;charset='utf-8'"})
    public Source handleGetXml(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion) {
        return this.handleGet(etsCode, etsVersion, APPLICATION_XML);
    }

    @GET
    @Produces(value={"application/zip;qs=0.25;charset='utf-8'"})
    public Response handleGetZip(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion) throws IOException {
        MultivaluedMap<String, String> params = this.reqUriInfo.getQueryParameters();
        Source results = this.executeTestRun(etsCode, params, APPLICATION_ZIP);
        String htmlOutput = results.getSystemId().toString();
        int count = htmlOutput.split(":", -1).length - 1;
        String zipFile = count > 1 ? htmlOutput.split("file:/")[1] : htmlOutput.split("file:")[1];
        File fileOut = new File(zipFile);
        if (!fileOut.exists()) {
            throw new WebApplicationException(404);
        }
        return Response.ok(FileUtils.readFileToByteArray(fileOut)).type(APPLICATION_ZIP).header("Content-Disposition", "attachment; filename=\"result.zip\";").header("Cache-Control", "no-cache").build();
    }

    @POST
    @Consumes(value={"application/xml", "text/xml"})
    @Produces(value={"application/rdf+xml;qs=0.75;charset='utf-8'"})
    public Source handlePostRdf(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion, File entityBody) {
        return this.handlePost(etsCode, etsVersion, entityBody, APPLICATION_RDF_XML);
    }

    @POST
    @Consumes(value={"application/xml", "text/xml"})
    @Produces(value={"application/xml;qs=0.5;charset='utf-8'"})
    public Source handlePostXml(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion, File entityBody) {
        return this.handlePost(etsCode, etsVersion, entityBody, APPLICATION_XML);
    }

    @POST
    @Consumes(value={"application/xml", "text/xml"})
    @Produces(value={"application/zip;qs=0.25;charset='utf-8'"})
    public Source handlePostZip(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion, File entityBody) {
        return this.handlePost(etsCode, etsVersion, entityBody, APPLICATION_ZIP);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/rdf+xml;qs=0.75;charset='utf-8'"})
    public Source handleMultipartFormDataRdf(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion, @FormDataParam(value="iut") File entityBody, @FormDataParam(value="sch") File schBody) {
        return this.handleMultipartFormDataPost(etsCode, etsVersion, entityBody, schBody, APPLICATION_RDF_XML);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/xml;qs=0.5;charset='utf-8'"})
    public Source handleMultipartFormDataXml(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion, @FormDataParam(value="iut") File entityBody, @FormDataParam(value="sch") File schBody) {
        return this.handleMultipartFormDataPost(etsCode, etsVersion, entityBody, schBody, APPLICATION_XML);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/zip;qs=0.25;charset='utf-8'"})
    public Source handleMultipartFormDataZip(@PathParam(value="etsCode") String etsCode, @PathParam(value="etsVersion") String etsVersion, @FormDataParam(value="iut") File entityBody, @FormDataParam(value="sch") File schBody) {
        return this.handleMultipartFormDataPost(etsCode, etsVersion, entityBody, schBody, APPLICATION_ZIP);
    }

    private Source handleGet(String etsCode, String etsVersion, String preferredMediaType) {
        MultivaluedMap<String, String> params = this.reqUriInfo.getQueryParameters();
        if (LOGR.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder(TEST_RUN_ARGUMENTS);
            msg.append(etsCode).append("/").append(etsVersion).append("\n");
            msg.append(params.toString());
            LOGR.fine(msg.toString());
        }
        return this.executeTestRun(etsCode, params, preferredMediaType);
    }

    private Source handlePost(String etsCode, String etsVersion, File entityBody, String preferredMediaType) {
        if (!entityBody.exists() || entityBody.length() == 0L) {
            throw new WebApplicationException(400);
        }
        if (LOGR.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder(TEST_RUN_ARGUMENTS);
            msg.append(etsCode).append("/").append(etsVersion).append("\n");
            msg.append(ENTITY_MEDIA_TYPE + this.headers.getMediaType());
            msg.append(FILE_LOCATION + entityBody.getAbsolutePath());
            LOGR.fine(msg.toString());
        }
        HashMap<String, List<String>> args = new HashMap<String, List<String>>();
        args.put("iut", Arrays.asList(entityBody.toURI().toString()));
        return this.executeTestRun(etsCode, args, preferredMediaType);
    }

    private Source handleMultipartFormDataPost(String etsCode, String etsVersion, File entityBody, File schBody, String preferredMediaType) {
        StringBuilder msg;
        HashMap<String, List<String>> args = new HashMap<String, List<String>>();
        if (!entityBody.exists() || entityBody.length() == 0L) {
            throw new WebApplicationException(400);
        }
        if (LOGR.isLoggable(Level.FINE)) {
            msg = new StringBuilder(TEST_RUN_ARGUMENTS);
            msg.append(etsCode).append("/").append(etsVersion).append("\n");
            msg.append(ENTITY_MEDIA_TYPE + this.headers.getMediaType());
            msg.append(FILE_LOCATION + entityBody.getAbsolutePath());
            LOGR.fine(msg.toString());
        }
        args.put("iut", Arrays.asList(entityBody.toURI().toString()));
        if (null != schBody) {
            if (!schBody.exists() || schBody.length() == 0L) {
                throw new WebApplicationException(400);
            }
            if (LOGR.isLoggable(Level.FINE)) {
                msg = new StringBuilder(TEST_RUN_ARGUMENTS);
                msg.append(etsCode).append("/").append(etsVersion).append("\n");
                msg.append(ENTITY_MEDIA_TYPE + this.headers.getMediaType());
                msg.append(FILE_LOCATION + schBody.getAbsolutePath());
                LOGR.fine(msg.toString());
            }
            args.put("sch", Arrays.asList(schBody.toURI().toString()));
        }
        return this.executeTestRun(etsCode, args, preferredMediaType);
    }

    private Source executeTestRun(String etsCode, Map<String, List<String>> testRunArgs, String preferredMediaType) {
        List<String> authCredentials = this.headers.getRequestHeader("Authorization");
        String logDir = System.getProperty("TE_BASE") + System.getProperty("file.separator") + "users" + System.getProperty("file.separator") + TestRunUtils.getUserName(authCredentials) + System.getProperty("file.separator") + "rest";
        if (null != logDir) {
            String sessionId = LogUtils.generateSessionId(new File(logDir));
            testRunArgs.put("logDir", Arrays.asList(logDir));
            testRunArgs.put("sessionId", Arrays.asList(sessionId));
        }
        testRunArgs.put("acceptMediaType", Arrays.asList(preferredMediaType));
        if (LOGR.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder(TEST_RUN_ARGUMENTS);
            msg.append(etsCode).append("/");
            msg.append(testRunArgs.toString());
            if (null != this.headers.getMediaType()) {
                msg.append(ENTITY_MEDIA_TYPE + this.headers.getMediaType());
            }
            LOGR.fine(msg.toString());
        }
        TestSuiteController controller = this.findController(etsCode);
        testRunArgs.put("sourcesId", Arrays.asList(TestRunUtils.getSourcesId(controller)));
        Document xmlArgs = this.readTestRunArguments(testRunArgs);
        Source testResults = null;
        try {
            testResults = controller.doTestRun(xmlArgs);
        }
        catch (IllegalArgumentException iae) {
            ErrorResponseBuilder builder = new ErrorResponseBuilder();
            Response rsp = builder.buildErrorResponse(400, iae.getMessage());
            throw new WebApplicationException(rsp);
        }
        catch (Exception ex) {
            LOGR.log(Level.WARNING, ex.getMessage(), ex);
            ErrorResponseBuilder builder = new ErrorResponseBuilder();
            String error_msg = "Error executing test suite (" + etsCode + "): Error message: " + ex.getMessage();
            Response rsp = builder.buildErrorResponse(500, error_msg);
            throw new WebApplicationException(rsp);
        }
        LOGR.fine(String.format("Test results for suite %s: %s", etsCode, testResults.getSystemId()));
        return testResults;
    }

    private TestSuiteController findController(String code) throws WebApplicationException {
        TestSuiteRegistry registry = TestSuiteRegistry.getInstance();
        TestSuiteController controller = registry.getController(code);
        if (null == controller) {
            throw new WebApplicationException(404);
        }
        return controller;
    }

    private Document readTestRunArguments(Map<String, List<String>> requestParams) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document propsDoc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            propsDoc = db.newDocument();
        }
        catch (ParserConfigurationException ex) {
            LOGR.log(Level.SEVERE, null, ex);
        }
        Element docElem = propsDoc.createElement("properties");
        docElem.setAttribute("version", "1.0");
        for (Map.Entry<String, List<String>> param : requestParams.entrySet()) {
            Element entry = propsDoc.createElement("entry");
            entry.setAttribute("key", param.getKey());
            StringBuilder values = new StringBuilder();
            Iterator<String> itr = param.getValue().iterator();
            while (itr.hasNext()) {
                values.append(itr.next());
                if (!itr.hasNext()) continue;
                values.append(",");
            }
            entry.setTextContent(values.toString());
            docElem.appendChild(entry);
        }
        propsDoc.appendChild(docElem);
        return propsDoc;
    }
}

