/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CentroidArea;
import com.vividsolutions.jts.algorithm.CentroidLine;
import com.vividsolutions.jts.algorithm.CentroidPoint;
import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.algorithm.InteriorPointArea;
import com.vividsolutions.jts.algorithm.InteriorPointLine;
import com.vividsolutions.jts.algorithm.InteriorPointPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryCollectionMapper;
import com.vividsolutions.jts.geom.util.GeometryMapper;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.IsSimpleOp;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import com.vividsolutions.jts.operation.predicate.RectangleContains;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;
import com.vividsolutions.jts.operation.relate.RelateOp;
import com.vividsolutions.jts.operation.union.UnaryUnionOp;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public abstract class Geometry
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 8763622679187376702L;
    private static Class[] sortedClasses;
    private static final GeometryComponentFilter geometryChangedFilter;
    protected Envelope envelope;
    protected final GeometryFactory factory;
    protected int SRID;
    private Object userData = null;

    public Geometry(GeometryFactory factory) {
        this.factory = factory;
        this.SRID = factory.getSRID();
    }

    public abstract String getGeometryType();

    protected static boolean hasNonEmptyElements(Geometry[] geometries) {
        for (int i = 0; i < geometries.length; ++i) {
            if (geometries[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasNullElements(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            return true;
        }
        return false;
    }

    public int getSRID() {
        return this.SRID;
    }

    public void setSRID(int SRID) {
        this.SRID = SRID;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int getNumGeometries() {
        return 1;
    }

    public Geometry getGeometryN(int n) {
        return this;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public PrecisionModel getPrecisionModel() {
        return this.factory.getPrecisionModel();
    }

    public abstract Coordinate getCoordinate();

    public abstract Coordinate[] getCoordinates();

    public abstract int getNumPoints();

    public boolean isSimple() {
        IsSimpleOp op = new IsSimpleOp(this);
        return op.isSimple();
    }

    public boolean isValid() {
        return IsValidOp.isValid(this);
    }

    public abstract boolean isEmpty();

    public double distance(Geometry g2) {
        return DistanceOp.distance(this, g2);
    }

    public boolean isWithinDistance(Geometry geom, double distance) {
        double envDist = this.getEnvelopeInternal().distance(geom.getEnvelopeInternal());
        if (envDist > distance) {
            return false;
        }
        return DistanceOp.isWithinDistance(this, geom, distance);
    }

    public boolean isRectangle() {
        return false;
    }

    public double getArea() {
        return 0.0;
    }

    public double getLength() {
        return 0.0;
    }

    public Point getCentroid() {
        if (this.isEmpty()) {
            return this.factory.createPoint((Coordinate)null);
        }
        Coordinate centPt = null;
        int dim = this.getDimension();
        if (dim == 0) {
            CentroidPoint cent = new CentroidPoint();
            cent.add(this);
            centPt = cent.getCentroid();
        } else if (dim == 1) {
            CentroidLine cent = new CentroidLine();
            cent.add(this);
            centPt = cent.getCentroid();
        } else {
            CentroidArea cent = new CentroidArea();
            cent.add(this);
            centPt = cent.getCentroid();
        }
        return this.createPointFromInternalCoord(centPt, this);
    }

    public Point getInteriorPoint() {
        if (this.isEmpty()) {
            return this.factory.createPoint((Coordinate)null);
        }
        Coordinate interiorPt = null;
        int dim = this.getDimension();
        if (dim == 0) {
            InteriorPointPoint intPt = new InteriorPointPoint(this);
            interiorPt = intPt.getInteriorPoint();
        } else if (dim == 1) {
            InteriorPointLine intPt = new InteriorPointLine(this);
            interiorPt = intPt.getInteriorPoint();
        } else {
            InteriorPointArea intPt = new InteriorPointArea(this);
            interiorPt = intPt.getInteriorPoint();
        }
        return this.createPointFromInternalCoord(interiorPt, this);
    }

    public abstract int getDimension();

    public abstract Geometry getBoundary();

    public abstract int getBoundaryDimension();

    public Geometry getEnvelope() {
        return this.getFactory().toGeometry(this.getEnvelopeInternal());
    }

    public Envelope getEnvelopeInternal() {
        if (this.envelope == null) {
            this.envelope = this.computeEnvelopeInternal();
        }
        return new Envelope(this.envelope);
    }

    public void geometryChanged() {
        this.apply(geometryChangedFilter);
    }

    protected void geometryChangedAction() {
        this.envelope = null;
    }

    public boolean disjoint(Geometry g2) {
        return !this.intersects(g2);
    }

    public boolean touches(Geometry g2) {
        if (!this.getEnvelopeInternal().intersects(g2.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(g2).isTouches(this.getDimension(), g2.getDimension());
    }

    public boolean intersects(Geometry g2) {
        if (!this.getEnvelopeInternal().intersects(g2.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)this, g2);
        }
        if (g2.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)g2, this);
        }
        return this.relate(g2).isIntersects();
    }

    public boolean crosses(Geometry g2) {
        if (!this.getEnvelopeInternal().intersects(g2.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(g2).isCrosses(this.getDimension(), g2.getDimension());
    }

    public boolean within(Geometry g2) {
        return g2.contains(this);
    }

    public boolean contains(Geometry g2) {
        if (!this.getEnvelopeInternal().contains(g2.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleContains.contains((Polygon)this, g2);
        }
        return this.relate(g2).isContains();
    }

    public boolean overlaps(Geometry g2) {
        if (!this.getEnvelopeInternal().intersects(g2.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(g2).isOverlaps(this.getDimension(), g2.getDimension());
    }

    public boolean covers(Geometry g2) {
        if (!this.getEnvelopeInternal().covers(g2.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return true;
        }
        return this.relate(g2).isCovers();
    }

    public boolean coveredBy(Geometry g2) {
        return g2.covers(this);
    }

    public boolean relate(Geometry g2, String intersectionPattern) {
        return this.relate(g2).matches(intersectionPattern);
    }

    public IntersectionMatrix relate(Geometry g2) {
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(g2);
        return RelateOp.relate(this, g2);
    }

    public boolean equals(Geometry g2) {
        return this.equalsTopo(g2);
    }

    public boolean equalsTopo(Geometry g2) {
        if (!this.getEnvelopeInternal().equals(g2.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(g2).isEquals(this.getDimension(), g2.getDimension());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Geometry)) {
            return false;
        }
        Geometry g2 = (Geometry)o;
        return this.equalsExact(g2);
    }

    public int hashCode() {
        return this.getEnvelopeInternal().hashCode();
    }

    public String toString() {
        return this.toText();
    }

    public String toText() {
        WKTWriter writer = new WKTWriter();
        return writer.write(this);
    }

    public Geometry buffer(double distance) {
        return BufferOp.bufferOp(this, distance);
    }

    public Geometry buffer(double distance, int quadrantSegments) {
        return BufferOp.bufferOp(this, distance, quadrantSegments);
    }

    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return BufferOp.bufferOp(this, distance, quadrantSegments, endCapStyle);
    }

    public Geometry convexHull() {
        return new ConvexHull(this).getConvexHull();
    }

    public abstract Geometry reverse();

    public Geometry intersection(Geometry other) {
        if (this.isEmpty() || other.isEmpty()) {
            return OverlayOp.createEmptyResult(1, this, other, this.factory);
        }
        if (this.isGeometryCollection()) {
            final Geometry g2 = other;
            return GeometryCollectionMapper.map((GeometryCollection)this, new GeometryMapper.MapOp(){

                public Geometry map(Geometry g22) {
                    return g22.intersection(g2);
                }
            });
        }
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(other);
        return SnapIfNeededOverlayOp.overlayOp(this, other, 1);
    }

    public Geometry union(Geometry other) {
        if (this.isEmpty() || other.isEmpty()) {
            if (this.isEmpty() && other.isEmpty()) {
                return OverlayOp.createEmptyResult(2, this, other, this.factory);
            }
            if (this.isEmpty()) {
                return (Geometry)other.clone();
            }
            if (other.isEmpty()) {
                return (Geometry)this.clone();
            }
        }
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(other);
        return SnapIfNeededOverlayOp.overlayOp(this, other, 2);
    }

    public Geometry difference(Geometry other) {
        if (this.isEmpty()) {
            return OverlayOp.createEmptyResult(3, this, other, this.factory);
        }
        if (other.isEmpty()) {
            return (Geometry)this.clone();
        }
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(other);
        return SnapIfNeededOverlayOp.overlayOp(this, other, 3);
    }

    public Geometry symDifference(Geometry other) {
        if (this.isEmpty() || other.isEmpty()) {
            if (this.isEmpty() && other.isEmpty()) {
                return OverlayOp.createEmptyResult(4, this, other, this.factory);
            }
            if (this.isEmpty()) {
                return (Geometry)other.clone();
            }
            if (other.isEmpty()) {
                return (Geometry)this.clone();
            }
        }
        this.checkNotGeometryCollection(this);
        this.checkNotGeometryCollection(other);
        return SnapIfNeededOverlayOp.overlayOp(this, other, 4);
    }

    public Geometry union() {
        return UnaryUnionOp.union(this);
    }

    public abstract boolean equalsExact(Geometry var1, double var2);

    public boolean equalsExact(Geometry other) {
        return this.equalsExact(other, 0.0);
    }

    public boolean equalsNorm(Geometry g2) {
        if (g2 == null) {
            return false;
        }
        return this.norm().equalsExact(g2.norm());
    }

    public abstract void apply(CoordinateFilter var1);

    public abstract void apply(CoordinateSequenceFilter var1);

    public abstract void apply(GeometryFilter var1);

    public abstract void apply(GeometryComponentFilter var1);

    public Object clone() {
        try {
            Geometry clone = (Geometry)super.clone();
            if (clone.envelope != null) {
                clone.envelope = new Envelope(clone.envelope);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public abstract void normalize();

    public Geometry norm() {
        Geometry copy = (Geometry)this.clone();
        copy.normalize();
        return copy;
    }

    public int compareTo(Object o) {
        Geometry other = (Geometry)o;
        if (this.getClassSortIndex() != other.getClassSortIndex()) {
            return this.getClassSortIndex() - other.getClassSortIndex();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(o);
    }

    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        Geometry other = (Geometry)o;
        if (this.getClassSortIndex() != other.getClassSortIndex()) {
            return this.getClassSortIndex() - other.getClassSortIndex();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(o, comp);
    }

    protected boolean isEquivalentClass(Geometry other) {
        return this.getClass().getName().equals(other.getClass().getName());
    }

    protected void checkNotGeometryCollection(Geometry g2) {
        if (g2.getClass().getName().equals("com.vividsolutions.jts.geom.GeometryCollection")) {
            throw new IllegalArgumentException("This method does not support GeometryCollection arguments");
        }
    }

    protected boolean isGeometryCollection() {
        return this.getClass().equals(GeometryCollection.class);
    }

    protected abstract Envelope computeEnvelopeInternal();

    protected abstract int compareToSameClass(Object var1);

    protected abstract int compareToSameClass(Object var1, CoordinateSequenceComparator var2);

    protected int compare(Collection a, Collection b) {
        Iterator i = a.iterator();
        Iterator j = b.iterator();
        while (i.hasNext() && j.hasNext()) {
            Comparable bElement;
            Comparable aElement = (Comparable)i.next();
            int comparison = aElement.compareTo(bElement = (Comparable)j.next());
            if (comparison == 0) continue;
            return comparison;
        }
        if (i.hasNext()) {
            return 1;
        }
        if (j.hasNext()) {
            return -1;
        }
        return 0;
    }

    protected boolean equal(Coordinate a, Coordinate b, double tolerance) {
        if (tolerance == 0.0) {
            return a.equals(b);
        }
        return a.distance(b) <= tolerance;
    }

    private int getClassSortIndex() {
        if (sortedClasses == null) {
            Geometry.initSortedClasses();
        }
        for (int i = 0; i < sortedClasses.length; ++i) {
            if (!sortedClasses[i].isInstance(this)) continue;
            return i;
        }
        Assert.shouldNeverReachHere("Class not supported: " + this.getClass());
        return -1;
    }

    private static void initSortedClasses() {
        sortedClasses = new Class[]{Point.class, MultiPoint.class, LineString.class, LinearRing.class, MultiLineString.class, Polygon.class, MultiPolygon.class, GeometryCollection.class};
    }

    private Point createPointFromInternalCoord(Coordinate coord, Geometry exemplar) {
        exemplar.getPrecisionModel().makePrecise(coord);
        return exemplar.getFactory().createPoint(coord);
    }

    static {
        geometryChangedFilter = new GeometryComponentFilter(){

            public void filter(Geometry geom) {
                geom.geometryChangedAction();
            }
        };
    }
}

