/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultSetNode;

abstract class SingleChildResultSetNode
extends FromTable {
    ResultSetNode childResult;
    protected boolean hasTrulyTheBestAccessPath;

    SingleChildResultSetNode(ResultSetNode resultSetNode, Properties properties, ContextManager contextManager) {
        super(null, properties, contextManager);
        this.childResult = resultSetNode;
        if (resultSetNode.getReferencedTableMap() != null) {
            this.setReferencedTableMap((JBitSet)resultSetNode.getReferencedTableMap().clone());
        }
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        if (this.hasTrulyTheBestAccessPath) {
            return super.getTrulyTheBestAccessPath();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
        }
        return super.getTrulyTheBestAccessPath();
    }

    ResultSetNode getChildResult() {
        return this.childResult;
    }

    void setChildResult(ResultSetNode resultSetNode) {
        this.childResult = resultSetNode;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).pullOptPredicates(optimizablePredicateList);
        }
    }

    @Override
    public boolean forUpdate() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).forUpdate();
        }
        return super.forUpdate();
    }

    @Override
    public void initAccessPaths(Optimizer optimizer) {
        super.initAccessPaths(optimizer);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).initAccessPaths(optimizer);
        }
    }

    @Override
    public void updateBestPlanMap(short s2, Object object) throws StandardException {
        super.updateBestPlanMap(s2, object);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).updateBestPlanMap(s2, object);
        } else if (this.childResult.getOptimizerImpl() != null) {
            this.childResult.getOptimizerImpl().updateBestPlanMaps(s2, object);
        }
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.childResult.referencesTarget(string, bl);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.childResult.referencesSessionSchema();
    }

    @Override
    void setLevel(int n) {
        super.setLevel(n);
        if (this.childResult instanceof FromTable) {
            ((FromTable)this.childResult).setLevel(n);
        }
    }

    @Override
    boolean subqueryReferencesTarget(String string, boolean bl) throws StandardException {
        return this.childResult.subqueryReferencesTarget(string, bl);
    }

    @Override
    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.childResult = this.childResult.preprocess(n, groupByList, fromList);
        this.setReferencedTableMap((JBitSet)this.childResult.getReferencedTableMap().clone());
        return this;
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.childResult = this.childResult.addNewPredicate(predicate);
        return this;
    }

    @Override
    void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.childResult instanceof FromTable) {
            ((FromTable)this.childResult).pushExpressions(predicateList);
        }
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, predicateList, d);
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        this.childResult = this.childResult.modifyAccessPaths();
        return this;
    }

    @Override
    ResultSetNode changeAccessPath() throws StandardException {
        this.childResult = this.childResult.changeAccessPath();
        return this;
    }

    @Override
    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.childResult.getFromTableByName(string, string2, bl);
    }

    @Override
    void decrementLevel(int n) {
        super.decrementLevel(n);
        this.childResult.decrementLevel(n);
    }

    @Override
    int updateTargetLockMode() {
        return this.childResult.updateTargetLockMode();
    }

    @Override
    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, List<FromBaseTable> list) throws StandardException {
        return this.childResult.isOrderedOn(columnReferenceArray, bl, list);
    }

    @Override
    boolean isOneRowResultSet() throws StandardException {
        return this.childResult.isOneRowResultSet();
    }

    @Override
    boolean isNotExists() {
        return this.childResult.isNotExists();
    }

    protected boolean reflectionNeededForProjection() {
        return !this.getResultColumns().allExpressionsAreColumns(this.childResult);
    }

    @Override
    void adjustForSortElimination() {
        this.childResult.adjustForSortElimination();
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering requiredRowOrdering) throws StandardException {
        this.childResult.adjustForSortElimination(requiredRowOrdering);
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCostEstimate() == null) {
            return this.childResult.getFinalCostEstimate();
        }
        return this.getCostEstimate();
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.childResult != null) {
            this.childResult = (ResultSetNode)this.childResult.accept(visitor);
        }
    }
}

