/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.geotoolkit.gml.xml.AbstractTimePosition;
import org.geotoolkit.gml.xml.TimeIndeterminateValueType;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.opengis.temporal.Position;
import org.opengis.util.InternationalString;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TimePositionType", propOrder={"value"})
public class TimePositionType
extends AbstractTimePosition
implements Serializable {
    @XmlValue
    private List<String> value;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String frame;
    @XmlAttribute
    private String calendarEraName;
    @XmlAttribute
    private TimeIndeterminateValueType indeterminatePosition;

    TimePositionType() {
    }

    public TimePositionType(String value) {
        if (value != null) {
            this.value = Arrays.asList(value);
        }
    }

    public TimePositionType(Position value) {
        this(value.getDate());
    }

    public TimePositionType(TimeIndeterminateValueType indeterminatePosition) {
        this.indeterminatePosition = indeterminatePosition;
    }

    public TimePositionType(Timestamp time) {
        if (time != null) {
            this.value = Arrays.asList(time.toString());
        }
    }

    public TimePositionType(Date time) {
        this.setValue(time);
    }

    public List<String> getValue() {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValue(Date value) {
        DateFormat df;
        Calendar c = Calendar.getInstance();
        c.setTime(value);
        if (c.get(10) == 0 && c.get(12) == 0 && c.get(13) == 0) {
            DateFormat df2;
            DateFormat dateFormat = df2 = (DateFormat)FORMATTERS.get(2);
            synchronized (dateFormat) {
                this.value = Arrays.asList(df2.format(value));
            }
        }
        DateFormat dateFormat = df = (DateFormat)FORMATTERS.get(0);
        synchronized (dateFormat) {
            this.value = Arrays.asList(df.format(value));
        }
    }

    public String getFrame() {
        if (this.frame == null) {
            return "#ISO-8601";
        }
        return this.frame;
    }

    public void setFrame(String value) {
        this.frame = value;
    }

    public String getCalendarEraName() {
        return this.calendarEraName;
    }

    public void setCalendarEraName(String value) {
        this.calendarEraName = value;
    }

    @Override
    public TimeIndeterminateValueType getIndeterminatePosition() {
        return this.indeterminatePosition;
    }

    public void setIndeterminatePosition(TimeIndeterminateValueType value) {
        this.indeterminatePosition = value;
    }

    @Override
    public Date getDate() {
        if (this.value != null && !this.value.isEmpty()) {
            return this.parseDate(this.value.get(0));
        }
        return null;
    }

    @Override
    public Time getTime() {
        if (this.value != null && !this.value.isEmpty()) {
            return Time.valueOf(this.value.get(0));
        }
        return null;
    }

    @Override
    public InternationalString getDateTime() {
        if (this.value != null && !this.value.isEmpty()) {
            return new SimpleInternationalString(this.value.get(0));
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TimePositionType) {
            TimePositionType that = (TimePositionType)object;
            return Utilities.equals(this.calendarEraName, that.calendarEraName) && Utilities.equals(this.frame, that.frame) && Utilities.equals((Object)this.indeterminatePosition, (Object)that.indeterminatePosition) && (Utilities.equals(this.value, that.value) || Utilities.equals(this.getDate(), that.getDate()));
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.value != null ? ((Object)this.value).hashCode() : 0);
        hash = 97 * hash + (this.calendarEraName != null ? this.calendarEraName.hashCode() : 0);
        hash = 97 * hash + (this.frame != null ? this.frame.hashCode() : 0);
        hash = 97 * hash + (this.indeterminatePosition != null ? this.indeterminatePosition.hashCode() : 0);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        if (this.calendarEraName != null) {
            s2.append("calendarEraName:").append(this.calendarEraName).append('\n');
        }
        if (this.frame != null) {
            s2.append("frame:").append(this.frame).append('\n');
        }
        if (this.indeterminatePosition != null) {
            s2.append("indeterminatePosition:").append(this.indeterminatePosition.value()).append('\n');
        }
        if (this.value != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("d MMMMM yyyy HH:mm:ss z");
            for (String v : this.value) {
                try {
                    Date date;
                    DateFormat dateFormat = (DateFormat)FORMATTERS.get(0);
                    synchronized (dateFormat) {
                        date = ((DateFormat)FORMATTERS.get(0)).parse(v);
                    }
                    s2.append(sdf.format(date));
                }
                catch (ParseException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
            }
        }
        return s2.toString();
    }
}

