/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing.factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.factory.DirectAuthorityFactory;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public final class IGNF
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    private final Map<String, Object> crsMap = new TreeMap<String, Object>();
    private final Set<String> codes;

    public IGNF() {
        super(EMPTY_HINTS);
        this.crsMap.put("MILLER", "Miller_Cylindrical");
        this.codes = Collections.unmodifiableSet(this.crsMap.keySet());
    }

    @Override
    public Citation getAuthority() {
        return Citations.IGNF;
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) {
        return clazz.isAssignableFrom(ProjectedCRS.class) ? this.codes : Collections.emptySet();
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        return new SimpleInternationalString(this.createObject(string).getName().getCode());
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.createCoordinateReferenceSystem(string);
    }

    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        String string2 = this.trimAuthority(string).toUpperCase();
        Object object = this.crsMap.get(string2);
        if (object == null) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, string);
        }
        if (object instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)object;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", new NamedIdentifier(Citations.OGC, "GRS80"));
        DefaultGeodeticDatum defaultGeodeticDatum = new DefaultGeodeticDatum(hashMap, (Ellipsoid)DefaultEllipsoid.GRS80);
        ParameterValueGroup parameterValueGroup = this.factories.getMathTransformFactory().getDefaultParameters((String)object);
        parameterValueGroup.parameter("semi_major").setValue(6378137);
        parameterValueGroup.parameter("semi_minor").setValue(6378137);
        ReferenceIdentifier[] referenceIdentifierArray = new ReferenceIdentifier[]{new NamedIdentifier(Citations.IGNF, "MILLER"), new DefaultReferenceIdentifier(Citations.EPSG, "EPSG", "310642901"), new DefaultReferenceIdentifier(Citations.EPSG, "EPSG", "54003")};
        hashMap.clear();
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("identifiers", referenceIdentifierArray);
        ProjectedCRS projectedCRS = this.factories.getCRSFactory().createProjectedCRS(hashMap, new DefaultGeographicCRS(defaultGeodeticDatum, DefaultEllipsoidalCS.GEODETIC_2D), new DefiningConversion("Miller", parameterValueGroup), DefaultCartesianCS.PROJECTED);
        this.crsMap.put(string2, projectedCRS);
        return projectedCRS;
    }
}

