/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;

public final class Synchronizer {
    private static final Level SELECT = Level.FINE;
    private static final Level UPDATE = Level.FINE;
    private final Connection source;
    private final Connection target;
    private transient DatabaseMetaData sourceMetadata;
    private transient DatabaseMetaData targetMetadata;
    public String sourceCatalog;
    public String targetCatalog;
    public String sourceSchema;
    public String targetSchema;
    private final Writer out;
    private boolean pretend;
    public volatile boolean cancel;

    public Synchronizer(Connection connection, Connection connection2, Writer writer) {
        this.source = connection;
        this.target = connection2;
        this.out = writer;
    }

    public Synchronizer(String string, String string2) throws SQLException {
        this.source = DriverManager.getConnection(string);
        this.target = DriverManager.getConnection(string2);
        this.out = IOUtilities.standardWriter();
        this.source.setReadOnly(true);
    }

    private static void appendTableName(StringBuilder stringBuilder, String string, String string2, String string3) {
        stringBuilder.append(string3);
        if (string != null) {
            stringBuilder.append(string).append(string3).append('.').append(string3);
        }
        stringBuilder.append(string2).append(string3);
    }

    private static boolean contains(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private String[] getPrimaryKeys(String string) throws SQLException {
        String string2 = this.targetCatalog;
        String string3 = this.targetSchema;
        ResultSet resultSet = this.targetMetadata.getPrimaryKeys(string2, string3, string);
        String[] stringArray = Strings.EMPTY;
        while (resultSet.next()) {
            if (string2 != null && !string2.equals(resultSet.getString("TABLE_CAT")) || string3 != null && !string3.equals(resultSet.getString("TABLE_SCHEM")) || !string.equals(resultSet.getString("TABLE_NAME"))) continue;
            String string4 = resultSet.getString("COLUMN_NAME");
            short s2 = resultSet.getShort("KEY_SEQ");
            if (s2 > stringArray.length) {
                stringArray = Arrays.copyOf(stringArray, (int)s2);
            }
            stringArray[s2 - 1] = string4;
        }
        resultSet.close();
        return stringArray;
    }

    private static int getColumnIndex(ResultSetMetaData resultSetMetaData, String string) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            if (!string.equals(resultSetMetaData.getColumnName(i))) continue;
            return i;
        }
        return 0;
    }

    private static int[] getColumnIndex(ResultSetMetaData resultSetMetaData, String[] stringArray) throws SQLException {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Synchronizer.getColumnIndex(resultSetMetaData, stringArray[i]);
        }
        return nArray;
    }

    private void delete(String string, String string2) throws SQLException {
        String string3 = this.targetMetadata.getIdentifierQuoteString();
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
        Synchronizer.appendTableName(stringBuilder, this.targetSchema, string, string3);
        if (string2 != null) {
            stringBuilder.append(" WHERE ").append(string2);
        }
        String string4 = stringBuilder.toString();
        Statement statement = this.target.createStatement();
        int n = this.pretend ? 0 : statement.executeUpdate(string4);
        Synchronizer.log(UPDATE, "delete", string4 + '\n' + n + " lignes supprim\u00e9es.");
        statement.close();
    }

    private void insert(String string, String string2, Policy policy) throws SQLException, IOException {
        int n;
        Object object;
        PreparedStatement preparedStatement;
        String string3 = this.sourceMetadata.getIdentifierQuoteString();
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ");
        Synchronizer.appendTableName(stringBuilder, this.sourceSchema, string, string3);
        if (string2 != null) {
            stringBuilder.append(" WHERE ").append(string2);
        }
        String string4 = stringBuilder.toString();
        Statement statement = this.source.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        String[] stringArray = new String[resultSetMetaData.getColumnCount()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2++] = resultSetMetaData.getColumnName(n2);
        }
        Synchronizer.log(SELECT, "insert", string4);
        String[] stringArray2 = this.getPrimaryKeys(string);
        int[] nArray = new int[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string5 = stringArray2[i];
            nArray[i] = Synchronizer.getColumnIndex(resultSetMetaData, string5);
            if (nArray[i] != 0) continue;
            throw new SQLException("Primary key \"" + string5 + "\" defined in the target \"" + string + "\" table is not found in the source table.");
        }
        int[] nArray2 = new int[stringArray.length - nArray.length];
        int n3 = 0;
        int n4 = 0;
        while (n3 < stringArray.length) {
            if (Synchronizer.contains(nArray, ++n3)) continue;
            nArray2[n4++] = n3;
        }
        assert (!Synchronizer.contains(nArray2, 0));
        n4 = nArray2.length != 0 && policy == Policy.INSERT_OR_UPDATE ? 1 : 0;
        String string6 = this.targetMetadata.getIdentifierQuoteString();
        if (stringArray2.length == 0 || policy == Policy.DELETE_BEFORE_INSERT) {
            preparedStatement = null;
        } else {
            int n5;
            stringBuilder.setLength(0);
            Synchronizer.appendTableName(stringBuilder.append(n4 != 0 ? "UPDATE " : "SELECT * FROM "), this.targetSchema, string, string6);
            if (n4 != 0) {
                stringBuilder.append(" SET ");
                boolean bl = false;
                for (n5 = 0; n5 < nArray2.length; ++n5) {
                    if (bl) {
                        stringBuilder.append(',');
                    } else {
                        bl = true;
                    }
                    object = stringArray[nArray2[n5] - 1];
                    stringBuilder.append(string6).append((String)object).append(string6).append("=?");
                }
            }
            String string7 = " WHERE ";
            for (n5 = 0; n5 < stringArray2.length; ++n5) {
                object = stringArray2[n5];
                stringBuilder.append(string7).append(string6).append((String)object).append(string6).append("=?");
                string7 = " AND ";
            }
            string4 = stringBuilder.toString();
            preparedStatement = this.target.prepareStatement(string4);
        }
        stringBuilder.setLength(0);
        Synchronizer.appendTableName(stringBuilder.append("INSERT INTO "), this.targetSchema, string, string6);
        stringBuilder.append(" (");
        for (n = 0; n < stringArray.length; ++n) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string6).append(stringArray[n]).append(string6);
        }
        stringBuilder.append(") VALUES (");
        for (n = 0; n < stringArray.length; ++n) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('?');
        }
        string4 = stringBuilder.append(')').toString();
        PreparedStatement preparedStatement2 = this.target.prepareStatement(string4);
        int[] nArray3 = null;
        object = null;
        Object[] objectArray = new Object[stringArray2.length];
        while (resultSet.next() && !this.cancel) {
            int n6;
            if (preparedStatement != null) {
                Object object2;
                int n7;
                n6 = 0;
                if (n4 != 0) {
                    for (n7 = 0; n7 < nArray2.length; ++n7) {
                        object2 = resultSet.getObject(nArray2[n7]);
                        preparedStatement.setObject(++n6, object2);
                    }
                }
                for (n7 = 0; n7 < nArray.length; ++n7) {
                    object2 = resultSet.getObject(nArray[n7]);
                    preparedStatement.setObject(++n6, object2);
                    objectArray[n7] = object2;
                }
                n7 = 0;
                if (n4 != 0) {
                    n7 = preparedStatement.executeUpdate();
                } else {
                    object2 = preparedStatement.executeQuery();
                    if (nArray3 == null) {
                        nArray3 = Synchronizer.getColumnIndex(object2.getMetaData(), stringArray);
                    }
                    while (object2.next()) {
                        for (int i = 0; i < nArray3.length; ++i) {
                            String string8;
                            String string9;
                            int n8 = nArray3[i];
                            if (n8 == 0 || Utilities.equals(string9 = resultSet.getString(i + 1), string8 = object2.getString(n8))) continue;
                            if (object == null) {
                                object = this.createMismatchTable(string, stringArray2);
                            } else {
                                ((TableWriter)object).nextLine();
                            }
                            for (int j = 0; j < objectArray.length; ++j) {
                                ((TableWriter)object).write(String.valueOf(objectArray[j]));
                                ((TableWriter)object).nextColumn();
                            }
                            ((TableWriter)object).write(stringArray[i]);
                            ((TableWriter)object).nextColumn();
                            ((TableWriter)object).write(string9);
                            ((TableWriter)object).nextColumn();
                            ((TableWriter)object).write(string8);
                            ((TableWriter)object).nextLine();
                        }
                        ++n7;
                    }
                    object2.close();
                }
                if (n7 != 0) continue;
            }
            for (n6 = 1; n6 <= stringArray.length; ++n6) {
                preparedStatement2.setObject(n6, resultSet.getObject(n6));
            }
            int n9 = n6 = this.pretend ? 1 : preparedStatement2.executeUpdate();
            if (n6 == 1) {
                Synchronizer.log(UPDATE, "insert", preparedStatement2.toString());
                continue;
            }
            Synchronizer.log(Level.WARNING, "insert", n6 + " enregistrements ajout\u00e9s.");
        }
        resultSet.close();
        statement.close();
        preparedStatement2.close();
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (object != null) {
            ((TableWriter)object).nextLine('\u2500');
            ((TableWriter)object).flush();
        }
    }

    private TableWriter createMismatchTable(String string, String[] stringArray) throws IOException {
        String string2 = System.getProperty("line.separator", "\n");
        this.out.write(string2);
        this.out.write(string);
        this.out.write(string2);
        TableWriter tableWriter = new TableWriter(this.out, " \u2502 ");
        tableWriter.nextLine('\u2500');
        for (int i = 0; i < stringArray.length; ++i) {
            tableWriter.write(stringArray[i]);
            tableWriter.nextColumn();
        }
        tableWriter.write("Colonne");
        tableWriter.nextColumn();
        tableWriter.write("Valeur \u00e0 copier");
        tableWriter.nextColumn();
        tableWriter.write("Valeur existante");
        tableWriter.nextLine();
        tableWriter.nextLine('\u2500');
        return tableWriter;
    }

    private void copy(String string, Map<String, String> map, Policy policy) throws SQLException, IOException {
        String string2 = map.remove(string);
        if (string2 != null && (string2 = string2.trim()).isEmpty()) {
            string2 = null;
        }
        if (policy == Policy.DELETE_BEFORE_INSERT) {
            this.delete(string, string2);
        }
        String string3 = this.targetCatalog;
        String string4 = this.targetSchema;
        ResultSet resultSet = this.targetMetadata.getImportedKeys(string3, string4, string);
        while (resultSet.next()) {
            String string5 = resultSet.getString("PKTABLE_CAT");
            if (string3 != null && !string3.equals(string5)) continue;
            string5 = resultSet.getString("PKTABLE_SCHEM");
            if (string4 != null && !string4.equals(string5) || !map.containsKey(string5 = resultSet.getString("PKTABLE_NAME"))) continue;
            this.copy(string5, map, policy);
        }
        resultSet.close();
        this.insert(string, string2, policy);
    }

    public void copy(Policy policy, Map<String, String> map) throws SQLException, IOException {
        String string = this.targetCatalog;
        String string2 = this.targetSchema;
        this.sourceMetadata = this.source.getMetaData();
        this.targetMetadata = this.target.getMetaData();
        block0: while (!map.isEmpty()) {
            String string32;
            block1: for (String string32 : map.keySet()) {
                if (this.cancel) break block0;
                ResultSet resultSet = this.targetMetadata.getExportedKeys(string, string2, string32);
                while (resultSet.next()) {
                    String string4;
                    if (string != null && !string.equals(resultSet.getString("FKTABLE_CAT")) || string2 != null && !string2.equals(resultSet.getString("FKTABLE_SCHEM")) || !map.containsKey(string4 = resultSet.getString("FKTABLE_NAME"))) continue;
                    resultSet.close();
                    continue block1;
                }
                resultSet.close();
                this.copy(string32, map, policy);
                continue block0;
            }
            Iterator<String> iterator = map.keySet().iterator();
            if (!iterator.hasNext()) continue;
            string32 = iterator.next();
            this.copy(string32, map, policy);
        }
    }

    public void copy(Policy policy, String ... stringArray) throws SQLException, IOException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(XCollections.hashMapCapacity(stringArray.length));
        for (String string : stringArray) {
            linkedHashMap.put(string, null);
        }
        this.copy(policy, linkedHashMap);
    }

    public void close() throws SQLException {
        this.sourceMetadata = null;
        this.targetMetadata = null;
        this.target.close();
        this.source.close();
    }

    private static void log(Level level, String string, String string2) {
        LogRecord logRecord = new LogRecord(level, string2);
        logRecord.setSourceClassName(Synchronizer.class.getName());
        logRecord.setSourceMethodName(string);
        Logging.getLogger(Synchronizer.class).log(logRecord);
    }

    public static enum Policy {
        INSERT_ONLY,
        INSERT_OR_UPDATE,
        DELETE_BEFORE_INSERT;

    }
}

