/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LEDataInputStream
extends InputStream
implements DataInput {
    private final DataInputStream ds;
    private final InputStream in;
    private final byte[] buffer = new byte[8];

    public LEDataInputStream(InputStream in) {
        this.in = in;
        this.ds = new DataInputStream(in);
    }

    @Override
    public int available() throws IOException {
        return this.ds.available();
    }

    @Override
    public final short readShort() throws IOException {
        this.ds.readFully(this.buffer, 0, 2);
        return (short)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.ds.readFully(this.buffer, 0, 2);
        return (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    @Override
    public final char readChar() throws IOException {
        this.ds.readFully(this.buffer, 0, 2);
        return (char)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.ds.readFully(this.buffer, 0, 4);
        return this.buffer[3] << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        this.ds.readFully(this.buffer, 0, 8);
        return (long)this.buffer[7] << 56 | (long)(this.buffer[6] & 0xFF) << 48 | (long)(this.buffer[5] & 0xFF) << 40 | (long)(this.buffer[4] & 0xFF) << 32 | (long)(this.buffer[3] & 0xFF) << 24 | (long)(this.buffer[2] & 0xFF) << 16 | (long)(this.buffer[1] & 0xFF) << 8 | (long)(this.buffer[0] & 0xFF);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.ds.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.ds.readFully(b, off, len);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.ds.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.ds.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.ds.readByte();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.ds.readUnsignedByte();
    }

    @Override
    public final String readLine() throws IOException {
        return this.ds.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.ds.readUTF();
    }

    @Override
    public final void close() throws IOException {
        this.ds.close();
    }
}

