/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.ModifiableMetadata;
import org.geotoolkit.metadata.PropertyComparator;
import org.geotoolkit.metadata.TypeValuePolicy;
import org.geotoolkit.metadata.UnmodifiableMetadataException;
import org.geotoolkit.metadata.ValueRestriction;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.CheckedContainer;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.ConverterRegistry;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.Numbers;
import org.geotoolkit.util.converter.ObjectConverter;
import org.geotoolkit.xml.IdentifiedObject;
import org.opengis.annotation.UML;

@ThreadSafe
final class PropertyAccessor {
    private static final Locale LOCALE = Locale.US;
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final Map<Class<?>, Method[]> SHARED_GETTERS = new HashMap();
    private static final Method EXTRA_GETTER;
    final Class<?> type;
    final Class<?> implementation;
    private final int standardCount;
    private final int allCount;
    private final Method[] getters;
    private final Method[] setters;
    private final String[] names;
    private final Class<?>[] elementTypes;
    private final Map<String, Integer> mapping;
    private volatile transient ObjectConverter<?, ?> converter;
    private transient ValueRestriction[] restrictions;

    PropertyAccessor(Class<?> clazz, Class<?> clazz2) {
        int n;
        this.implementation = clazz;
        this.type = clazz2;
        assert (clazz2.isAssignableFrom(clazz)) : clazz;
        this.getters = PropertyAccessor.getGetters(clazz2);
        int n2 = n = this.getters.length;
        if (n != 0 && this.getters[n - 1] == EXTRA_GETTER) {
            if (!EXTRA_GETTER.getDeclaringClass().isAssignableFrom(clazz)) {
                --n;
            }
            --n2;
        }
        this.allCount = n;
        this.standardCount = n2;
        this.mapping = new HashMap<String, Integer>(XCollections.hashMapCapacity(n));
        this.names = new String[n];
        this.elementTypes = new Class[n];
        Method[] methodArray = null;
        Class[] classArray = new Class[1];
        for (int i = 0; i < n; ++i) {
            Class<?> clazz3;
            Method method;
            Method method2;
            block17: {
                Class<?> clazz4;
                Integer n3 = i;
                method2 = this.getters[i];
                String string = method2.getName();
                int n4 = PropertyAccessor.prefix(string).length();
                this.names[i] = PropertyAccessor.toPropertyName(string, n4);
                this.addMapping(this.names[i], n3);
                this.addMapping(string, n3);
                UML uML = method2.getAnnotation(UML.class);
                if (uML != null) {
                    this.addMapping(uML.identifier(), n3);
                }
                classArray[0] = clazz4 = method2.getReturnType();
                if (string.length() > n4) {
                    char c = string.charAt(n4);
                    char c2 = Character.toUpperCase(c);
                    int n5 = string.length();
                    StringBuilder stringBuilder = new StringBuilder(n5 - n4 + 3).append(SET);
                    if (c != c2) {
                        stringBuilder.append(c2).append(string, n4 + 1, n5);
                    } else {
                        stringBuilder.append(string, n4, n5);
                    }
                    string = stringBuilder.toString();
                }
                method = null;
                try {
                    method = clazz.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method2 = clazz.getMethod(method2.getName(), null);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        throw new AssertionError((Object)noSuchMethodException2);
                    }
                    Class<?> clazz5 = clazz4;
                    clazz4 = method2.getReturnType();
                    if (clazz5 == clazz4) break block17;
                    classArray[0] = clazz4;
                    try {
                        method = clazz.getMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        // empty catch block
                    }
                }
            }
            if (method != null) {
                if (methodArray == null) {
                    methodArray = new Method[n];
                }
                methodArray[i] = method;
            }
            if (Collection.class.isAssignableFrom(clazz3 = method2.getReturnType())) {
                clazz3 = Classes.boundOfParameterizedAttribute(method2);
            }
            this.elementTypes[i] = Numbers.primitiveToWrapper(clazz3);
        }
        this.setters = methodArray;
    }

    private void addMapping(String string, Integer n) throws IllegalArgumentException {
        if (!string.isEmpty()) {
            String string2;
            do {
                Integer n2;
                if ((n2 = this.mapping.put(string, n)) != null && !n2.equals(n)) {
                    throw new IllegalStateException(Errors.format(56, Classes.getShortName(this.type) + '.' + string));
                }
                string2 = string;
            } while (!(string = string.toLowerCase(LOCALE).trim()).equals(string2));
        }
    }

    static Class<?> getStandardType(Class<?> clazz, String string) {
        if (clazz != null) {
            if (clazz.isInterface()) {
                if (clazz.getName().startsWith(string)) {
                    return clazz;
                }
            } else {
                Class clazz2;
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                do {
                    PropertyAccessor.getInterfaces(clazz, string, linkedHashSet);
                } while ((clazz = clazz.getSuperclass()) != null);
                Iterator iterator = linkedHashSet.iterator();
                block1: while (iterator.hasNext()) {
                    clazz2 = (Class)iterator.next();
                    for (Class clazz3 : linkedHashSet) {
                        if (clazz2 == clazz3 || !clazz2.isAssignableFrom(clazz3)) continue;
                        iterator.remove();
                        continue block1;
                    }
                }
                iterator = linkedHashSet.iterator();
                if (iterator.hasNext()) {
                    clazz2 = (Class)iterator.next();
                    if (!iterator.hasNext()) {
                        return clazz2;
                    }
                }
            }
        }
        return null;
    }

    private static void getInterfaces(Class<?> clazz, String string, Collection<Class<?>> collection) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (clazz2.getName().startsWith(string)) {
                collection.add(clazz2);
            }
            PropertyAccessor.getInterfaces(clazz2, string, collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method[] getGetters(Class<?> clazz) {
        Map<Class<?>, Method[]> map = SHARED_GETTERS;
        synchronized (map) {
            Method[] methodArray = SHARED_GETTERS.get(clazz);
            if (methodArray == null) {
                methodArray = clazz.getMethods();
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>(XCollections.hashMapCapacity(methodArray.length));
                boolean bl = false;
                int n = 0;
                for (Method method : methodArray) {
                    String string;
                    if (!Classes.isPossibleGetter(method) || (string = method.getName()).startsWith(SET)) continue;
                    Integer n2 = hashMap.put(string, n);
                    if (n2 != null) {
                        Class<?> clazz2 = methodArray[n2].getReturnType();
                        Class<?> clazz3 = method.getReturnType();
                        if (clazz3.isAssignableFrom(clazz2)) continue;
                        if (clazz2.isAssignableFrom(clazz3)) {
                            methodArray[n2.intValue()] = method;
                            continue;
                        }
                        throw new ClassCastException(Errors.format(265, Classes.getShortName(clazz) + '.' + string, clazz2, clazz3));
                    }
                    methodArray[n++] = method;
                    if (bl) continue;
                    bl = string.equals(EXTRA_GETTER.getName());
                }
                Arrays.sort(methodArray, 0, n, PropertyComparator.INSTANCE);
                if (!bl) {
                    if (methodArray.length == n) {
                        methodArray = Arrays.copyOf(methodArray, n + 1);
                    }
                    methodArray[n++] = EXTRA_GETTER;
                }
                methodArray = XArrays.resize(methodArray, n);
                SHARED_GETTERS.put(clazz, methodArray);
            }
            return methodArray;
        }
    }

    private static String prefix(String string) {
        if (string.startsWith(GET)) {
            return GET;
        }
        if (string.startsWith(IS)) {
            return IS;
        }
        if (string.startsWith(SET)) {
            return SET;
        }
        return "";
    }

    private static boolean isAcronym(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if (!Character.isLowerCase(string.charAt(n++))) continue;
            return false;
        }
        return true;
    }

    private static String toPropertyName(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            char c;
            char c2;
            string = PropertyAccessor.isAcronym(string, n) ? string.substring(n) : ((c2 = string.charAt(n)) != (c = Character.toLowerCase(c2)) ? new StringBuilder(n2 - n).append(c).append(string, n + 1, n2).toString() : string.substring(n));
        }
        return string.trim().intern();
    }

    final int count() {
        return this.standardCount;
    }

    final int indexOf(String string) {
        String string2;
        Integer n = this.mapping.get(string);
        if (n == null && ((string2 = string.replace(" ", "").toLowerCase(LOCALE).trim()) == string || (n = this.mapping.get(string2)) == null)) {
            return -1;
        }
        return n;
    }

    final int requiredIndexOf(String string) throws IllegalArgumentException {
        int n = this.indexOf(string);
        if (n >= 0) {
            return n;
        }
        throw new IllegalArgumentException(Errors.format(264, string, this.type));
    }

    final Class<?> getDeclaringClass(int n) {
        if (n >= 0 && n < this.names.length) {
            return this.getters[n].getDeclaringClass();
        }
        return null;
    }

    final String name(int n, KeyNamePolicy keyNamePolicy) {
        if (n >= 0 && n < this.names.length) {
            switch (keyNamePolicy) {
                case UML_IDENTIFIER: {
                    UML uML = this.getters[n].getAnnotation(UML.class);
                    if (uML != null) {
                        return uML.identifier();
                    }
                }
                case JAVABEANS_PROPERTY: {
                    return this.names[n];
                }
                case METHOD_NAME: {
                    return this.getters[n].getName();
                }
                case SENTENCE: {
                    return Strings.camelCaseToSentence(this.names[n]);
                }
            }
        }
        return null;
    }

    final Class<?> type(int n, TypeValuePolicy typeValuePolicy) {
        if (n >= 0 && n < this.standardCount) {
            switch (typeValuePolicy) {
                case ELEMENT_TYPE: {
                    return this.elementTypes[n];
                }
                case PROPERTY_TYPE: {
                    return this.getters[n].getReturnType();
                }
                case DECLARING_INTERFACE: {
                    return this.getters[n].getDeclaringClass();
                }
                case DECLARING_CLASS: {
                    Method method = this.getters[n];
                    if (this.implementation != this.type) {
                        try {
                            method = this.implementation.getMethod(method.getName(), null);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new AssertionError((Object)noSuchMethodException);
                        }
                    }
                    return method.getDeclaringClass();
                }
            }
        }
        return null;
    }

    final synchronized ValueRestriction restriction(int n) {
        Object[] objectArray = this.restrictions;
        if (objectArray == null) {
            objectArray = new ValueRestriction[this.standardCount];
            this.restrictions = objectArray;
            Arrays.fill(objectArray, ValueRestriction.PENDING);
        }
        if (n < 0 || n >= objectArray.length) {
            return null;
        }
        ValueRestriction valueRestriction = objectArray[n];
        if (valueRestriction == ValueRestriction.PENDING) {
            Method method;
            Method method2 = this.getters[n];
            if (this.implementation == this.type) {
                method = method2;
            } else {
                try {
                    method = this.implementation.getMethod(method2.getName(), null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)noSuchMethodException);
                }
            }
            valueRestriction = ValueRestriction.create(this.elementTypes[n], method2, method);
            objectArray[n] = valueRestriction;
        }
        return valueRestriction;
    }

    final boolean isWritable(int n) {
        return n >= 0 && n < this.standardCount && this.setters != null && this.setters[n] != null;
    }

    final Object get(int n, Object object) {
        return n >= 0 && n < this.standardCount ? PropertyAccessor.get(this.getters[n], object) : null;
    }

    private static Object get(Method method, Object object) {
        assert (method.getReturnType() != Void.TYPE) : method;
        try {
            return method.invoke(object, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
    }

    final Object set(int n, Object object, Object object2, boolean bl) throws UnsupportedOperationException, ClassCastException {
        if (n >= 0 && n < this.standardCount && this.setters != null) {
            Method method = this.getters[n];
            Method method2 = this.setters[n];
            if (method2 != null) {
                Collection collection;
                if (bl) {
                    collection = PropertyAccessor.get(method, object);
                    if (collection instanceof Collection) {
                        collection = XCollections.copy(collection);
                    } else if (collection instanceof Map) {
                        collection = XCollections.copy((Map)((Object)collection));
                    }
                } else {
                    collection = null;
                }
                Object[] objectArray = new Object[]{object2};
                this.converter = PropertyAccessor.convert(method, object, objectArray, this.elementTypes[n], this.converter);
                PropertyAccessor.set(method2, object, objectArray);
                return collection;
            }
        }
        throw new UnsupportedOperationException(Errors.format(190, this.names[n]));
    }

    private static void set(Method method, Object object, Object[] objectArray) {
        try {
            method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
    }

    private static ObjectConverter<?, ?> convert(Method method, Object object, Object[] objectArray, Class<?> clazz, ObjectConverter<?, ?> objectConverter) throws ClassCastException {
        assert (objectArray.length == 1);
        Collection<Object> collection = objectArray[0];
        if (collection == null) {
            Class<?> clazz2 = method.getReturnType();
            if (clazz2.isPrimitive()) {
                objectArray[0] = Numbers.valueOfNil(clazz2);
            }
        } else {
            Class<?> clazz3 = method.getReturnType();
            if (!Collection.class.isAssignableFrom(clazz3)) {
                if (collection instanceof Collection) {
                    Iterator iterator = ((Collection)collection).iterator();
                    if (!iterator.hasNext()) {
                        objectArray[0] = null;
                        return objectConverter;
                    }
                    Object e = iterator.next();
                    if (!iterator.hasNext()) {
                        collection = e;
                    }
                }
                assert (clazz == Numbers.primitiveToWrapper(clazz3)) : clazz;
                clazz3 = clazz;
            } else {
                Collection collection2;
                Object[] objectArray2;
                if (collection instanceof Collection) {
                    objectArray2 = ((Collection)collection).toArray();
                    collection = Arrays.asList(objectArray2);
                    collection2 = null;
                } else {
                    objectArray2 = new Object[]{collection};
                    collection2 = (Collection)PropertyAccessor.get(method, object);
                    collection = collection2;
                    if (collection2 == null) {
                        collection = Arrays.asList(objectArray2);
                    } else if (collection2 instanceof CheckedContainer) {
                        clazz = ((CheckedContainer)((Object)collection2)).getElementType();
                    }
                }
                if (clazz != null) {
                    objectConverter = PropertyAccessor.convert(objectArray2, clazz, objectConverter);
                }
                if (collection2 != null) {
                    Collection collection3 = collection2;
                    collection3.add(objectArray2[0]);
                }
            }
            objectArray[0] = collection;
            objectConverter = PropertyAccessor.convert(objectArray, clazz3, objectConverter);
        }
        return objectConverter;
    }

    private static ObjectConverter<?, ?> convert(Object[] objectArray, Class<?> clazz, ObjectConverter<?, ?> objectConverter) throws ClassCastException {
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz2;
            Object object = objectArray[i];
            if (object == null || clazz.isAssignableFrom(clazz2 = object.getClass())) continue;
            try {
                if (objectConverter == null || !objectConverter.getSourceClass().isAssignableFrom(clazz2) || !clazz.isAssignableFrom(objectConverter.getTargetClass())) {
                    objectConverter = ConverterRegistry.system().converter(clazz2, clazz);
                }
                objectArray[i] = objectConverter.convert(object);
                continue;
            }
            catch (NonconvertibleObjectException nonconvertibleObjectException) {
                ClassCastException classCastException = new ClassCastException(Errors.format(76, clazz2, clazz));
                classCastException.initCause(nonconvertibleObjectException);
                throw classCastException;
            }
        }
        return objectConverter;
    }

    public boolean shallowEquals(Object object, Object object2, ComparisonMode comparisonMode, boolean bl) {
        assert (this.type.isInstance(object)) : object;
        assert (this.type.isInstance(object2)) : object2;
        int n = comparisonMode == ComparisonMode.STRICT && EXTRA_GETTER.getDeclaringClass().isInstance(object2) ? this.allCount : this.standardCount;
        for (int i = 0; i < n; ++i) {
            Method method = this.getters[i];
            Object object3 = PropertyAccessor.get(method, object);
            Object object4 = PropertyAccessor.get(method, object2);
            boolean bl2 = PropertyAccessor.isEmpty(object3);
            boolean bl3 = PropertyAccessor.isEmpty(object4);
            if (bl2 && bl3 || Utilities.deepEquals(object3, object4, comparisonMode) || comparisonMode.ordinal() < ComparisonMode.APPROXIMATIVE.ordinal() && InternalUtilities.floatEpsilonEqual(object3, object4) || bl && (bl2 || bl3)) continue;
            return false;
        }
        return true;
    }

    public boolean shallowCopy(Object object, Object object2, boolean bl) throws UnmodifiableMetadataException {
        ObjectConverter<?, ?> objectConverter = this.converter;
        boolean bl2 = true;
        assert (this.type.isInstance(object)) : Classes.getClass(object);
        Object[] objectArray = new Object[1];
        for (int i = 0; i < this.standardCount; ++i) {
            Method method = this.getters[i];
            objectArray[0] = PropertyAccessor.get(method, object);
            if (bl && PropertyAccessor.isEmpty(objectArray[0])) continue;
            if (this.setters == null) {
                return false;
            }
            Method method2 = this.setters[i];
            if (method2 != null) {
                objectConverter = PropertyAccessor.convert(method, object2, objectArray, this.elementTypes[i], objectConverter);
                PropertyAccessor.set(method2, object2, objectArray);
                continue;
            }
            bl2 = false;
        }
        this.converter = objectConverter;
        return bl2;
    }

    final void freeze(Object object) {
        assert (this.implementation.isInstance(object)) : object;
        if (this.setters != null) {
            Object[] objectArray = new Object[1];
            for (int i = 0; i < this.allCount; ++i) {
                Object object2;
                Method method;
                Object object3;
                Method method2 = this.setters[i];
                if (method2 == null || (object3 = PropertyAccessor.get(method = this.getters[i], object)) == (object2 = ModifiableMetadata.unmodifiable(object3))) continue;
                objectArray[0] = object2;
                PropertyAccessor.set(method2, object, objectArray);
            }
        }
    }

    final boolean isModifiable() {
        if (this.setters != null) {
            return true;
        }
        for (int i = 0; i < this.allCount; ++i) {
            if (!Cloneable.class.isAssignableFrom(this.getters[i].getReturnType())) continue;
            return true;
        }
        return false;
    }

    public int hashCode(Object object) {
        assert (this.type.isInstance(object)) : object;
        int n = 0;
        for (int i = 0; i < this.standardCount; ++i) {
            Object object2 = PropertyAccessor.get(this.getters[i], object);
            if (PropertyAccessor.isEmpty(object2)) continue;
            n += object2.hashCode();
        }
        return n;
    }

    public int count(Object object, int n) {
        assert (this.type.isInstance(object)) : object;
        int n2 = 0;
        for (int i = 0; i < this.standardCount && (PropertyAccessor.isEmpty(PropertyAccessor.get(this.getters[i], object)) || ++n2 < n); ++i) {
        }
        return n2;
    }

    static boolean isEmpty(Object object) {
        return object == null || object instanceof CharSequence && object.toString().trim().isEmpty() || object instanceof Collection && ((Collection)object).isEmpty() || object instanceof Map && ((Map)object).isEmpty() || object.getClass().isArray() && Array.getLength(object) == 0;
    }

    static {
        try {
            EXTRA_GETTER = IdentifiedObject.class.getMethod("getIdentifiers", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }
}

