/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import net.jcip.annotations.Immutable;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.provider.AbridgedMolodensky;
import org.geotoolkit.referencing.operation.provider.Molodensky;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.EllipsoidalTransform;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.referencing.operation.transform.MolodenskyTransform2D;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class MolodenskyTransform
extends AbstractMathTransform
implements EllipsoidalTransform,
Serializable {
    private static final long serialVersionUID = 7206439437113286122L;
    private static final double ISIN = 1.0000000000039173;
    private static final int TARGET_DIMENSION_MASK = 1;
    private static final int SOURCE_DIMENSION_MASK = 2;
    private static final int INVERSE_MASK = 4;
    private static final int ABRIDGED_MASK = 8;
    private static final int VARIANT_MASK = 7;
    private final int type;
    final double dx;
    final double dy;
    final double dz;
    final double a;
    final double b;
    final double da;
    final double db;
    private final double df;
    private final double b_a;
    private final double a_b;
    private final double daa;
    private final double da_a;
    private final double e2;
    private final double adf;
    private transient MolodenskyTransform[] variants;

    protected MolodenskyTransform(boolean bl, double d, double d2, boolean bl2, double d3, double d4, boolean bl3, double d5, double d6, double d7) {
        int n;
        int n2 = n = bl ? 8 : 0;
        if (bl2) {
            n |= 2;
        }
        if (bl3) {
            n |= 1;
        }
        this.type = n;
        this.dx = d5;
        this.dy = d6;
        this.dz = d7;
        this.a = d;
        this.b = d2;
        this.da = d3 - d;
        this.db = d4 - d2;
        this.a_b = d / d2;
        this.b_a = d2 / d;
        this.daa = this.da * d;
        this.da_a = this.da / d;
        this.df = (d3 - d4) / d3 - (d - d2) / d;
        this.e2 = 1.0 - d2 * d2 / (d * d);
        this.adf = d * this.df + (d - d2) * (this.da / d);
    }

    protected MolodenskyTransform(MolodenskyTransform molodenskyTransform, boolean bl, boolean bl2, boolean bl3) {
        int n = molodenskyTransform.type & 4;
        if (bl) {
            n |= 8;
        }
        if (bl2) {
            n |= 2;
        }
        if (bl3) {
            n |= 1;
        }
        this.type = n;
        this.dx = molodenskyTransform.dx;
        this.dy = molodenskyTransform.dy;
        this.dz = molodenskyTransform.dz;
        this.da = molodenskyTransform.da;
        this.db = molodenskyTransform.db;
        this.df = molodenskyTransform.df;
        this.a = molodenskyTransform.a;
        this.b = molodenskyTransform.b;
        this.a_b = molodenskyTransform.a_b;
        this.b_a = molodenskyTransform.b_a;
        this.daa = molodenskyTransform.daa;
        this.da_a = molodenskyTransform.da_a;
        this.e2 = molodenskyTransform.e2;
        this.adf = molodenskyTransform.adf;
    }

    MolodenskyTransform(MolodenskyTransform molodenskyTransform, int n) {
        this.type = n;
        this.dx = -molodenskyTransform.dx;
        this.dy = -molodenskyTransform.dy;
        this.dz = -molodenskyTransform.dz;
        this.da = -molodenskyTransform.da;
        this.db = -molodenskyTransform.db;
        this.df = -molodenskyTransform.df;
        this.a = molodenskyTransform.a + molodenskyTransform.da;
        this.b = molodenskyTransform.b + molodenskyTransform.db;
        this.a_b = this.a / this.b;
        this.b_a = this.b / this.a;
        this.daa = this.da * this.a;
        this.da_a = this.da / this.a;
        this.e2 = 1.0 - this.b * this.b / (this.a * this.a);
        this.adf = this.a * this.df + (this.a - this.b) * (this.da / this.a);
    }

    public static MathTransform create(boolean bl, double d, double d2, boolean bl2, double d3, double d4, boolean bl3, double d5, double d6, double d7) {
        MathTransform mathTransform;
        if (d5 == 0.0 && d6 == 0.0 && d7 == 0.0 && d == d3 && d2 == d4) {
            if (bl2 == bl3) {
                mathTransform = ProjectiveTransform.identity(bl3 ? 3 : 2);
            } else {
                XMatrix xMatrix = Matrices.createDimensionFilter(3, new int[]{0, 1});
                if (bl3) {
                    xMatrix.transpose();
                }
                mathTransform = ProjectiveTransform.create(xMatrix);
            }
        } else {
            mathTransform = !bl2 && !bl3 ? new MolodenskyTransform2D(bl, d, d2, d3, d4, d5, d6, d7) : new MolodenskyTransform(bl, d, d2, bl2, d3, d4, bl3, d5, d6, d7);
        }
        return mathTransform;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.isAbridged() ? AbridgedMolodensky.PARAMETERS : Molodensky.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameter<Integer> parameter = new Parameter<Integer>(Molodensky.DIM);
        parameter.setValue(this.getSourceDimensions());
        return new ParameterGroup(this.getParameterDescriptors(), parameter, new FloatParameter(Molodensky.DX, this.dx), new FloatParameter(Molodensky.DY, this.dy), new FloatParameter(Molodensky.DZ, this.dz), new FloatParameter(Molodensky.SRC_SEMI_MAJOR, this.a), new FloatParameter(Molodensky.SRC_SEMI_MINOR, this.b), new FloatParameter(Molodensky.TGT_SEMI_MAJOR, this.a + this.da), new FloatParameter(Molodensky.TGT_SEMI_MINOR, this.b + this.db));
    }

    private synchronized MolodenskyTransform[] variants() {
        if (this.variants == null) {
            this.variants = new MolodenskyTransform[8];
            this.variants[this.type & 7] = this;
        }
        return this.variants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MolodenskyTransform forDimensions(boolean bl, boolean bl2) {
        MolodenskyTransform[] molodenskyTransformArray = this.variants();
        boolean bl3 = this.isAbridged();
        int n = this.type & 4;
        if (bl) {
            n |= 2;
        }
        if (bl2) {
            n |= 1;
        }
        MolodenskyTransform[] molodenskyTransformArray2 = molodenskyTransformArray;
        synchronized (molodenskyTransformArray) {
            MolodenskyTransform molodenskyTransform = molodenskyTransformArray[n];
            if (molodenskyTransform == null) {
                molodenskyTransform = (n & 3) == 0 ? new MolodenskyTransform2D(this, bl3) : new MolodenskyTransform(this, bl3, bl, bl2);
                molodenskyTransform.variants = molodenskyTransformArray;
                molodenskyTransformArray[n] = molodenskyTransform;
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return molodenskyTransform;
        }
    }

    @Override
    public final int getSourceDimensions() {
        return (this.type & 2) != 0 ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return (this.type & 1) != 0 ? 3 : 2;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        Matrix matrix = null;
        if (bl) {
            boolean bl2 = (this.type & 2) != 0;
            matrix = this.derivative(Math.toRadians(dArray[n]), Math.toRadians(dArray[n + 1]), bl2 ? dArray[n + 2] : 0.0);
        }
        if (dArray2 != null) {
            this.transform(null, dArray, n, null, dArray2, n2, 1, dArray == dArray2);
        }
        return matrix;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(null, dArray, n, null, dArray2, n2, n3, dArray == dArray2);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        this.transform(fArray, null, n, fArray2, null, n2, n3, fArray == fArray2);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        this.transform(null, dArray, n, fArray, null, n2, n3, false);
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        this.transform(fArray, null, n, null, dArray, n2, n3, false);
    }

    private void transform(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3, boolean bl) {
        int n4;
        boolean bl2 = (this.type & 8) != 0;
        boolean bl3 = (this.type & 2) != 0;
        boolean bl4 = (this.type & 1) != 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Object[] objectArray = null;
        if (bl) {
            int n8 = this.getSourceDimensions();
            n4 = this.getTargetDimensions();
            switch (IterationStrategy.suggest(n, n8, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n8;
                    n2 += (n3 - 1) * n4;
                    n5 = 2 * n8;
                    n6 = 2 * n4;
                    break;
                }
                default: {
                    int n9 = n + n3 * n8;
                    if (dArray != null) {
                        dArray = Arrays.copyOfRange(dArray, n, n9);
                    } else {
                        fArray = Arrays.copyOfRange(fArray, n, n9);
                    }
                    n = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    if (dArray2 != null) {
                        objectArray = dArray2;
                        dArray2 = new double[n3 * n4];
                    } else {
                        objectArray = fArray2;
                        fArray2 = new float[n3 * n4];
                    }
                    n7 = n2;
                    n2 = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d;
            double d2;
            double d3;
            if (dArray != null) {
                d3 = dArray[n++];
                d2 = dArray[n++];
                d = bl3 ? dArray[n++] : 0.0;
            } else {
                d3 = fArray[n++];
                d2 = fArray[n++];
                d = bl3 ? (double)fArray[n++] : 0.0;
            }
            d3 = Math.toRadians(d3);
            d2 = Math.toRadians(d2);
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = Math.sin(d2);
            double d7 = Math.cos(d2);
            double d8 = d6 * d6;
            double d9 = this.dy * d5 - this.dx * d4;
            double d10 = this.a / Math.sqrt(1.0 - this.e2 * d8);
            double d11 = d10 * (1.0 - this.e2) / (1.0 - this.e2 * d8);
            double d12 = this.dz * d7 - d6 * (this.dy * d4 + this.dx * d5);
            if (bl2) {
                d2 += 1.0000000000039173 * ((d12 + this.adf * Math.sin(2.0 * d2)) / d11);
                d3 += 1.0000000000039173 * (d9 / (d10 * d7));
            } else {
                d2 += 1.0000000000039173 * ((d12 + this.da_a * (d10 * this.e2 * d6 * d7) + this.df * (d11 * this.a_b + d10 * this.b_a) * d6 * d7) / (d11 + d));
                d3 += 1.0000000000039173 * (d9 / ((d10 + d) * d7));
            }
            if (Math.abs(d2) >= 1.5707963267948966) {
                d3 = 0.0;
                d2 = Math.copySign(90.0, d2);
            } else {
                d3 = MolodenskyTransform.rollLongitude(Math.toDegrees(d3), 180.0);
                d2 = Math.toDegrees(d2);
            }
            if (dArray2 != null) {
                dArray2[n2++] = d3;
                dArray2[n2++] = d2;
            } else {
                fArray2[n2++] = (float)d3;
                fArray2[n2++] = (float)d2;
            }
            if (bl4) {
                d = bl2 ? (d += this.dx * d7 * d5 + this.dy * d7 * d4 + this.dz * d6 + this.adf * d8 - this.da) : (d += this.dx * d7 * d5 + this.dy * d7 * d4 + this.dz * d6 + this.df * this.b_a * d10 * d8 - this.daa / d10);
                if (dArray2 != null) {
                    dArray2[n2++] = d;
                } else {
                    fArray2[n2++] = (float)d;
                }
            }
            n -= n5;
            n2 -= n6;
        }
        if (objectArray != null) {
            Object[] objectArray2;
            if (dArray2 != null) {
                objectArray2 = dArray2;
                n4 = dArray2.length;
            } else {
                objectArray2 = fArray2;
                n4 = fArray2.length;
            }
            System.arraycopy(objectArray2, 0, objectArray, n7, n4);
        }
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        boolean bl = (this.type & 2) != 0;
        ArgumentChecks.ensureDimensionMatches("point", directPosition, bl ? 3 : 2);
        return this.derivative(Math.toRadians(directPosition.getOrdinate(0)), Math.toRadians(directPosition.getOrdinate(1)), bl ? directPosition.getOrdinate(2) : 0.0);
    }

    @Override
    public Matrix derivative(Point2D point2D) {
        return this.derivative(point2D.getX(), point2D.getY(), 0.0);
    }

    private Matrix derivative(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = Math.cos(d);
        double d9 = Math.sin(d);
        double d10 = Math.cos(d2);
        double d11 = Math.sin(d2);
        double d12 = d11 / d10;
        double d13 = d11 * d10;
        double d14 = d11 * d11;
        double d15 = this.dy * d9 + this.dx * d8;
        double d16 = this.dy * d8 - this.dx * d9;
        double d17 = 1.0 - this.e2 * d14;
        double d18 = this.a / Math.sqrt(d17);
        double d19 = this.e2 * d13 / d17;
        double d20 = (1.0 - this.e2) / d17;
        double d21 = 3.0 * d20 * d19;
        int n = this.getSourceDimensions();
        int n2 = this.getTargetDimensions();
        XMatrix xMatrix = Matrices.create(n2, n);
        if (this.isAbridged()) {
            double d22 = 1.0000000000039173 / (d18 * d20);
            double d23 = 1.0000000000039173 / (d18 * d10);
            d7 = d23 * d15;
            d6 = d23 * d16 * (d12 - d19);
            d5 = -d22 * (d16 * d11);
            d4 = d22 * (d15 * (d11 * d21 - d10) - this.dz * (d10 * d21 + d11) + 2.0 * this.adf * (1.0 - d13 * d21 - 2.0 * d14));
            if (n2 == 3) {
                double d24 = d10 * d16;
                double d25 = d10 * (this.dz + 2.0 * this.adf * d11) - d11 * d15;
                xMatrix.setElement(2, 0, Math.toRadians(d24));
                xMatrix.setElement(2, 1, Math.toRadians(d25));
            }
        } else {
            double d26;
            double d27;
            double d28 = d3 + d18;
            double d29 = d3 + d20 * d18;
            double d30 = 1.0000000000039173 / d29;
            double d31 = 1.0000000000039173 / (d28 * d10);
            double d32 = d21 * d18 / d29;
            double d33 = d20 * this.a_b + this.b_a;
            double d34 = this.e2 * this.da_a / this.df;
            double d35 = this.df * (d34 + d33) * d18;
            d7 = d31 * d15;
            d6 = d31 * d16 * (d12 - d19 * d18 / d28);
            d5 = -d30 * d16 * d11;
            d4 = d30 * (d15 * (d32 * d11 - d10) - this.dz * (d32 * d10 + d11) + d35 * (1.0 - 2.0 * d14) + this.df * d18 * d13 * (d19 * (2.0 * this.a_b + d33 + d34) + d34 - d32 * d33));
            if (n == 3) {
                d27 = -d31 * d16 / d28;
                d26 = d30 * (d15 * d11 - this.dz * d10 - d35 * d13) / d29;
                xMatrix.setElement(0, 2, d27);
                xMatrix.setElement(1, 2, d26);
            }
            if (n2 == 3) {
                d27 = d10 * d16;
                d26 = d11 * (this.df * d18 * this.b_a * (d19 * d11 + 2.0 * d10) - d15) + this.dz * d10 + this.daa * d19 / d18;
                xMatrix.setElement(2, 0, Math.toRadians(d27));
                xMatrix.setElement(2, 1, Math.toRadians(d26));
            }
        }
        xMatrix.setElement(0, 0, 1.0 - d7);
        xMatrix.setElement(1, 1, 1.0 + d4);
        xMatrix.setElement(0, 1, d6);
        xMatrix.setElement(1, 0, d5);
        return xMatrix;
    }

    public final boolean isAbridged() {
        return (this.type & 8) != 0;
    }

    @Override
    public boolean isIdentity() {
        return this.dx == 0.0 && this.dy == 0.0 && this.dz == 0.0 && this.da == 0.0 && this.db == 0.0 && this.getSourceDimensions() == this.getTargetDimensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform inverse() {
        MolodenskyTransform[] molodenskyTransformArray;
        int n = this.type;
        n = (n >>> 1 ^ n) & 1;
        n |= n << 1 | 4;
        int n2 = (n ^= this.type) & 7;
        MolodenskyTransform[] molodenskyTransformArray2 = molodenskyTransformArray = this.variants();
        synchronized (molodenskyTransformArray) {
            MolodenskyTransform molodenskyTransform = molodenskyTransformArray[n2];
            if (molodenskyTransform == null) {
                molodenskyTransform = (n2 & 3) == 0 ? new MolodenskyTransform2D(this, n) : new MolodenskyTransform(this, n);
                molodenskyTransform.variants = molodenskyTransformArray;
                molodenskyTransformArray[n2] = molodenskyTransform;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return molodenskyTransform;
        }
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.dx, Utilities.hash(this.dy, Utilities.hash(this.dz, Utilities.hash(this.a, Utilities.hash(this.b, Utilities.hash(this.da, Utilities.hash(this.db, this.type)))))));
    }

    @Override
    public final boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            MolodenskyTransform molodenskyTransform = (MolodenskyTransform)object;
            return this.type == molodenskyTransform.type && Utilities.equals(this.dx, molodenskyTransform.dx) && Utilities.equals(this.dy, molodenskyTransform.dy) && Utilities.equals(this.dz, molodenskyTransform.dz) && Utilities.equals(this.a, molodenskyTransform.a) && Utilities.equals(this.b, molodenskyTransform.b) && Utilities.equals(this.da, molodenskyTransform.da) && Utilities.equals(this.db, molodenskyTransform.db);
        }
        return false;
    }
}

