/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.geotoolkit.temporal.object.DefaultJulianDate;
import org.geotoolkit.temporal.object.TemporalUtilities;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.DateAndTime;
import org.opengis.temporal.JulianDate;
import org.opengis.temporal.OrdinalPosition;
import org.opengis.temporal.Position;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalPosition;
import org.opengis.util.InternationalString;

public class DefaultPosition
implements Position {
    private final Object position;

    public DefaultPosition() {
        this.position = null;
    }

    public DefaultPosition(Date date) {
        this.position = date;
    }

    public DefaultPosition(InternationalString datetime) throws ParseException {
        this.position = TemporalUtilities.getDateFromString(((Object)datetime).toString());
    }

    public DefaultPosition(TemporalPosition anyOther) {
        this.position = anyOther;
    }

    @Override
    public TemporalPosition anyOther() {
        return this.position instanceof TemporalPosition ? (TemporalPosition)this.position : null;
    }

    @Override
    public Date getDate() {
        if (this.position instanceof Date) {
            return (Date)this.position;
        }
        if (this.position instanceof TemporalPosition) {
            if (this.position instanceof JulianDate) {
                return TemporalUtilities.julianToDate((DefaultJulianDate)this.position);
            }
            if (this.position instanceof DateAndTime) {
                return TemporalUtilities.dateAndTimeToDate((DateAndTime)this.position);
            }
            if (this.position instanceof CalendarDate) {
                return TemporalUtilities.calendarDateToDate((CalendarDate)this.position);
            }
            if (this.position instanceof TemporalCoordinate) {
                return TemporalUtilities.temporalCoordToDate((TemporalCoordinate)this.position);
            }
            if (this.position instanceof OrdinalPosition) {
                return TemporalUtilities.ordinalToDate((OrdinalPosition)this.position);
            }
        }
        return null;
    }

    @Override
    public Time getTime() {
        return this.position instanceof Time ? (Time)this.position : null;
    }

    @Override
    public InternationalString getDateTime() {
        if (this.position instanceof Date) {
            String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            return new SimpleInternationalString(dateFormat.format(this.position));
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultPosition) {
            DefaultPosition that = (DefaultPosition)object;
            return Utilities.equals(this.position, that.position);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.position != null ? this.position.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("Position:").append('\n');
        if (this.position != null) {
            s2.append("position:").append(this.position).append('\n');
        }
        return s2.toString();
    }
}

