/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.LenientComparable;

public final class Utilities
extends Static {
    private static final int PRIME_NUMBER = 31;

    private Utilities() {
    }

    public static boolean equals(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean equals(char c, char c2) {
        return c == c2;
    }

    public static boolean equals(byte by, byte by2) {
        return by == by2;
    }

    public static boolean equals(short s2, short s3) {
        return s2 == s3;
    }

    public static boolean equals(int n, int n2) {
        return n == n2;
    }

    public static boolean equals(long l, long l2) {
        return l == l2;
    }

    public static boolean equals(float f, float f2) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean equals(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean equals(Object object, Object object2) throws AssertionError {
        assert (object == null || !object.getClass().isArray()) : Utilities.name(object);
        assert (object2 == null || !object2.getClass().isArray()) : Utilities.name(object2);
        return object == object2 || object != null && object.equals(object2);
    }

    public static boolean deepEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof Object[]) {
            return object2 instanceof Object[] && Arrays.deepEquals((Object[])object, (Object[])object2);
        }
        if (object instanceof double[]) {
            return object2 instanceof double[] && Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[]) {
            return object2 instanceof float[] && Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof long[]) {
            return object2 instanceof long[] && Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof int[]) {
            return object2 instanceof int[] && Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof short[]) {
            return object2 instanceof short[] && Arrays.equals((short[])object, (short[])object2);
        }
        if (object instanceof byte[]) {
            return object2 instanceof byte[] && Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[]) {
            return object2 instanceof char[] && Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof boolean[]) {
            return object2 instanceof boolean[] && Arrays.equals((boolean[])object, (boolean[])object2);
        }
        return object.equals(object2);
    }

    public static boolean deepEquals(Object object, Object object2, ComparisonMode comparisonMode) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            assert (Utilities.isNotDebug(comparisonMode)) : "object" + (object == null ? (char)'1' : '2') + " is null";
            return false;
        }
        if (object instanceof LenientComparable) {
            return ((LenientComparable)object).equals(object2, comparisonMode);
        }
        if (object2 instanceof LenientComparable) {
            return ((LenientComparable)object2).equals(object, comparisonMode);
        }
        if (object instanceof Map.Entry) {
            if (object2 instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return Utilities.deepEquals(entry.getKey(), entry2.getKey(), comparisonMode) && Utilities.deepEquals(entry.getValue(), entry2.getValue(), comparisonMode);
            }
            assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedType(Map.Entry.class, object2);
            return false;
        }
        if (object instanceof Map) {
            if (object2 instanceof Map) {
                return Utilities.equals(((Map)object).entrySet(), ((Map)object2).entrySet(), comparisonMode);
            }
            assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedType(Map.class, object2);
            return false;
        }
        if (object instanceof Collection) {
            if (object2 instanceof Collection) {
                return Utilities.equals((Collection)object, (Collection)object2, comparisonMode);
            }
            assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedType(Collection.class, object2);
            return false;
        }
        if (object instanceof Object[]) {
            if (!(object2 instanceof Object[])) {
                assert (Utilities.isNotDebug(comparisonMode)) : Utilities.mismatchedType(Object[].class, object2);
                return false;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray instanceof LenientComparable[]) {
                return Utilities.equals((LenientComparable[])objectArray, objectArray2, comparisonMode);
            }
            if (objectArray2 instanceof LenientComparable[]) {
                return Utilities.equals((LenientComparable[])objectArray2, objectArray, comparisonMode);
            }
            int n = objectArray.length;
            if (objectArray2.length != n) {
                assert (Utilities.isNotDebug(comparisonMode)) : "Length " + n + " != " + objectArray2.length;
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Utilities.deepEquals(objectArray[i], objectArray2[i], comparisonMode)) continue;
                assert (Utilities.isNotDebug(comparisonMode)) : "object[" + i + "] not equal";
                return false;
            }
            return true;
        }
        return Utilities.deepEquals(object, object2);
    }

    private static boolean equals(LenientComparable[] lenientComparableArray, Object[] objectArray, ComparisonMode comparisonMode) {
        int n = lenientComparableArray.length;
        if (objectArray.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            LenientComparable lenientComparable = lenientComparableArray[i];
            Object object = objectArray[i];
            if (lenientComparable == object || lenientComparable != null && lenientComparable.equals(object, comparisonMode)) continue;
            assert (Utilities.isNotDebug(comparisonMode)) : "object[" + i + "] not equal";
            return false;
        }
        return true;
    }

    private static boolean equals(Iterable<?> iterable, Iterable<?> iterable2, ComparisonMode comparisonMode) {
        Iterator<?> iterator = iterable.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                assert (Utilities.isNotDebug(comparisonMode)) : "Sizes not equal";
                return false;
            }
            Object obj2 = iterator.next();
            if (Utilities.deepEquals(obj2, obj = iterator2.next(), comparisonMode)) continue;
            if (!(iterable instanceof Set) || !(iterable2 instanceof Set)) {
                assert (Utilities.isNotDebug(comparisonMode)) : "Lists not equal";
                return false;
            }
            LinkedList linkedList = new LinkedList();
            linkedList.add(obj2);
            while (iterator.hasNext()) {
                linkedList.add(iterator.next());
            }
            while (true) {
                Iterator iterator3 = linkedList.iterator();
                do {
                    if (iterator3.hasNext()) continue;
                    assert (Utilities.isNotDebug(comparisonMode)) : "Sets not equal";
                    return false;
                } while (!Utilities.deepEquals(iterator3.next(), obj, comparisonMode));
                iterator3.remove();
                if (!iterator2.hasNext()) break;
                obj = iterator2.next();
            }
            return linkedList.isEmpty();
        }
        return !iterator2.hasNext();
    }

    private static boolean isNotDebug(ComparisonMode comparisonMode) {
        return comparisonMode != ComparisonMode.DEBUG;
    }

    private static String mismatchedType(Class<?> clazz, Object object) {
        return "Expected " + clazz + " but got " + object.getClass();
    }

    public static int hash(boolean bl, int n) {
        return n * 31 + (bl ? 1231 : 1237);
    }

    public static int hash(char c, int n) {
        return n * 31 + c;
    }

    public static int hash(int n, int n2) {
        return n2 * 31 + n;
    }

    public static int hash(long l, int n) {
        return n * 31 + ((int)l ^ (int)(l >>> 32));
    }

    public static int hash(float f, int n) {
        return n * 31 + Float.floatToIntBits(f);
    }

    public static int hash(double d, int n) {
        return Utilities.hash(Double.doubleToLongBits(d), n);
    }

    public static int hash(Object object, int n) throws AssertionError {
        n *= 31;
        if (object != null) {
            assert (!object.getClass().isArray()) : Utilities.name(object);
            n += object.hashCode();
        }
        return n;
    }

    public static int deepHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return Arrays.deepHashCode((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        return object.hashCode();
    }

    public static String deepToString(Object object) {
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        return String.valueOf(object);
    }

    private static String name(Object object) {
        return object.getClass().getSimpleName();
    }
}

