/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.DateRange;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Range;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.CheckedCollection;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.ConverterRegistry;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.Numbers;
import org.geotoolkit.util.converter.ObjectConverter;

public class RangeSet<T extends Comparable<? super T>>
extends AbstractSet<Range<T>>
implements CheckedCollection<Range<T>>,
SortedSet<Range<T>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6085227672036239981L;
    private static final Comparator<Range<?>> COMPARATOR = new Comparator<Range<?>>(){

        @Override
        public int compare(Range range, Range range2) {
            int n = range.getMinValue().compareTo(range2.getMinValue());
            int n2 = range.getMaxValue().compareTo(range2.getMaxValue());
            if (n == 0) {
                n = (range.isMinIncluded() ? -1 : 0) - (range2.isMinIncluded() ? -1 : 0);
            }
            if (n2 == 0) {
                n2 = (range.isMaxIncluded() ? 1 : 0) - (range2.isMaxIncluded() ? 1 : 0);
            }
            if (n == n2) {
                return n2;
            }
            if (n == 0) {
                return n2;
            }
            if (n2 == 0) {
                return n;
            }
            throw new IllegalArgumentException("Unordered ranges");
        }
    };
    private final Class<T> elementClass;
    private transient Class<?> arrayElementClass;
    private transient byte arrayElementCode;
    private transient boolean isNumeric;
    private transient boolean isDate;
    private transient ObjectConverter<T, Number> converter;
    private transient ObjectConverter<? extends Number, T> inverseConverter;
    private Object array;
    private transient int length;
    private transient int modCount;

    public RangeSet(Class<T> clazz) {
        if (!Comparable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Errors.format(146, clazz));
        }
        this.elementClass = clazz;
        this.initialize();
    }

    private void initialize() {
        Class<Object> clazz = this.elementClass;
        this.isDate = Date.class.isAssignableFrom(clazz);
        this.isNumeric = Number.class.isAssignableFrom(clazz);
        if (!this.isNumeric) {
            try {
                ObjectConverter<Number, T> objectConverter;
                ConverterRegistry converterRegistry = ConverterRegistry.system();
                ObjectConverter<Number, Number> objectConverter2 = converterRegistry.converter(this.elementClass, Number.class);
                if (RangeSet.isAcceptable(objectConverter2) && RangeSet.isAcceptable(objectConverter = converterRegistry.converter(objectConverter2.getTargetClass(), this.elementClass))) {
                    this.converter = objectConverter2;
                    this.inverseConverter = objectConverter;
                    clazz = objectConverter2.getTargetClass();
                }
            }
            catch (NonconvertibleObjectException nonconvertibleObjectException) {
                // empty catch block
            }
        }
        this.arrayElementClass = Numbers.wrapperToPrimitive(clazz);
        this.arrayElementCode = Numbers.getEnumConstant(this.arrayElementClass);
    }

    private static boolean isAcceptable(ObjectConverter<?, ?> objectConverter) {
        return !objectConverter.hasRestrictions() && (objectConverter.isOrderPreserving() || objectConverter.isOrderReversing());
    }

    @Override
    public Class<? extends Range<T>> getElementType() {
        if (this.isNumeric) {
            return NumberRange.class;
        }
        if (this.isDate) {
            return DateRange.class;
        }
        return Range.class;
    }

    final Class<?> getArrayElementType() {
        return this.arrayElementClass;
    }

    private Comparable<?> toArrayElement(Comparable<?> comparable, String string) throws IllegalArgumentException {
        if (comparable == null) {
            throw new NullArgumentException(Errors.format(172, string));
        }
        ArgumentChecks.ensureCanCast("value", this.isNumeric ? Number.class : this.elementClass, comparable);
        if (this.converter == null) {
            return comparable;
        }
        try {
            Comparable comparable2 = (Comparable)((Object)this.converter.convert(comparable));
            return comparable2;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(Errors.format(76, comparable.getClass(), this.elementClass), classCastException);
        }
        catch (NonconvertibleObjectException nonconvertibleObjectException) {
            throw new IllegalArgumentException(Errors.format(73, string, comparable), nonconvertibleObjectException);
        }
    }

    private static int compare(Comparable<?> comparable, Comparable<?> comparable2) {
        return comparable.compareTo(comparable2);
    }

    @Override
    public Comparator<Range<T>> comparator() {
        return COMPARATOR;
    }

    @Override
    public void clear() {
        if (this.array instanceof Object[]) {
            Arrays.fill((Object[])this.array, 0, this.length, null);
        }
        this.length = 0;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.length / 2;
    }

    private void insertAt(int n, Comparable<?> comparable, Comparable<?> comparable2) {
        Object object = this.array;
        int n2 = Array.getLength(this.array);
        if (this.length + 2 > n2) {
            this.array = Array.newInstance(this.arrayElementClass, 2 * Math.max(n2, 8));
            System.arraycopy(object, 0, this.array, 0, n);
        }
        System.arraycopy(object, n, this.array, n + 2, this.length - n);
        Array.set(this.array, n + 0, comparable);
        Array.set(this.array, n + 1, comparable2);
        this.length += 2;
    }

    private void removeAt(int n, int n2) {
        int n3 = this.length;
        System.arraycopy(this.array, n2, this.array, n, n3 - n2);
        this.length -= n2 - n;
        if (this.array instanceof Object[]) {
            Arrays.fill((Object[])this.array, this.length, n3, null);
        }
    }

    @Override
    public boolean add(Range<T> range) {
        if (!range.isMinIncluded() || !range.isMaxIncluded()) {
            throw new UnsupportedOperationException("Open interval not yet supported");
        }
        return this.addRange((Comparable<?>)range.getMinValue(), (Comparable<?>)range.getMaxValue());
    }

    public boolean add(T t, T t2) throws IllegalArgumentException {
        return this.addRange((Comparable<?>)t, (Comparable<?>)t2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addRange(Comparable<?> comparable, Comparable<?> comparable2) throws IllegalArgumentException {
        int n;
        int n2;
        int n3;
        int n4;
        Comparable comparable3;
        Comparable comparable4;
        block16: {
            block18: {
                comparable4 = this.toArrayElement(comparable, "min");
                if (RangeSet.compare(comparable4, comparable3 = this.toArrayElement(comparable2, "max")) > 0) {
                    throw new IllegalArgumentException(Errors.format(14, comparable, comparable2));
                }
                if (this.array == null) {
                    ++this.modCount;
                    this.array = Array.newInstance(this.arrayElementClass, 32);
                    Array.set(this.array, 0, comparable4);
                    Array.set(this.array, 1, comparable3);
                    this.length = 2;
                    return true;
                }
                n4 = this.modCount++;
                n3 = this.binarySearch(comparable4);
                if (n3 >= 0) break block18;
                if (((n3 ^= 0xFFFFFFFF) & 1) != 0) {
                    comparable4 = (Comparable)Array.get(this.array, --n3);
                    n2 = this.binarySearch(comparable3);
                    break block16;
                } else if (n3 != this.length && (n2 = this.binarySearch(comparable3)) != ~n3) {
                    Array.set(this.array, n3, comparable4);
                    break block16;
                } else {
                    this.insertAt(n3, comparable4, comparable3);
                    return true;
                }
            }
            n3 &= 0xFFFFFFFE;
            n2 = this.binarySearch(comparable3);
        }
        if (n2 < 0) {
            if (((n2 ^= 0xFFFFFFFF) & 1) != 0) {
                comparable3 = (Comparable)Array.get(this.array, n2);
            } else {
                ++this.modCount;
                Array.set(this.array, --n2, comparable3);
            }
        } else {
            n2 |= 1;
        }
        assert (RangeSet.compare(comparable4, comparable3) <= 0);
        assert ((n3 & 1) == 0) : n3;
        assert ((n2 & 1) != 0) : n2;
        if ((n = n2 - ++n3) > 0) {
            ++this.modCount;
            this.removeAt(n3, n2);
        }
        if (!$assertionsDisabled) {
            if (Array.getLength(this.array) < this.length) throw new AssertionError(this.length);
            if ((this.length & 1) != 0) {
                throw new AssertionError(this.length);
            }
        }
        if (n4 == this.modCount) return false;
        return true;
    }

    public boolean add(byte by, byte by2) throws IllegalArgumentException {
        return this.addRange(Byte.valueOf(by), Byte.valueOf(by2));
    }

    public boolean add(short s2, short s3) throws IllegalArgumentException {
        return this.addRange(Short.valueOf(s2), Short.valueOf(s3));
    }

    public boolean add(int n, int n2) throws IllegalArgumentException {
        return this.addRange(Integer.valueOf(n), Integer.valueOf(n2));
    }

    public boolean add(long l, long l2) throws IllegalArgumentException {
        return this.addRange(Long.valueOf(l), Long.valueOf(l2));
    }

    public boolean add(float f, float f2) throws IllegalArgumentException {
        return this.addRange(Float.valueOf(f), Float.valueOf(f2));
    }

    public boolean add(double d, double d2) throws IllegalArgumentException {
        return this.addRange(Double.valueOf(d), Double.valueOf(d2));
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (range.isMinIncluded() || range.isMaxIncluded()) {
            throw new UnsupportedOperationException("Closed interval not yet supported");
        }
        return this.removeRange((Comparable<?>)range.getMinValue(), (Comparable<?>)range.getMaxValue());
    }

    public boolean remove(T t, T t2) throws IllegalArgumentException {
        return this.removeRange((Comparable<?>)t, (Comparable<?>)t2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean removeRange(Comparable<?> comparable, Comparable<?> comparable2) throws IllegalArgumentException {
        int n;
        Comparable<?> comparable3;
        Comparable<?> comparable4 = this.toArrayElement(comparable, "min");
        if (RangeSet.compare(comparable4, comparable3 = this.toArrayElement(comparable2, "max")) >= 0) {
            throw new IllegalArgumentException(Errors.format(14, comparable, comparable2));
        }
        if (this.length == 0) {
            return false;
        }
        int n2 = this.modCount++;
        int n3 = this.binarySearch(comparable4);
        int n4 = this.binarySearch(comparable3);
        if (n3 < 0) {
            if (((n3 ^= 0xFFFFFFFF) & 1) != 0) {
                if (n4 == ~n3) {
                    this.insertAt(n3, comparable4, comparable3);
                    return true;
                }
                Array.set(this.array, n3, comparable4);
            } else {
                --n3;
            }
        } else if ((n3 & 1) == 0) {
            --n3;
        }
        if (n4 < 0) {
            if (((n4 ^= 0xFFFFFFFF) & 1) != 0) {
                ++this.modCount;
                Array.set(this.array, --n4, comparable3);
            }
        } else {
            n4 &= 0xFFFFFFFE;
        }
        assert ((n3 & 1) != 0) : n3;
        assert ((n4 & 1) == 0) : n4;
        if ((n = n4 - ++n3) > 0) {
            ++this.modCount;
            this.removeAt(n3, n4);
        }
        if (!$assertionsDisabled) {
            if (Array.getLength(this.array) < this.length) throw new AssertionError();
            if ((this.length & 1) != 0) {
                throw new AssertionError();
            }
        }
        if (n2 == this.modCount) return false;
        return true;
    }

    public boolean remove(byte by, byte by2) throws IllegalArgumentException {
        return this.removeRange(Byte.valueOf(by), Byte.valueOf(by2));
    }

    public boolean remove(short s2, short s3) throws IllegalArgumentException {
        return this.removeRange(Short.valueOf(s2), Short.valueOf(s3));
    }

    public boolean remove(int n, int n2) throws IllegalArgumentException {
        return this.removeRange(Integer.valueOf(n), Integer.valueOf(n2));
    }

    public boolean remove(long l, long l2) throws IllegalArgumentException {
        return this.removeRange(Long.valueOf(l), Long.valueOf(l2));
    }

    public boolean remove(float f, float f2) throws IllegalArgumentException {
        return this.removeRange(Float.valueOf(f), Float.valueOf(f2));
    }

    public boolean remove(double d, double d2) throws IllegalArgumentException {
        return this.removeRange(Double.valueOf(d), Double.valueOf(d2));
    }

    private int binarySearch(Comparable<?> comparable) {
        switch (this.arrayElementCode) {
            case 8: {
                return Arrays.binarySearch((double[])this.array, 0, this.length, ((Number)((Object)comparable)).doubleValue());
            }
            case 7: {
                return Arrays.binarySearch((float[])this.array, 0, this.length, ((Number)((Object)comparable)).floatValue());
            }
            case 6: {
                return Arrays.binarySearch((long[])this.array, 0, this.length, ((Number)((Object)comparable)).longValue());
            }
            case 5: {
                return Arrays.binarySearch((int[])this.array, 0, this.length, ((Number)((Object)comparable)).intValue());
            }
            case 4: {
                return Arrays.binarySearch((short[])this.array, 0, this.length, ((Number)((Object)comparable)).shortValue());
            }
            case 3: {
                return Arrays.binarySearch((byte[])this.array, 0, this.length, ((Number)((Object)comparable)).byteValue());
            }
            case 2: {
                return Arrays.binarySearch((char[])this.array, 0, this.length, ((Character)comparable).charValue());
            }
        }
        return Arrays.binarySearch((Object[])this.array, 0, this.length, comparable);
    }

    private Range<T> newRange(T t, T t2) {
        if (this.isNumeric) {
            return new NumberRange<Number>(this.elementClass, (Number)t, (Number)t2);
        }
        if (this.isDate) {
            return new DateRange((Date)t, (Date)t2);
        }
        return new Range<T>(this.elementClass, t, t2);
    }

    private T get(int n) {
        assert (n >= 0 && n < this.length) : n;
        Object object = Array.get(this.array, n);
        ObjectConverter<Number, T> objectConverter = this.inverseConverter;
        if (objectConverter != null) {
            assert (objectConverter.getSourceClass().isInstance(object)) : object;
            try {
                return (T)((Comparable)objectConverter.convert((Number)object));
            }
            catch (NonconvertibleObjectException nonconvertibleObjectException) {
                throw new IllegalStateException(nonconvertibleObjectException);
            }
        }
        return (T)((Comparable)this.elementClass.cast(object));
    }

    public final double getMinValueAsDouble(int n) throws IndexOutOfBoundsException, ClassCastException {
        if ((n *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getDouble(this.array, n);
    }

    public final double getMaxValueAsDouble(int n) throws IndexOutOfBoundsException, ClassCastException {
        if ((n *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getDouble(this.array, n + 1);
    }

    public int indexOfRange(Comparable<?> comparable) {
        int n = this.binarySearch(this.toArrayElement(comparable, "value"));
        if (n < 0 && ((n ^= 0xFFFFFFFF) & 1) == 0) {
            return -1;
        }
        assert (this.newRange(this.get(2 * (n /= 2)), this.get(2 * n + 1)).contains(comparable)) : comparable;
        return n;
    }

    @Override
    public boolean contains(Object object) {
        int n;
        Range range = (Range)object;
        if (range.getElementType() == this.elementClass && range.isMinIncluded() && range.isMaxIncluded() && (n = this.binarySearch(this.toArrayElement((Comparable<?>)range.getMinValue(), "object"))) >= 0 && (n & 1) == 0) {
            int n2 = this.get(n + 1).compareTo(range.getMaxValue());
            return n2 == 0;
        }
        return false;
    }

    @Override
    public Range<T> first() throws NoSuchElementException {
        if (this.length != 0) {
            return this.newRange(this.get(0), this.get(1));
        }
        throw new NoSuchElementException();
    }

    @Override
    public Range<T> last() throws NoSuchElementException {
        if (this.length != 0) {
            return this.newRange(this.get(this.length - 2), this.get(this.length - 1));
        }
        throw new NoSuchElementException();
    }

    @Override
    public SortedSet<Range<T>> subSet(Range<T> range, Range<T> range2) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public SortedSet<Range<T>> headSet(Range<T> range) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public SortedSet<Range<T>> tailSet(Range<T> range) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public java.util.Iterator<Range<T>> iterator() {
        return new Iterator();
    }

    public final void trimToSize() {
        if (this.array != null && Array.getLength(this.array) != this.length) {
            this.copyArray();
        }
    }

    @Override
    public int hashCode() {
        int n = this.elementClass.hashCode();
        int n2 = this.length;
        while ((n2 -= 8) >= 0) {
            n = Utilities.hash(Array.get(this.array, n2), n);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            RangeSet rangeSet = (RangeSet)object;
            if (this.length == rangeSet.length && Utilities.equals(this.elementClass, rangeSet.elementClass)) {
                this.trimToSize();
                rangeSet.trimToSize();
                Object object2 = this.array;
                Object object3 = rangeSet.array;
                switch (this.arrayElementCode) {
                    case 8: {
                        return Arrays.equals((double[])object2, (double[])object3);
                    }
                    case 7: {
                        return Arrays.equals((float[])object2, (float[])object3);
                    }
                    case 6: {
                        return Arrays.equals((long[])object2, (long[])object3);
                    }
                    case 5: {
                        return Arrays.equals((int[])object2, (int[])object3);
                    }
                    case 4: {
                        return Arrays.equals((short[])object2, (short[])object3);
                    }
                    case 3: {
                        return Arrays.equals((byte[])object2, (byte[])object3);
                    }
                    case 2: {
                        return Arrays.equals((char[])object2, (char[])object3);
                    }
                }
                return Arrays.equals((Object[])object2, (Object[])object3);
            }
        }
        return false;
    }

    @Override
    public RangeSet<T> clone() {
        RangeSet rangeSet;
        try {
            rangeSet = (RangeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        rangeSet.copyArray();
        return rangeSet;
    }

    private void copyArray() {
        if (this.length == 0) {
            this.array = null;
        } else {
            switch (this.arrayElementCode) {
                case 8: {
                    this.array = Arrays.copyOf((double[])this.array, this.length);
                    break;
                }
                case 7: {
                    this.array = Arrays.copyOf((float[])this.array, this.length);
                    break;
                }
                case 6: {
                    this.array = Arrays.copyOf((long[])this.array, this.length);
                    break;
                }
                case 5: {
                    this.array = Arrays.copyOf((int[])this.array, this.length);
                    break;
                }
                case 4: {
                    this.array = Arrays.copyOf((short[])this.array, this.length);
                    break;
                }
                case 3: {
                    this.array = Arrays.copyOf((byte[])this.array, this.length);
                    break;
                }
                case 2: {
                    this.array = Arrays.copyOf((char[])this.array, this.length);
                    break;
                }
                default: {
                    this.array = Arrays.copyOf((Object[])this.array, this.length);
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(this));
        stringBuilder.append('[');
        boolean bl = true;
        for (Range<T> range : this) {
            if (!bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append('{').append(range.getMinValue()).append('\u2026').append(range.getMaxValue()).append('}');
            bl = false;
        }
        return stringBuilder.append(']').toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.trimToSize();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
        if (this.array != null) {
            this.length = Array.getLength(this.array);
        }
    }

    private final class Iterator
    implements java.util.Iterator<Range<T>> {
        private int modCount;
        private final int length;
        private int position;

        private Iterator() {
            this.modCount = RangeSet.this.modCount;
            this.length = RangeSet.this.length;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.length;
        }

        @Override
        public Range<T> next() {
            if (this.hasNext()) {
                Comparable comparable = RangeSet.this.get(this.position++);
                Comparable comparable2 = RangeSet.this.get(this.position++);
                if (RangeSet.this.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                return RangeSet.this.newRange(comparable, comparable2);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.position != 0) {
                if (RangeSet.this.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            RangeSet.this.removeAt(this.position - 2, this.position);
            this.modCount = ++RangeSet.this.modCount;
        }
    }
}

