/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class QueryFilterFixture
extends BaseFixture {
    protected DataSampler dataSampler;
    protected Map<QName, List<XSElementDeclaration>> temporalProperties;
    protected XSModel model;
    protected final String GET_FEATURE_MINIMAL = "GetFeature-Minimal";

    @BeforeClass
    public void initQueryFilterFixture(ITestContext testContext) {
        ISuite suite = testContext.getSuite();
        this.dataSampler = (DataSampler)suite.getAttribute(SuiteAttribute.SAMPLER.getName());
        this.model = (XSModel)suite.getAttribute(org.opengis.cite.iso19136.SuiteAttribute.XSMODEL.getName());
        this.temporalProperties = new HashMap<QName, List<XSElementDeclaration>>();
    }

    @BeforeMethod
    public void buildRequestEntity() {
        this.reqEntity = WFSMessage.createRequestEntity("GetFeature-Minimal", this.wfsVersion);
    }

    @BeforeMethod
    public void discardResponseEntity() {
        this.rspEntity = null;
    }

    protected List<XSElementDeclaration> findTemporalProperties(QName featureType) {
        List<XSElementDeclaration> tmProps = this.temporalProperties.get(featureType);
        if (tmProps != null) {
            return tmProps;
        }
        tmProps = AppSchemaUtils.getTemporalFeatureProperties(this.getModel(), featureType);
        this.temporalProperties.put(featureType, tmProps);
        TestSuiteLogger.log(Level.FINE, String.format("Temporal properties for feature type %s: %s", featureType, tmProps));
        return tmProps;
    }

    public XSModel getModel() {
        if (this.model == null) {
            Assert.fail("Test cannot be executed as no schema can be found; Please check if DescribeFeatureType returns a valid schema.");
        }
        return this.model;
    }
}

