/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.CassiniOrMercator;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class CassiniSoldner
extends CassiniOrMercator {
    private static final long serialVersionUID = 4710150547701615178L;
    private static final double C1 = 0.16666666666666666;
    private static final double C2 = 0.08333333333333333;
    private static final double C3 = 0.4166666666666667;
    private static final double C4 = 0.3333333333333333;
    private static final double C5 = 0.6666666666666666;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        CassiniSoldner cassiniSoldner = parameters.isSpherical() ? new Spherical(parameters) : new CassiniSoldner(parameters);
        return cassiniSoldner.createConcatenatedTransform();
    }

    protected CassiniSoldner(UnitaryProjection.Parameters parameters) {
        super(parameters);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = this.rollLongitude(dArray[n]);
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = d3 / d4;
        double d6 = d3 * d3;
        double d7 = d4 * d4;
        double d8 = d5 * d5;
        double d9 = d * d4;
        double d10 = d9 * d9;
        double d11 = 1.0 - this.excentricitySquared * d6;
        double d12 = Math.sqrt(d11);
        double d13 = d7 * this.excentricitySquared / (1.0 - this.excentricitySquared);
        if (dArray2 != null) {
            dArray2[n2] = d9 * (1.0 - d10 * d8 * (0.16666666666666666 - (8.0 - d8 + 8.0 * d13) * d10 * 0.08333333333333333)) / d12;
            dArray2[n2 + 1] = this.mlfn(d2, d3, d4) + d5 * d10 * (0.5 + (5.0 - d8 + 6.0 * d13) * d10 * 0.4166666666666667) / d12;
        }
        if (!bl) {
            return null;
        }
        double d14 = d3 * d4;
        double d15 = d * d * d6;
        double d16 = d * d * d7;
        double d17 = this.excentricitySquared / d11;
        double d18 = -0.08333333333333333 * (8.0 * (d13 + 1.0) - d8) * d16;
        double d19 = 0.4166666666666667 * (6.0 * d13 + 5.0 - d8) * d16 + 0.5;
        double d20 = (0.16666666666666666 + d18 * (1.0 - d8 * (1.0 - 0.08333333333333333 * d4 * (8.0 * d13 + 1.0 / d7)))) * d16;
        return new Matrix2(d4 / d12 * (1.0 - d15 * (5.0 * d18 + 0.5)), d * d3 / d12 * (1.0 - d15 * (d18 + 0.16666666666666666)) * (d17 * d7 - 2.0 * d20 - 1.0), d * d14 / d12 * (4.0 * d19 - 1.0), d16 / d12 * (d19 * (d17 * d6 - 2.0 * d8 + 1.0 / d7) - 0.4166666666666667 * d15 * (24.0 * d13 + 12.0)) + this.dmlfn_d\u03c6(d6, d7));
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = this.inv_mlfn(d2);
        double d4 = Math.tan(d3);
        double d5 = d4 * d4;
        double d6 = Math.sin(d3);
        double d7 = 1.0 / (1.0 - this.excentricitySquared * (d6 * d6));
        d6 = Math.sqrt(d7);
        double d8 = d / d6;
        double d9 = d8 * d8;
        dArray2[n2] = this.unrollLongitude(d8 * (1.0 + d5 * d9 * (-0.3333333333333333 + (1.0 + 3.0 * d5) * d9 * 0.6666666666666666)) / Math.cos(d3));
        dArray2[n2 + 1] = d3 - d6 * d4 / (d7 *= (1.0 - this.excentricitySquared) * d6) * d9 * (0.5 - (1.0 + 3.0 * d5) * d9 * 0.4166666666666667);
    }

    @Immutable
    static final class Spherical
    extends CassiniSoldner {
        private static final long serialVersionUID = 8808830539248891527L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            double d5 = Math.sin(d2);
            double d6 = Math.cos(d2);
            double d7 = d5 / d6;
            double d8 = Math.asin(d6 * d3);
            double d9 = Math.atan2(d7, d4);
            Matrix2 matrix2 = null;
            if (bl) {
                double d10 = Math.hypot(d4, d7);
                double d11 = d10 + d4;
                double d12 = (d11 * d11 + d7 * d7) * d6 / 2.0;
                double d13 = Math.sqrt(1.0 - d6 * d6 * (d3 * d3));
                matrix2 = new Matrix2(d4 * (d6 / d13), -d3 * (d5 / d13), d3 * (1.0 + d4 / d10) * (d5 / d12), (d11 - d7 * d7 / d10) / (d6 * d12));
            }
            assert (Assertions.checkDerivative(matrix2, super.transform(dArray, n, dArray2, n2, bl)) && Assertions.checkTransform(dArray2, n2, d8, d9, 1.0E-4));
            if (dArray2 != null) {
                dArray2[n2] = d8;
                dArray2[n2 + 1] = d9;
            }
            return matrix2;
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.asin(Math.sin(d2) * Math.cos(d));
            double d4 = this.unrollLongitude(Math.atan2(Math.tan(d), Math.cos(d2)));
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d4;
            dArray2[n2 + 1] = d3;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            if (Math.abs(d) < 0.08726646259971647 && Math.abs(d2) < 1.4835298641951802) {
                super.inverseTransform(dArray, n, dArray2, n2);
                return Assertions.checkInverseTransform(dArray2, n2, d, d2, 0.1);
            }
            return true;
        }
    }
}

