/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.geotoolkit.internal.sql.CreateStatementType;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.XArrays;

public enum Dialect {
    ANSI(null, null, null),
    DERBY("org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:", new String[]{"directory", "memory", "classpath", "jar"}){

        @Override
        public void shutdown(Connection connection, String string, boolean bl) throws SQLException {
            super.shutdown(connection, string, bl);
            int n = string.indexOf(59);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            string = string + ";shutdown=true";
            try {
                DriverManager.getConnection(string).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
    ,
    HSQL("org.hsqldb.jdbcDriver", "jdbc:hsqldb:", new String[]{"file", "mem"}){

        @Override
        public int maxRowsPerInsert(DatabaseMetaData databaseMetaData) {
            return 1;
        }

        @Override
        public boolean supportsCommitStatement(DatabaseMetaData databaseMetaData) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown(Connection connection, String string, boolean bl) throws SQLException {
            block15: {
                File file;
                if (connection == null) {
                    ArgumentChecks.ensureNonNull("databaseURL", string);
                    connection = DefaultDataSource.log(DriverManager.getConnection(string), Dialect.class);
                }
                Statement statement = connection.createStatement();
                try {
                    statement.execute(bl ? "SHUTDOWN COMPACT" : "SHUTDOWN");
                }
                finally {
                    statement.close();
                    connection.close();
                }
                if (bl && (file = this.getFile(string)) != null) {
                    try {
                        Properties properties;
                        File file2 = new File(file.getParentFile(), file.getName() + ".properties");
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        try {
                            properties = new Properties();
                            properties.load(fileInputStream);
                        }
                        finally {
                            ((InputStream)fileInputStream).close();
                        }
                        if ("true".equals(properties.put("readonly", "true"))) break block15;
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        try {
                            properties.store(fileOutputStream, "HSQL database configuration");
                        }
                        finally {
                            ((OutputStream)fileOutputStream).close();
                        }
                    }
                    catch (IOException iOException) {
                        throw new SQLNonTransientException(iOException);
                    }
                }
            }
        }
    }
    ,
    POSTGRESQL("org.postgresql.Driver", "jdbc:postgresql:", null){

        @Override
        public boolean supportsEnumType(DatabaseMetaData databaseMetaData) throws SQLException {
            int n = databaseMetaData.getDatabaseMajorVersion();
            return n == 8 ? databaseMetaData.getDatabaseMinorVersion() >= 4 : n >= 8;
        }

        @Override
        public boolean needsCreateLanguage(DatabaseMetaData databaseMetaData) throws SQLException {
            return databaseMetaData.getDatabaseMajorVersion() < 9;
        }

        @Override
        public boolean supportsGrantStatement(DatabaseMetaData databaseMetaData, CreateStatementType createStatementType) {
            return true;
        }
    }
    ,
    ORACLE("oracle.jdbc.driver.OracleDriver", "jdbc:oracle:", null),
    ACCESS(null, null, null);

    private static final Dialect[] SPECIFIC;
    public final String driverClass;
    public final String protocol;
    private final String[] subProtocols;

    private Dialect(String string2, String string3, String[] stringArray) {
        this.driverClass = string2;
        this.protocol = string3;
        this.subProtocols = stringArray;
    }

    public static Dialect guess(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = databaseMetaData.getDatabaseProductName();
        if (string != null) {
            string = string.trim().toUpperCase(Locale.US);
            for (Dialect dialect : SPECIFIC) {
                if (!string.contains(dialect.name())) continue;
                return dialect;
            }
        }
        return ANSI;
    }

    public static Dialect forURL(String string) {
        if (string != null) {
            for (Dialect dialect : SPECIFIC) {
                String string2 = dialect.protocol;
                if (string2 == null || !string.regionMatches(true, 0, string2, 0, string2.length())) continue;
                return dialect;
            }
        }
        return null;
    }

    public final String createURL(File file) throws SQLException {
        if (this.subProtocols == null) {
            throw new SQLException();
        }
        StringBuilder stringBuilder = new StringBuilder(this.protocol).append(this.subProtocols[0]).append(':');
        String string = file.getAbsolutePath().replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            stringBuilder.append('/');
        }
        return stringBuilder.append(string).toString();
    }

    public final File getFile(String string) {
        int n = this.protocol.length();
        if (string != null && string.regionMatches(true, 0, this.protocol, 0, n)) {
            int n2;
            if (this.subProtocols != null && (n2 = string.indexOf(58, n)) >= 0) {
                String string2 = string.substring(n, n2);
                for (int i = 0; i < this.subProtocols.length; ++i) {
                    if (!string2.equalsIgnoreCase(this.subProtocols[i])) continue;
                    if (i != 0) {
                        return null;
                    }
                    n = n2 + 1;
                }
            }
            return new File(string.substring(n));
        }
        return null;
    }

    public final boolean isDriverRegistered() {
        if (this.driverClass != null) {
            int n = this.driverClass.lastIndexOf(46) + 1;
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                Driver driver = enumeration.nextElement();
                if (!driver.getClass().getName().regionMatches(0, this.driverClass, 0, n)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsEnumType(DatabaseMetaData databaseMetaData) throws SQLException {
        return false;
    }

    public boolean supportsGrantStatement(DatabaseMetaData databaseMetaData, CreateStatementType createStatementType) throws SQLException {
        return false;
    }

    public boolean supportsCommitStatement(DatabaseMetaData databaseMetaData) throws SQLException {
        return false;
    }

    public int maxRowsPerInsert(DatabaseMetaData databaseMetaData) throws SQLException {
        return 100;
    }

    public boolean needsCreateLanguage(DatabaseMetaData databaseMetaData) throws SQLException {
        return false;
    }

    public void shutdown(Connection connection, String string, boolean bl) throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    static {
        SPECIFIC = XArrays.remove(Dialect.values(), ANSI.ordinal(), 1);
    }
}

