/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.GML32;
import org.opengis.cite.iso19136.SchemaComponentFilter;
import org.opengis.cite.iso19136.util.FeatureTypeFilter;
import org.opengis.cite.iso19136.util.GMLObjectTypeFilter;

public class XMLSchemaModelUtils {
    public static List<XSElementDeclaration> getFeatureDeclarations(XSModel model) {
        XSElementDeclaration gmlAbstractFeature = model.getElementDeclaration("AbstractFeature", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> featureElems = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlAbstractFeature);
        XMLSchemaModelUtils.removeGmlElementsFromList(featureElems);
        return featureElems;
    }

    public static List<XSElementDeclaration> getGeometryDeclarations(XSModel model) {
        XSElementDeclaration gmlAbstractGeometry = model.getElementDeclaration("AbstractGeometry", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> geomElems = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlAbstractGeometry);
        XMLSchemaModelUtils.removeGmlElementsFromList(geomElems);
        return geomElems;
    }

    public static List<XSElementDeclaration> getExplicitGeometryProperties(XSModel model) {
        ArrayList<XSElementDeclaration> geomProps = new ArrayList<XSElementDeclaration>();
        Set<String> nsNames = XMLSchemaModelUtils.getApplicationNamespaces(model);
        for (String nsName : nsNames) {
            XSNamedMap typeDefs = model.getComponentsByNamespace((short)3, nsName);
            for (int i = 0; i < typeDefs.getLength(); ++i) {
                XSTypeDefinition typeDef = (XSTypeDefinition)typeDefs.item(i);
                if (!typeDef.derivedFrom("http://www.opengis.net/gml/3.2", "GeometryPropertyType", (short)2) && !typeDef.derivedFrom("http://www.opengis.net/gml/3.2", "GeometryArrayPropertyType", (short)2)) continue;
                geomProps.addAll(XMLSchemaModelUtils.getGlobalElementsByType(model, typeDef));
            }
            for (String geomPropType : GML32.GEOM_PROP_TYPE_SET) {
                XSTypeDefinition typeDef = model.getTypeDefinition(geomPropType, "http://www.opengis.net/gml/3.2");
                geomProps.addAll(XMLSchemaModelUtils.getGlobalElementsByType(model, typeDef));
                geomProps.addAll(XMLSchemaModelUtils.getLocalElementsByType(model, typeDef, new FeatureTypeFilter()));
            }
        }
        return geomProps;
    }

    public static List<XSElementDeclaration> getImplicitProperties(XSModel model, XSElementDeclaration headElem) {
        ArrayList<XSComplexTypeDefinition> typeDefs = new ArrayList<XSComplexTypeDefinition>();
        for (String nsName : XMLSchemaModelUtils.getApplicationNamespaces(model)) {
            XSNamedMap types = model.getComponentsByNamespace((short)15, nsName);
            for (int i = 0; i < types.getLength(); ++i) {
                XSComplexTypeDefinition type = (XSComplexTypeDefinition)types.item(i);
                if (type.getContentType() != 2) continue;
                typeDefs.add(type);
            }
        }
        ArrayList<XSElementDeclaration> props = new ArrayList<XSElementDeclaration>();
        for (XSComplexTypeDefinition typeDef : typeDefs) {
            if (!XMLSchemaModelUtils.propertyHasValueDomain(typeDef, headElem)) continue;
            props.addAll(XMLSchemaModelUtils.getGlobalElementsByType(model, (XSTypeDefinition)typeDef));
            props.addAll(XMLSchemaModelUtils.getLocalElementsByType(model, (XSTypeDefinition)typeDef, new GMLObjectTypeFilter()));
        }
        return props;
    }

    public static boolean propertyHasValueDomain(XSComplexTypeDefinition typeDef, XSElementDeclaration headElem) {
        XSModelGroup group;
        XSParticle particle;
        boolean hasValueDomain = false;
        XSTerm term = typeDef.getParticle().getTerm();
        if (term.getType() == 7 && (particle = (XSParticle)(group = (XSModelGroup)term).getParticles().item(0)).getTerm().getType() == 2) {
            XSElementDeclaration propValue = (XSElementDeclaration)particle.getTerm();
            HashSet<XSElementDeclaration> headElems = new HashSet<XSElementDeclaration>();
            XMLSchemaModelUtils.getHeadElements(headElems, propValue);
            if (headElems.contains(headElem)) {
                hasValueDomain = true;
            }
        }
        return hasValueDomain;
    }

    public static void getHeadElements(Set<XSElementDeclaration> headElems, XSElementDeclaration propValue) {
        if (propValue.getScope() != 1) {
            return;
        }
        headElems.add(propValue);
        if (null != propValue.getSubstitutionGroupAffiliation()) {
            XMLSchemaModelUtils.getHeadElements(headElems, propValue.getSubstitutionGroupAffiliation());
        }
    }

    public static List<XSElementDeclaration> getTopologyDeclarations(XSModel model) {
        XSElementDeclaration gmlAbstractTopo = model.getElementDeclaration("AbstractTopology", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> topoElems = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlAbstractTopo);
        XMLSchemaModelUtils.removeGmlElementsFromList(topoElems);
        return topoElems;
    }

    public static List<XSElementDeclaration> getTimeObjectDeclarations(XSModel model) {
        XSElementDeclaration gmlAbstractTime = model.getElementDeclaration("AbstractTimeObject", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> timeElems = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlAbstractTime);
        XMLSchemaModelUtils.removeGmlElementsFromList(timeElems);
        return timeElems;
    }

    public static List<XSElementDeclaration> getCRSDeclarations(XSModel model) {
        XSElementDeclaration gmlAbstractCRS = model.getElementDeclaration("AbstractCRS", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> crsElems = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlAbstractCRS);
        XMLSchemaModelUtils.removeGmlElementsFromList(crsElems);
        return crsElems;
    }

    public static List<XSElementDeclaration> getCoverageDeclarations(XSModel model) {
        XSElementDeclaration gmlAbstractCoverage = model.getElementDeclaration("AbstractCoverage", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> coverageElems = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlAbstractCoverage);
        XMLSchemaModelUtils.removeGmlElementsFromList(coverageElems);
        return coverageElems;
    }

    public static List<XSElementDeclaration> getObservationDeclarations(XSModel model) {
        XSElementDeclaration gmlObservation = model.getElementDeclaration("Observation", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> observationElems = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlObservation);
        XMLSchemaModelUtils.removeGmlElementsFromList(observationElems);
        return observationElems;
    }

    public static List<XSElementDeclaration> getDefinitionDeclarations(XSModel model) {
        XSElementDeclaration gmlDefinition = model.getElementDeclaration("Definition", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> defnElems = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlDefinition);
        XMLSchemaModelUtils.removeGmlElementsFromList(defnElems);
        return defnElems;
    }

    public static List<XSElementDeclaration> getElementsByAffiliation(XSModel model, XSElementDeclaration head) {
        ArrayList<XSElementDeclaration> elemDecls = new ArrayList<XSElementDeclaration>();
        if (null == head) {
            return elemDecls;
        }
        XSObjectList subGroupMembers = model.getSubstitutionGroup(head);
        for (Object xsObject : subGroupMembers) {
            XSElementDeclaration subGroupMember = (XSElementDeclaration)xsObject;
            elemDecls.add(subGroupMember);
        }
        return elemDecls;
    }

    public static List<XSElementDeclaration> getGlobalElementsByType(XSModel model, XSTypeDefinition typeDef) {
        ArrayList<XSElementDeclaration> elems = new ArrayList<XSElementDeclaration>();
        Set<String> nsNames = XMLSchemaModelUtils.getApplicationNamespaces(model);
        for (String nsName : nsNames) {
            XSNamedMap elemDecls = model.getComponentsByNamespace((short)2, nsName);
            for (int i = 0; i < elemDecls.getLength(); ++i) {
                XSElementDeclaration elemDecl = (XSElementDeclaration)elemDecls.item(i);
                if (!elemDecl.getTypeDefinition().equals(typeDef) && !elemDecl.getTypeDefinition().derivedFromType(typeDef, (short)1)) continue;
                elems.add(elemDecl);
            }
        }
        return elems;
    }

    public static List<XSElementDeclaration> getLocalElementsByType(XSModel model, XSTypeDefinition typeDef, SchemaComponentFilter typeFilter) {
        ArrayList<XSElementDeclaration> elemsByType = new ArrayList<XSElementDeclaration>();
        Set<String> nsNames = XMLSchemaModelUtils.getApplicationNamespaces(model);
        for (String nsName : nsNames) {
            Map<QName, XSObject> complexTypes = new HashMap<QName, XSObject>();
            complexTypes.putAll((Map<QName, XSObject>)model.getComponentsByNamespace((short)15, nsName));
            XSNamedMap globalElemDecls = model.getComponentsByNamespace((short)2, nsName);
            for (int i = 0; i < globalElemDecls.getLength(); ++i) {
                XSElementDeclaration elemDecl = (XSElementDeclaration)globalElemDecls.item(i);
                if (elemDecl.getTypeDefinition().getTypeCategory() == 16 || !elemDecl.getTypeDefinition().getAnonymous()) continue;
                complexTypes.put(new QName(nsName, "anon-" + i), (XSObject)elemDecl.getTypeDefinition());
            }
            if (null != typeFilter) {
                complexTypes = typeFilter.doFilter(complexTypes);
            }
            for (XSObject xsObj : complexTypes.values()) {
                XSComplexTypeDefinition type = (XSComplexTypeDefinition)xsObj;
                List<XSElementDeclaration> childElems = XMLSchemaModelUtils.getAllElementsInParticle(type.getParticle());
                for (XSElementDeclaration elemDecl : childElems) {
                    if (!elemDecl.getTypeDefinition().equals(typeDef) && !elemDecl.getTypeDefinition().derivedFromType(typeDef, (short)1) || elemDecl.getScope() == 1) continue;
                    elemsByType.add(elemDecl);
                }
            }
        }
        return elemsByType;
    }

    public static List<XSElementDeclaration> getAllElementsInParticle(XSParticle particle) {
        ArrayList<XSElementDeclaration> elems = new ArrayList<XSElementDeclaration>();
        if (null != particle) {
            switch (particle.getTerm().getType()) {
                case 2: {
                    XSElementDeclaration elemDecl = (XSElementDeclaration)particle.getTerm();
                    elems.add(elemDecl);
                    break;
                }
                case 7: {
                    XSModelGroup group = (XSModelGroup)particle.getTerm();
                    for (XSParticle xsParticle : group.getParticles()) {
                        elems.addAll(XMLSchemaModelUtils.getAllElementsInParticle(xsParticle));
                    }
                    break;
                }
            }
        }
        return elems;
    }

    public static List<XSParticle> getAllElementParticles(XSParticle particle) {
        ArrayList<XSParticle> particles = new ArrayList<XSParticle>();
        XSTerm xsTerm = particle.getTerm();
        switch (xsTerm.getType()) {
            case 2: {
                particles.add(particle);
                break;
            }
            case 7: {
                XSModelGroup group = (XSModelGroup)xsTerm;
                for (XSParticle xsParticle : group.getParticles()) {
                    particles.addAll(XMLSchemaModelUtils.getAllElementParticles(xsParticle));
                }
                break;
            }
        }
        return particles;
    }

    public static Set<XSComplexTypeDefinition> getReferencedComplexTypeDefinitions(XSModel model) {
        HashSet<XSComplexTypeDefinition> typeDefs = new HashSet<XSComplexTypeDefinition>();
        Set<String> appNamespaces = XMLSchemaModelUtils.getApplicationNamespaces(model);
        for (String nsName : appNamespaces) {
            XSNamedMap elemDecls = model.getComponentsByNamespace((short)2, nsName);
            for (int i = 0; i < elemDecls.getLength(); ++i) {
                XSElementDeclaration elemDecl = (XSElementDeclaration)elemDecls.item(i);
                XSTypeDefinition typeDef = elemDecl.getTypeDefinition();
                if (typeDef.getTypeCategory() != 15) continue;
                typeDefs.add((XSComplexTypeDefinition)typeDef);
            }
        }
        return typeDefs;
    }

    public static Set<XSComplexTypeDefinition> getGlobalComplexTypeDefinitions(XSModel model) {
        HashSet<XSComplexTypeDefinition> typeDefs = new HashSet<XSComplexTypeDefinition>();
        for (String nsName : XMLSchemaModelUtils.getApplicationNamespaces(model)) {
            XSNamedMap components = model.getComponentsByNamespace((short)15, nsName);
            Collection values = components.values();
            typeDefs.addAll(values);
        }
        return typeDefs;
    }

    public static Set<String> getApplicationNamespaces(XSModel model) {
        StringList nsNames = model.getNamespaces();
        HashSet<String> appNamespaces = new HashSet<String>();
        for (int i = 0; i < nsNames.getLength(); ++i) {
            String nsName = nsNames.item(i);
            if (nsName.startsWith("http://www.opengis.net/gml") || nsName.startsWith("http://www.w3.org/") || nsName.startsWith("http://www.isotc211.org/")) continue;
            appNamespaces.add(nsName);
        }
        return appNamespaces;
    }

    public static Set<XSTypeDefinition> getDerivedTypeDefinitions(XSModel model, XSTypeDefinition baseType, short derivationMethod) {
        HashSet<XSTypeDefinition> typeDefs = new HashSet<XSTypeDefinition>();
        for (String nsName : XMLSchemaModelUtils.getApplicationNamespaces(model)) {
            XSNamedMap components = model.getComponentsByNamespace((short)3, nsName);
            for (int i = 0; i < components.getLength(); ++i) {
                XSTypeDefinition typeDef = (XSTypeDefinition)components.item(i);
                if (!typeDef.derivedFromType(baseType, derivationMethod)) continue;
                typeDefs.add(typeDef);
            }
        }
        return typeDefs;
    }

    public static List<XSElementDeclaration> getElementDeclarationsByType(XSModel model, XSTypeDefinition baseType) {
        List<XSElementDeclaration> elemDecls = XMLSchemaModelUtils.getGlobalElementsByType(model, baseType);
        elemDecls.addAll(XMLSchemaModelUtils.getLocalElementsByType(model, baseType, new FeatureTypeFilter()));
        return elemDecls;
    }

    public static QName getQName(XSObject xsObject) {
        String localName = null != xsObject.getName() ? xsObject.getName() : new String();
        return new QName(xsObject.getNamespace(), localName);
    }

    static void removeGmlElementsFromList(List<XSElementDeclaration> elemDecls) {
        Iterator<XSElementDeclaration> itr = elemDecls.iterator();
        while (itr.hasNext()) {
            XSElementDeclaration decl = itr.next();
            if (!decl.getNamespace().equals("http://www.opengis.net/gml/3.2")) continue;
            itr.remove();
        }
    }
}

