/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.ImmutableEnvelope;
import org.geotoolkit.referencing.CRS;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.time.TemporalUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.opengis.util.FactoryException;
import org.testng.SkipException;

public class FeatureTypeInfo {
    private QName typeName;
    private Envelope spatialExtent;
    private boolean instantiated;
    private List<String> supportedCRSList = new ArrayList<String>();
    private File sampleData;
    private Period temporalExtent;

    public List<String> getSupportedCRSIdentifiers() {
        return this.supportedCRSList;
    }

    public void addCRSIdentifiers(String ... crsIdentifiers) {
        this.supportedCRSList.addAll(Arrays.asList(crsIdentifiers));
    }

    public QName getTypeName() {
        return this.typeName;
    }

    public void setTypeName(QName typeName) {
        this.typeName = typeName;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    public void setInstantiated(boolean available) {
        this.instantiated = available;
    }

    public String getDefaultCRS() {
        return this.supportedCRSList.get(0);
    }

    public Envelope getSpatialExtent() {
        if (null == this.spatialExtent) {
            this.spatialExtent = this.getValidAreaOfCRS(this.getDefaultCRS());
        }
        return this.spatialExtent;
    }

    public void setSpatialExtent(Envelope geoExtent) {
        CoordinateReferenceSystem defaultCRS = null;
        try {
            String crsId = GeodesyUtils.getAbbreviatedCRSIdentifier((String)this.getDefaultCRS());
            defaultCRS = CRS.decode((String)crsId);
        }
        catch (FactoryException fex) {
            throw new RuntimeException("Default CRS not recognized. " + fex.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new SkipException("Default CRS is not valid. " + iae.getMessage());
        }
        if (!geoExtent.getCoordinateReferenceSystem().equals(defaultCRS)) {
            Envelope bbox = null;
            try {
                bbox = Envelopes.transform((Envelope)geoExtent, (CoordinateReferenceSystem)defaultCRS);
            }
            catch (TransformException e) {
                throw new IllegalArgumentException("Failed to transform envelope coordinates to CRS " + this.getDefaultCRS(), e);
            }
            this.spatialExtent = new ImmutableEnvelope(bbox);
        } else {
            this.spatialExtent = geoExtent;
        }
    }

    public File getSampleData() {
        return this.sampleData;
    }

    public void setSampleData(File sampleData) {
        this.sampleData = sampleData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureTypeInfo {");
        sb.append("\n typeName: '").append(this.typeName);
        sb.append("',\n supportedCRS: '").append(this.supportedCRSList);
        sb.append("',\n instantiated: ").append(this.instantiated);
        sb.append(",\n spatial extent: '").append(Envelopes.toWKT((Envelope)this.getSpatialExtent()));
        if (this.temporalExtent != null) {
            sb.append("',\n temporal extent: '");
            sb.append(TemporalUtils.temporalGeometricPrimitiveToString((TemporalGeometricPrimitive)this.temporalExtent));
        }
        if (this.sampleData != null && this.sampleData.exists()) {
            sb.append("',\n data: '").append(this.sampleData.toString());
        }
        sb.append("'\n}");
        return sb.toString();
    }

    public Period getTemporalExtent() {
        return this.temporalExtent;
    }

    public void setTemporalExtent(Period period) {
        this.temporalExtent = period;
    }

    ImmutableEnvelope getValidAreaOfCRS(String crsRef) {
        ImmutableEnvelope envelope = null;
        try {
            envelope = GeodesyUtils.getDomainOfValidity((String)crsRef);
        }
        catch (FactoryException e) {
            TestSuiteLogger.log(Level.WARNING, "Cannot determine domain of validity for CRS " + crsRef, (Exception)((Object)e));
        }
        return envelope;
    }
}

