/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.transform;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.geotoolkit.geometry.jts.coordinatesequence.LiteCoordinateSequence;
import org.geotoolkit.geometry.jts.transform.AbstractGeometryTransformer;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.XArrays;
import org.opengis.referencing.operation.TransformException;

public class GeometryClipTransformer
extends AbstractGeometryTransformer {
    private final Rectangle2D clip;
    private float xmin;
    private float ymin;
    private float xmax;
    private float ymax;
    private final Line2D.Float line = new Line2D.Float();
    private float[] border = new float[16];
    private int borderLength;
    private float[] intersect = new float[8];
    private int intersectLength;
    private int index = 0;
    private Geometry currentGeometry;

    public GeometryClipTransformer(Rectangle2D clip) {
        ArgumentChecks.ensureNonNull("clip rectangle", clip);
        this.clip = clip;
        this.init();
    }

    public GeometryClipTransformer(Rectangle2D clip, CoordinateSequenceFactory csf) {
        super(csf);
        ArgumentChecks.ensureNonNull("clip rectangle", clip);
        this.clip = clip;
        this.init();
    }

    public GeometryClipTransformer(Rectangle2D clip, GeometryFactory gf) {
        super(gf);
        ArgumentChecks.ensureNonNull("clip rectangle", clip);
        this.clip = clip;
        this.init();
    }

    private void init() {
        this.xmin = (float)this.clip.getMinX();
        this.xmax = (float)this.clip.getMaxX();
        this.ymin = (float)this.clip.getMinY();
        this.ymax = (float)this.clip.getMaxY();
    }

    private boolean next(CoordinateSequence sequence) {
        if (this.index == sequence.size() - 1) {
            return false;
        }
        this.line.x1 = (float)sequence.getX(this.index);
        this.line.y1 = (float)sequence.getY(this.index);
        this.line.x2 = (float)sequence.getX(this.index + 1);
        this.line.y2 = (float)sequence.getY(this.index + 1);
        ++this.index;
        return true;
    }

    @Override
    public Geometry transform(Geometry geom) throws TransformException {
        this.currentGeometry = geom;
        return super.transform(geom);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CoordinateSequence transform(CoordinateSequence cs, int minpoints) {
        result = null;
        size = cs.size();
        if (size <= 2) {
            return cs;
        }
        this.index = 0;
        this.xmin = (float)this.clip.getMinX();
        this.xmax = (float)this.clip.getMaxX();
        this.ymin = (float)this.clip.getMinY();
        this.ymax = (float)this.clip.getMaxY();
        this.borderLength = 0;
        this.intersectLength = 0;
        isClosed = cs.getCoordinate(0).equals2D(cs.getCoordinate(size));
        if (this.next(cs)) {
            firstX = this.line.x2;
            firstY = this.line.y2;
            hasJoined = false;
            inside = firstX >= this.xmin && firstX <= this.xmax && firstY >= this.ymin && firstY <= this.ymax;
            initialX1 = NaNf;
            initialY1 = NaNf;
            initialClockwise = NaN;
            x0 = NaNf;
            y0 = NaNf;
            clockwise = 0.0;
            lower = 0;
            upper = 0;
            block0: while (true) {
                if (!this.next(cs)) {
                    if (!isClosed || this.line.x2 == firstX && this.line.y2 == firstY) break;
                    if (!GeometryClipTransformer.$assertionsDisabled && hasJoined) {
                        throw new AssertionError();
                    }
                    this.line.x2 = firstX;
                    this.line.y2 = firstY;
                    hasJoined = true;
                }
                ++upper;
                outcode1 = 0;
                outcode2 = 0;
                x1 = this.line.x1;
                y1 = this.line.y1;
                x2 = this.line.x2;
                y2 = this.line.y2;
                dx = x2 - x1;
                dy = y2 - y1;
                out1 = y1 > this.ymax;
                if (out1) {
                    outcode1 |= 8;
                }
                if (out2 = y2 > this.ymax) {
                    outcode2 |= 8;
                }
                if (out1 && out2) {
                    clockwise += (double)dx;
                } else if (out1) {
                    clockwise += (double)(dx / dy * (this.ymax - y1));
                } else if (out2) {
                    clockwise += (double)(dx / dy * (y2 - this.ymax));
                }
                if (out1 = y1 < this.ymin) {
                    outcode1 |= 2;
                }
                if (out2 = y2 < this.ymin) {
                    outcode2 |= 2;
                }
                if (out1 && out2) {
                    clockwise -= (double)dx;
                } else if (out1) {
                    clockwise -= (double)(dx / dy * (this.ymin - y1));
                } else if (out2) {
                    clockwise -= (double)(dx / dy * (y2 - this.ymin));
                }
                if (out1 = x1 > this.xmax) {
                    outcode1 |= 4;
                }
                if (out2 = x2 > this.xmax) {
                    outcode2 |= 4;
                }
                if (out1 && out2) {
                    clockwise -= (double)dy;
                } else if (out1) {
                    clockwise -= (double)(dy / dx * (this.xmax - x1));
                } else if (out2) {
                    clockwise -= (double)(dy / dx * (x2 - this.xmax));
                }
                if (out1 = x1 < this.xmin) {
                    outcode1 |= 1;
                }
                if (out2 = x2 < this.xmin) {
                    outcode2 |= 1;
                }
                if (out1 && out2) {
                    clockwise += (double)dy;
                } else if (out1) {
                    clockwise += (double)(dy / dx * (this.xmin - x1));
                } else if (out2) {
                    clockwise += (double)(dy / dx * (x2 - this.xmin));
                }
                lineInsideAndOutside = inside != (outcode2 == 0);
                lineCompletlyOutside = lineInsideAndOutside == false && outcode1 != 0 && outcode2 != 0 && (outcode1 & outcode2) == 0;
                this.intersectLength = 0;
                if (lineInsideAndOutside || lineCompletlyOutside) {
                    cxmin = Math.max(this.xmin, Math.min(x1, x2));
                    cxmax = Math.min(this.xmax, Math.max(x1, x2));
                    cymin = Math.max(this.ymin, Math.min(y1, y2));
                    cymax = Math.min(this.ymax, Math.max(y1, y2));
                    if (this.ymax >= cymin && this.ymax <= cymax && (v = dx / dy * (this.ymax - y1) + x1) >= cxmin && v <= cxmax) {
                        this.addIntersect(v, this.ymax);
                    }
                    if (this.ymin >= cymin && this.ymin <= cymax && (v = dx / dy * (this.ymin - y1) + x1) >= cxmin && v <= cxmax) {
                        this.addIntersect(v, this.ymin);
                    }
                    if (this.xmax >= cxmin && this.xmax <= cxmax && (v = dy / dx * (this.xmax - x1) + y1) >= cymin && v <= cymax) {
                        this.addIntersect(this.xmax, v);
                    }
                    if (this.xmin >= cxmin && this.xmin <= cxmax && (v = dy / dx * (this.xmin - x1) + y1) >= cymin && v <= cymax) {
                        this.addIntersect(this.xmin, v);
                    }
                    do {
                        modified = false;
                        for (i = 2; i < this.intersectLength; i += 2) {
                            if (!((this.intersect[i - 2] - x1) * dx + (this.intersect[i - 1] - y1) * dy > (this.intersect[i + 0] - x1) * dx + (this.intersect[i + 1] - y1) * dy)) continue;
                            x = this.intersect[i - 2];
                            y = this.intersect[i - 1];
                            this.intersect[i - 2] = this.intersect[i + 0];
                            this.intersect[i - 1] = this.intersect[i + 1];
                            this.intersect[i + 0] = x;
                            this.intersect[i + 1] = y;
                            modified = true;
                        }
                    } while (modified);
                }
                if (lineInsideAndOutside) {
                    v0 = inside = inside == false;
                    if (inside) {
                        if (this.intersectLength >= 2) {
                            xn = this.intersect[0];
                            yn = this.intersect[1];
                        } else {
                            xn = x1;
                            yn = y1;
                        }
                        if (Float.isNaN(x0) || Float.isNaN(y0)) {
                            initialClockwise = clockwise;
                            initialX1 = xn;
                            initialY1 = yn;
                        } else {
                            this.buildBorder(clockwise, x0, y0, xn, yn);
                        }
                        x0 = NaNf;
                        y0 = NaNf;
                        clockwise = 0.0;
                    } else {
                        if (this.intersectLength >= 2) {
                            x0 = this.intersect[this.intersectLength - 2];
                            y0 = this.intersect[this.intersectLength - 1];
                        } else {
                            x0 = x2;
                            y0 = y2;
                        }
                        if (!GeometryClipTransformer.$assertionsDisabled && upper > cs.size()) {
                            throw new AssertionError(upper);
                        }
                        result = this.attach(result, cs, lower, upper);
                    }
                    lower = upper;
                    i = 0;
                    while (true) {
                        if (i >= this.intersectLength) continue block0;
                        this.addBorder(this.intersect[i++], this.intersect[i++]);
                    }
                }
                if (!lineCompletlyOutside || this.intersectLength < 4) continue;
                clockwise2 = 0.0;
                if ((outcode1 & 8) == 0 && (outcode2 & 8) != 0) {
                    clockwise2 += (double)(dx / dy * (y2 - this.ymax));
                }
                if ((outcode1 & 2) == 0 && (outcode2 & 2) != 0) {
                    clockwise2 -= (double)(dx / dy * (y2 - this.ymin));
                }
                if ((outcode1 & 4) == 0 && (outcode2 & 4) != 0) {
                    clockwise2 -= (double)(dy / dx * (x2 - this.xmax));
                }
                if ((outcode1 & 1) == 0 && (outcode2 & 1) != 0) {
                    clockwise2 += (double)(dy / dx * (x2 - this.xmin));
                }
                clockwise -= clockwise2;
                if (Float.isNaN(x0) || Float.isNaN(y0)) {
                    initialClockwise = clockwise;
                    initialX1 = this.line.x1;
                    initialY1 = this.line.y1;
                } else {
                    this.buildBorder(clockwise, x0, y0, this.intersect[0], this.intersect[1]);
                }
                x0 = this.intersect[this.intersectLength - 2];
                y0 = this.intersect[this.intersectLength - 1];
                clockwise = clockwise2;
                i = 0;
                while (true) {
                    if (i < this.intersectLength) ** break;
                    continue block0;
                    this.addBorder(this.intersect[i++], this.intersect[i++]);
                }
                break;
            }
            if (inside) {
                if (!hasJoined) {
                    ++upper;
                }
                if (!GeometryClipTransformer.$assertionsDisabled && upper > cs.size()) {
                    throw new AssertionError(upper);
                }
                result = this.attach(result, cs, lower, upper);
            }
            if (isClosed && !Float.isNaN(x0) && !Float.isNaN(y0)) {
                this.buildBorder(clockwise + initialClockwise, x0, y0, initialX1, initialY1);
            }
            if (result != null) {
                result = this.attach(result, cs, 0, 0);
            } else {
                if (this.borderLength != 0) {
                    if (this.border.length == this.borderLength) {
                        tmp = this.border;
                    } else {
                        tmp = new float[this.borderLength];
                        System.arraycopy(this.border, 0, tmp, 0, this.borderLength);
                    }
                    return new LiteCoordinateSequence(tmp);
                }
                clipcs = new LiteCoordinateSequence(new float[]{this.xmin, this.ymin, this.xmin, this.ymax, this.xmax, this.ymax, this.xmax, this.ymin, this.xmin, this.ymin});
                clipls = this.gf.createLineString((CoordinateSequence)clipcs);
                if (clipls.intersects(this.currentGeometry)) {
                    return clipcs;
                }
            }
        }
        if (result == null || result.length == 0) {
            return null;
        }
        return new LiteCoordinateSequence(result);
    }

    private double[] attach(double[] result, CoordinateSequence cs, int lower, int upper) {
        if (this.borderLength > 0) {
            if (result == null) {
                result = new double[this.borderLength];
            } else {
                int nsize = result.length + this.borderLength;
                XArrays.resize(result, nsize);
            }
            System.arraycopy(this.border, 0, result, result.length, this.borderLength);
        }
        this.borderLength = 0;
        int extent = upper - lower;
        if (extent > 0) {
            int k;
            if (result == null) {
                k = 0;
                result = new double[extent * 2];
            } else {
                k = result.length;
                XArrays.resize(result, result.length + extent * 2);
            }
            int i = lower;
            while (i < upper) {
                result[k] = cs.getX(i);
                result[k + 1] = cs.getY(i);
                ++i;
                k += 2;
            }
        }
        return result;
    }

    private void addIntersect(float x0, float y0) {
        if (this.intersectLength >= 2 && this.intersect[this.intersectLength - 2] == x0 && this.intersect[this.intersectLength - 1] == y0) {
            return;
        }
        if (this.intersectLength >= this.intersect.length) {
            this.intersect = XArrays.resize(this.intersect, 2 * this.intersectLength);
        }
        this.intersect[this.intersectLength++] = x0;
        this.intersect[this.intersectLength++] = y0;
    }

    private void buildBorder(double clockwise, float x0, float y0, float x1, float y1) {
        block18: {
            if (clockwise > 0.0) {
                while (true) {
                    if (y0 >= this.ymax) {
                        if (y1 >= this.ymax && x1 >= x0) break block18;
                        if (x0 < this.xmax) {
                            x0 = this.xmax;
                            y0 = this.ymax;
                            this.addBorder(x0, y0);
                        }
                    }
                    if (x0 >= this.xmax) {
                        if (x1 >= this.xmax && y1 <= y0) break block18;
                        if (y0 > this.ymin) {
                            x0 = this.xmax;
                            y0 = this.ymin;
                            this.addBorder(x0, y0);
                        }
                    }
                    if (y0 <= this.ymin) {
                        if (y1 <= this.ymin && x1 <= x0) break block18;
                        if (x0 > this.xmin) {
                            x0 = this.xmin;
                            y0 = this.ymin;
                            this.addBorder(x0, y0);
                        }
                    }
                    if (!(x0 <= this.xmin)) continue;
                    if (!(x1 <= this.xmin) || !(y1 >= y0)) {
                        if (!(y0 < this.ymax)) continue;
                        x0 = this.xmin;
                        y0 = this.ymax;
                        this.addBorder(x0, y0);
                        continue;
                    }
                    break block18;
                    break;
                }
            }
            if (clockwise < 0.0) {
                while (true) {
                    if (y0 >= this.ymax) {
                        if (y1 >= this.ymax && x1 <= x0) break;
                        if (x0 > this.xmin) {
                            x0 = this.xmin;
                            y0 = this.ymax;
                            this.addBorder(x0, y0);
                        }
                    }
                    if (x0 <= this.xmin) {
                        if (x1 <= this.xmin && y1 <= y0) break;
                        if (y0 > this.ymin) {
                            x0 = this.xmin;
                            y0 = this.ymin;
                            this.addBorder(x0, y0);
                        }
                    }
                    if (y0 <= this.ymin) {
                        if (y1 <= this.ymin && x1 >= x0) break;
                        if (x0 < this.xmax) {
                            x0 = this.xmax;
                            y0 = this.ymin;
                            this.addBorder(x0, y0);
                        }
                    }
                    if (!(x0 >= this.xmax)) continue;
                    if (x1 >= this.xmax && y1 >= y0) break;
                    if (!(y0 < this.ymax)) continue;
                    x0 = this.xmax;
                    y0 = this.ymax;
                    this.addBorder(x0, y0);
                }
            }
        }
    }

    private void addBorder(float x0, float y0) {
        if (this.borderLength >= 2 && this.border[this.borderLength - 2] == x0 && this.border[this.borderLength - 1] == y0) {
            return;
        }
        if (this.borderLength >= this.border.length) {
            this.border = XArrays.resize(this.border, 2 * this.borderLength);
        }
        this.border[this.borderLength++] = x0;
        this.border[this.borderLength++] = y0;
    }

    @Override
    public Point transform(Point geom) throws TransformException {
        return geom;
    }

    @Override
    protected MultiPoint transform(MultiPoint geom) throws TransformException {
        int nbGeom = geom.getNumGeometries();
        if (nbGeom == 1) {
            return geom;
        }
        LiteCoordinateSequence cs = new LiteCoordinateSequence(nbGeom, 2);
        for (int i = 0; i < nbGeom; ++i) {
            Coordinate coord = geom.getGeometryN(i).getCoordinate();
            cs.setX(i, coord.x);
            cs.setY(i, coord.y);
        }
        return this.gf.createMultiPoint(this.transform((CoordinateSequence)cs, 1));
    }
}

