/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class FloatValue
extends NumericValue {
    public static final FloatValue ZERO = new FloatValue(0.0f);
    public static final FloatValue NEGATIVE_ZERO = new FloatValue(-0.0f);
    public static final FloatValue ONE = new FloatValue(1.0f);
    public static final FloatValue NaN = new FloatValue(Float.NaN);
    private float value;
    static Pattern roundablePattern = Pattern.compile(".*99999.*|.*00000.*");

    public FloatValue(CharSequence val) throws ValidationException {
        try {
            this.value = (float)Value.stringToNumber(val);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Cannot convert string " + Err.wrap(val, 4) + " to a float");
        }
        this.typeLabel = BuiltInAtomicType.FLOAT;
    }

    public FloatValue(float value) {
        this.value = value;
        this.typeLabel = BuiltInAtomicType.FLOAT;
    }

    public FloatValue(float value, AtomicType type) {
        this.value = value;
        this.typeLabel = type;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        FloatValue v = new FloatValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.FLOAT;
    }

    public float getFloatValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return (int)this.value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean effectiveBooleanValue() {
        return (double)this.value != 0.0 && !Float.isNaN(this.value);
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get((double)this.value != 0.0 && !Float.isNaN(this.value));
            }
            case 516: 
            case 632: 
            case 635: {
                return this;
            }
            case 532: {
                if (Float.isNaN(this.value)) {
                    ValidationFailure err = new ValidationFailure("Cannot convert float NaN to an integer");
                    err.setErrorCode("FOCA0002");
                    return err;
                }
                if (Float.isInfinite(this.value)) {
                    ValidationFailure err = new ValidationFailure("Cannot convert float infinity to an integer");
                    err.setErrorCode("FOCA0002");
                    return err;
                }
                if (this.value > 9.223372E18f || this.value < -9.223372E18f) {
                    return new BigIntegerValue(new BigDecimal(this.value).toBigInteger());
                }
                return Int64Value.makeIntegerValue((long)this.value);
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                ConversionResult iv = this.convertPrimitive(BuiltInAtomicType.INTEGER, validate, context);
                if (iv instanceof ValidationFailure) {
                    return iv;
                }
                return ((IntegerValue)iv).convertPrimitive(requiredType, validate, context);
            }
            case 515: {
                try {
                    return new DecimalValue(this.value);
                }
                catch (ValidationException e) {
                    return new ValidationFailure(e);
                }
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert float to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    public CharSequence getStringValueCS() {
        return FloatValue.floatToString(this.value);
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        FastStringBuffer fsb = new FastStringBuffer(20);
        return FloatingPointConverter.appendFloatExponential(fsb, this.value);
    }

    static CharSequence floatToString(float value) {
        return FloatingPointConverter.appendFloat(new FastStringBuffer(20), value);
    }

    static CharSequence floatToStringOLD(float value, String javaString) {
        String sign;
        if ((double)value == 0.0) {
            if (javaString.charAt(0) == '-') {
                return "-0";
            }
            return "0";
        }
        if (Float.isInfinite(value)) {
            return value > 0.0f ? "INF" : "-INF";
        }
        if (Float.isNaN(value)) {
            return "NaN";
        }
        float absval = Math.abs(value);
        String s = javaString;
        if (absval < 1.0E-6f || absval >= 1000000.0f) {
            int e = s.indexOf(69);
            if (e < 0) {
                FastStringBuffer sb = new FastStringBuffer(32);
                Matcher matcher = DoubleValue.nonExponentialPattern.matcher(s);
                if (matcher.matches()) {
                    sb.append(matcher.group(1));
                    sb.append('.');
                    sb.append(matcher.group(2));
                    String fraction = matcher.group(4);
                    if ("0".equals(fraction)) {
                        sb.append("E" + (matcher.group(2).length() + matcher.group(3).length()));
                        return sb.toString();
                    }
                    sb.append(matcher.group(3));
                    sb.append(matcher.group(4));
                    sb.append("E" + (matcher.group(2).length() + matcher.group(3).length()));
                    return sb;
                }
                return s;
            }
            if (roundablePattern.matcher(s).matches()) {
                BigDecimal dec = FormatNumber.adjustToDecimal(value, 1);
                try {
                    return new DoubleValue(dec.toString()).getStringValue();
                }
                catch (ValidationException err) {
                    throw new AssertionError((Object)err);
                }
            }
            return s;
        }
        int len = s.length();
        if (s.indexOf("E") >= 0 && s.endsWith(".0")) {
            return DoubleValue.doubleToString(value);
        }
        if (s.endsWith("E0")) {
            s = s.substring(0, len - 2);
        }
        if (s.endsWith(".0")) {
            return s.substring(0, len - 2);
        }
        int e = s.indexOf(69);
        if (e < 0) {
            while (s.charAt(len - 1) == '0' && s.charAt(len - 2) != '.') {
                s = s.substring(0, --len);
            }
            return s;
        }
        int exp = Integer.parseInt(s.substring(e + 1));
        if (s.charAt(0) == '-') {
            sign = "-";
            s = s.substring(1);
            --e;
        } else {
            sign = "";
        }
        int nDigits = e - 2;
        if (exp >= nDigits) {
            return sign + s.substring(0, 1) + s.substring(2, e) + DoubleValue.zeros(exp - nDigits);
        }
        if (exp > 0) {
            return sign + s.substring(0, 1) + s.substring(2, 2 + exp) + '.' + s.substring(2 + exp, e);
        }
        while (s.charAt(e - 1) == '0') {
            --e;
        }
        return sign + "0." + DoubleValue.zeros(-1 - exp) + s.substring(0, 1) + s.substring(2, e);
    }

    public NumericValue negate() {
        return new FloatValue(-this.value);
    }

    public NumericValue floor() {
        return new FloatValue((float)Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new FloatValue((float)Math.ceil(this.value));
    }

    public NumericValue round() {
        if (Float.isNaN(this.value)) {
            return this;
        }
        if (Float.isInfinite(this.value)) {
            return this;
        }
        if ((double)this.value == 0.0) {
            return this;
        }
        if ((double)this.value >= -0.5 && (double)this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return new FloatValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue roundHalfToEven(int scale) {
        try {
            return (FloatValue)new DoubleValue(this.value).roundHalfToEven(scale).convertPrimitive(BuiltInAtomicType.FLOAT, true, null).asAtomic();
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    public double signum() {
        if (Float.isNaN(this.value)) {
            return this.value;
        }
        if (this.value > 0.0f) {
            return 1.0;
        }
        if (this.value == 0.0f) {
            return 0.0;
        }
        return -1.0;
    }

    public boolean isWholeNumber() {
        return (double)this.value == Math.floor(this.value) && !Float.isInfinite(this.value);
    }

    public int compareTo(Object other) {
        if (!(other instanceof NumericValue)) {
            throw new ClassCastException("Numeric values are not comparable to " + other.getClass());
        }
        if (other instanceof FloatValue) {
            float otherFloat = ((FloatValue)other).value;
            if (this.value == otherFloat) {
                return 0;
            }
            if (this.value < otherFloat) {
                return -1;
            }
            return 1;
        }
        if (other instanceof DoubleValue) {
            return super.compareTo(other);
        }
        try {
            return this.compareTo(((NumericValue)other).convertPrimitive(BuiltInAtomicType.FLOAT, true, null).asAtomic());
        }
        catch (XPathException err) {
            throw new ClassCastException("Operand of comparison cannot be promoted to xs:float");
        }
    }

    public int compareTo(long other) {
        float otherFloat = other;
        if (this.value == otherFloat) {
            return 0;
        }
        if (this.value < otherFloat) {
            return -1;
        }
        return 1;
    }

    public Comparable getSchemaComparable() {
        return new Float(this.value);
    }

    public Object convertToJava(Class target, XPathContext context) throws XPathException {
        if (target == Object.class) {
            return new Double(this.value);
        }
        if (target.isAssignableFrom(DoubleValue.class)) {
            return this;
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return (double)this.value != 0.0 && !Float.isNaN(this.value);
        }
        if (target == String.class || target == CharSequence.class) {
            return this.getStringValue();
        }
        if (target == Double.TYPE || target == Double.class) {
            return new Double(this.value);
        }
        if (target == Float.TYPE || target == Float.class) {
            return new Float(this.value);
        }
        if (target == Long.TYPE || target == Long.class) {
            return new Long((long)this.value);
        }
        if (target == Integer.TYPE || target == Integer.class) {
            return new Integer((int)this.value);
        }
        if (target == Short.TYPE || target == Short.class) {
            return new Short((short)this.value);
        }
        if (target == Byte.TYPE || target == Byte.class) {
            return new Byte((byte)this.value);
        }
        if (target == Character.TYPE || target == Character.class) {
            return new Character((char)this.value);
        }
        Object o = super.convertToJava(target, context);
        if (o == null) {
            XPathException err = new XPathException("Conversion of float to " + target.getName() + " is not supported");
            err.setXPathContext(context);
            err.setErrorCode("SXJE0004");
        }
        return o;
    }
}

