/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.iso19136.ETSAssert;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.NodeList;

public class PropertyValueTests
extends DataFixture {
    private XMLInputFactory factory = XMLInputFactory.newInstance();

    @Test(description="See ISO 19136: 9.4.2")
    public void validateLocationName() throws FileNotFoundException, MalformedURLException {
        NodeList codeSpaceList;
        StreamSource source = new StreamSource(this.dataFile);
        String xpath = "//gml:locationName/@codeSpace";
        try {
            codeSpaceList = (NodeList)XMLUtils.evaluateXPath(source, xpath, null, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        for (int i = 0; i < codeSpaceList.getLength(); ++i) {
            URL url = new URL(codeSpaceList.item(i).getTextContent());
            ETSAssert.assertURLIsResolvable(url, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="See ISO 19136: 9.4.2")
    public void validateLocationReference() throws FileNotFoundException, MalformedURLException {
        FileInputStream inStream = new FileInputStream(this.dataFile);
        XMLEventReader reader = null;
        try {
            XMLEventReader baseReader = this.factory.createXMLEventReader(inStream);
            reader = this.factory.createFilteredReader(baseReader, new GMLEventFilter("locationReference"));
            while (reader.hasNext()) {
                QName xlinkHref = new QName("http://www.w3.org/1999/xlink", "href");
                StartElement locationRef = reader.nextEvent().asStartElement();
                Attribute href = locationRef.getAttributeByName(xlinkHref);
                Assert.assertNotNull((Object)href, (String)ErrorMessage.format("MissingInfosetItem", xlinkHref, locationRef.getLocation().toString()));
                URI uri = URI.create(href.getValue());
                if (!uri.isAbsolute()) {
                    uri = this.dataFile.toURI().resolve(uri);
                }
                ETSAssert.assertURLIsResolvable(uri.toURL(), MediaType.TEXT_PLAIN_TYPE);
            }
        }
        catch (XMLStreamException e) {
        }
        finally {
            try {
                reader.close();
                ((InputStream)inStream).close();
            }
            catch (Exception e) {
                TestSuiteLogger.log(Level.INFO, "Failed to close resource.", e);
            }
        }
    }

    class GMLEventFilter
    implements EventFilter {
        String tagName;

        public GMLEventFilter(String localName) {
            this.tagName = localName;
        }

        @Override
        public boolean accept(XMLEvent event) {
            if (event.getEventType() != 1) {
                return false;
            }
            boolean isLocationReference = false;
            QName qName = new QName("http://www.opengis.net/gml/3.2", this.tagName);
            StartElement startTag = event.asStartElement();
            if (startTag.getName().equals(qName)) {
                isLocationReference = true;
            }
            return isLocationReference;
        }
    }
}

