/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.storage;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotoolkit.internal.ReferenceQueueConsumer;
import org.geotoolkit.storage.StorageEvent;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.logging.Logging;

public interface StorageListener<S extends StorageEvent, C extends StorageEvent>
extends EventListener {
    public static final Logger LOGGER = Logging.getLogger(StorageListener.class);

    public void structureChanged(S var1);

    public void contentChanged(C var1);

    public static final class Weak
    extends WeakReference<StorageListener>
    implements StorageListener,
    Disposable {
        private static final String ERROR_MSG = "Potential memory leak in StorageListener, could not remove listener because source object does not have a removeStorageListener method. Source object is : {0}";
        private final Collection<Object> sources = new ArrayList<Object>(1);

        public Weak(StorageListener ref) {
            this(null, ref);
        }

        public Weak(Object source, StorageListener ref) {
            super(ref, ReferenceQueueConsumer.DEFAULT.queue);
            this.registerSource(source);
        }

        public synchronized void registerSource(Object source) {
            if (source != null) {
                this.sources.add(source);
                try {
                    Method method = source.getClass().getMethod("addStorageListener", StorageListener.class);
                    method.invoke(source, this);
                }
                catch (IllegalAccessException ex) {
                    LOGGER.log(Level.WARNING, ERROR_MSG, source);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.log(Level.WARNING, ERROR_MSG, source);
                }
                catch (InvocationTargetException ex) {
                    LOGGER.log(Level.WARNING, ERROR_MSG, source);
                }
                catch (NoSuchMethodException ex) {
                    LOGGER.log(Level.WARNING, ERROR_MSG, source);
                }
                catch (SecurityException ex) {
                    LOGGER.log(Level.WARNING, ERROR_MSG, source);
                }
            }
        }

        public synchronized void unregisterSource(Object source) {
            this.sources.remove(source);
            this.remove(source);
        }

        public synchronized void unregisterAll() {
            for (Object mc : this.sources.toArray(new Object[this.sources.size()])) {
                this.unregisterSource(mc);
            }
        }

        private synchronized void remove(Object source) {
            try {
                Method method = source.getClass().getMethod("removeStorageListener", StorageListener.class);
                method.invoke(source, this);
            }
            catch (IllegalAccessException ex) {
                LOGGER.log(Level.WARNING, ERROR_MSG, source);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.WARNING, ERROR_MSG, source);
            }
            catch (InvocationTargetException ex) {
                LOGGER.log(Level.WARNING, ERROR_MSG, source);
            }
            catch (NoSuchMethodException ex) {
                LOGGER.log(Level.WARNING, ERROR_MSG, source);
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.WARNING, ERROR_MSG, source);
            }
        }

        public synchronized void dispose() {
            for (Object source : this.sources) {
                this.remove(source);
            }
            this.sources.clear();
        }

        public void structureChanged(StorageEvent event) {
            StorageListener listener = (StorageListener)this.get();
            if (listener != null) {
                listener.structureChanged(event);
            }
        }

        public void contentChanged(StorageEvent event) {
            StorageListener listener = (StorageListener)this.get();
            if (listener != null) {
                listener.contentChanged(event);
            }
        }
    }
}

