/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.distribution;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="MD_StandardOrderProcess_Type", propOrder={"fees", "plannedAvailableDateTime", "orderingInstructions", "turnaround"})
@XmlRootElement(name="MD_StandardOrderProcess")
public class DefaultStandardOrderProcess
extends MetadataEntity
implements StandardOrderProcess {
    private static final long serialVersionUID = -6503378937452728631L;
    private InternationalString fees;
    private long plannedAvailableDateTime;
    private InternationalString orderingInstructions;
    private InternationalString turnaround;

    public DefaultStandardOrderProcess() {
        this.plannedAvailableDateTime = Long.MIN_VALUE;
    }

    public DefaultStandardOrderProcess(StandardOrderProcess standardOrderProcess) {
        super(standardOrderProcess);
        if (standardOrderProcess != null && this.plannedAvailableDateTime == 0L && standardOrderProcess.getPlannedAvailableDateTime() == null) {
            this.plannedAvailableDateTime = Long.MIN_VALUE;
        }
    }

    public static DefaultStandardOrderProcess castOrCopy(StandardOrderProcess standardOrderProcess) {
        return standardOrderProcess == null || standardOrderProcess instanceof DefaultStandardOrderProcess ? (DefaultStandardOrderProcess)standardOrderProcess : new DefaultStandardOrderProcess(standardOrderProcess);
    }

    @Override
    @XmlElement(name="fees")
    public synchronized InternationalString getFees() {
        return this.fees;
    }

    public synchronized void setFees(InternationalString internationalString) {
        this.checkWritePermission();
        this.fees = internationalString;
    }

    @Override
    @XmlElement(name="plannedAvailableDateTime")
    public synchronized Date getPlannedAvailableDateTime() {
        return this.plannedAvailableDateTime != Long.MIN_VALUE ? new Date(this.plannedAvailableDateTime) : null;
    }

    public synchronized void setPlannedAvailableDateTime(Date date) {
        this.checkWritePermission();
        this.plannedAvailableDateTime = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @Override
    @XmlElement(name="orderingInstructions")
    public synchronized InternationalString getOrderingInstructions() {
        return this.orderingInstructions;
    }

    public synchronized void setOrderingInstructions(InternationalString internationalString) {
        this.checkWritePermission();
        this.orderingInstructions = internationalString;
    }

    @Override
    @XmlElement(name="turnaround")
    public synchronized InternationalString getTurnaround() {
        return this.turnaround;
    }

    public synchronized void setTurnaround(InternationalString internationalString) {
        this.checkWritePermission();
        this.turnaround = internationalString;
    }
}

