/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.impl.io.JarStorageFactory;
import org.apache.derby.io.StorageFile;

class JarDBFile
extends InputStreamFile<JarStorageFactory> {
    JarDBFile(JarStorageFactory jarStorageFactory, String string) {
        super(jarStorageFactory, string);
    }

    JarDBFile(JarStorageFactory jarStorageFactory, String string, String string2) {
        super(jarStorageFactory, string, string2);
    }

    JarDBFile(JarDBFile jarDBFile, String string) {
        super(jarDBFile, string);
    }

    private JarDBFile(JarStorageFactory jarStorageFactory, String string, int n) {
        super(jarStorageFactory, string, n);
    }

    @Override
    public boolean exists() {
        return this.getEntry() != null;
    }

    private ZipEntry getEntry() {
        return ((JarStorageFactory)this.storageFactory).zipData.getEntry(this.path);
    }

    @Override
    StorageFile getParentDir(int n) {
        return new JarDBFile((JarStorageFactory)this.storageFactory, this.path, n);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        ZipEntry zipEntry = this.getEntry();
        if (zipEntry == null) {
            throw new FileNotFoundException(this.path);
        }
        try {
            return ((JarStorageFactory)this.storageFactory).zipData.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(this.path);
        }
    }

    @Override
    public String toString() {
        return this.path;
    }
}

