/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter.spatial;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.geomatics.SpatialOperator;
import org.opengis.cite.geomatics.TopologicalRelationships;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.geometry.Envelope;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntersectsTests
extends QueryFilterFixture {
    public static final String IMPL_SPATIAL_FILTER = "ImplementsSpatialFilter";
    private static final String INTERSECTS_OP = "Intersects";
    private Map<QName, List<XSElementDeclaration>> allGeomProperties;
    private Set<QName> geomOperands;
    private static final String XSLT_ENV2POLYGON = "/org/opengis/cite/iso19142/util/bbox2polygon.xsl";

    @BeforeTest
    public void implementsSpatialFilter(ITestContext testContext) {
        NodeList result;
        this.wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        String xpath = String.format("//fes:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]", IMPL_SPATIAL_FILTER);
        try {
            result = XMLUtils.evaluateXPath(this.wfsMetadata, xpath, null);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        if (result.getLength() == 0) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", IMPL_SPATIAL_FILTER));
        }
    }

    @BeforeClass
    public void findAllGeometryProperties() {
        XSTypeDefinition geomBaseType = this.getModel().getTypeDefinition("AbstractGeometryType", "http://www.opengis.net/gml/3.2");
        this.allGeomProperties = new HashMap<QName, List<XSElementDeclaration>>();
        for (QName featureType : this.featureTypes) {
            List<XSElementDeclaration> geomProps = AppSchemaUtils.getFeaturePropertiesByType(this.getModel(), featureType, geomBaseType);
            if (geomProps.isEmpty()) continue;
            this.allGeomProperties.put(featureType, geomProps);
        }
    }

    @BeforeClass
    public void implementsIntersectsOp() {
        Map<SpatialOperator, Set<QName>> capabilities = ServiceMetadataUtils.getSpatialCapabilities(this.wfsMetadata);
        if (!capabilities.containsKey(SpatialOperator.INTERSECTS)) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", SpatialOperator.INTERSECTS));
        }
        this.geomOperands = capabilities.get(SpatialOperator.INTERSECTS);
    }

    @Test(description="See OGC 09-026r2, A.8", dataProvider="protocol-featureType")
    public void intersectsPolygon(ProtocolBinding binding, QName featureType) throws XPathExpressionException {
        if (!this.allGeomProperties.keySet().contains(featureType)) {
            throw new SkipException("Feature type has no geometry properties: " + featureType);
        }
        QName gmlPolygon = new QName("http://www.opengis.net/gml/3.2", "Polygon");
        if (!this.geomOperands.contains(gmlPolygon)) {
            throw new SkipException("Unsupported geometry operand: " + gmlPolygon);
        }
        Envelope extent = this.dataSampler.getSpatialExtent(this.getModel(), featureType);
        if (extent == null) {
            throw new SkipException("Could not create envelope out of sampled features for feature type: " + featureType);
        }
        Document gmlEnv = null;
        try {
            gmlEnv = Extents.envelopeAsGML((Envelope)extent);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create envelope for feature type: " + featureType, e);
        }
        Element gmlPolygonElem = XMLUtils.transform(new StreamSource(this.getClass().getResourceAsStream(XSLT_ENV2POLYGON)), gmlEnv, null).getDocumentElement();
        List<XSElementDeclaration> geomProps = this.allGeomProperties.get(featureType);
        Iterator<XSElementDeclaration> itr = geomProps.iterator();
        XSElementDeclaration geomProperty = null;
        XSElementDeclaration value = null;
        while (itr.hasNext() && (value = AppSchemaUtils.getComplexPropertyValue(geomProperty = itr.next())).getName().contains("Point")) {
        }
        if (value.getName().contains("Point")) {
            throw new SkipException("Intersects tests are not supported for point geometry types.");
        }
        this.reqEntity = this.buildGetFeatureRequest(featureType, INTERSECTS_OP, geomProperty, gmlPolygonElem);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList geomNodes = this.findGeometryPropertyValues(featureType, geomProperty);
        if (geomNodes.getLength() == 0) {
            TestSuiteLogger.log(Level.INFO, String.format("intersectsPolygon: No values found for geometry property %s (in %s)", geomProperty, featureType));
        }
        for (int i = 0; i < geomNodes.getLength(); ++i) {
            Node geom = geomNodes.item(i);
            if (GmlUtils.checkForAbstractSurfacePatchTypes((Node)geom)) {
                geom = GmlUtils.handleAbstractSurfacePatch((Node)geom);
            }
            boolean intersects = TopologicalRelationships.isSpatiallyRelated((SpatialOperator)SpatialOperator.INTERSECTS, (Node)gmlPolygonElem, (Node)geom);
            Assert.assertTrue((boolean)intersects, (String)ErrorMessage.format("PredicateNotSatisfied", INTERSECTS_OP, XMLUtils.writeNodeToString(gmlPolygonElem), XMLUtils.writeNodeToString(geom)));
        }
    }

    @Test(description="See OGC 09-026r2, A.8", dataProvider="protocol-featureType")
    public void intersectsCurve(ProtocolBinding binding, QName featureType) throws XPathExpressionException {
        if (!this.allGeomProperties.keySet().contains(featureType)) {
            throw new SkipException("Feature type has no geometry properties: " + featureType);
        }
        QName gmlCurve = new QName("http://www.opengis.net/gml/3.2", "LineString");
        if (!this.geomOperands.contains(gmlCurve) && !this.geomOperands.contains(gmlCurve = new QName("http://www.opengis.net/gml/3.2", "Curve"))) {
            throw new SkipException("Unsupported geometry operands: gml:LineString, gml:Curve");
        }
        Envelope extent = this.dataSampler.getSpatialExtent(this.getModel(), featureType);
        if (extent == null) {
            throw new SkipException("Could not create envelope out of sampled features for feature type: " + featureType);
        }
        Document gmlEnv = null;
        try {
            gmlEnv = Extents.envelopeAsGML((Envelope)extent);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create envelope for feature type: " + featureType, e);
        }
        Element gmlCurveElem = XMLUtils.transform(new StreamSource(this.getClass().getResourceAsStream("envelopeTocurve.xsl")), gmlEnv, Collections.singletonMap("curveType", gmlCurve.getLocalPart())).getDocumentElement();
        List<XSElementDeclaration> geomProps = this.allGeomProperties.get(featureType);
        Iterator<XSElementDeclaration> itr = geomProps.iterator();
        XSElementDeclaration geomProperty = null;
        XSElementDeclaration value = null;
        while (itr.hasNext() && (value = AppSchemaUtils.getComplexPropertyValue(geomProperty = itr.next())).getName().contains("Point")) {
        }
        if (value.getName().contains("Point")) {
            throw new SkipException("Intersects tests are not supported for point geometry types.");
        }
        this.reqEntity = this.buildGetFeatureRequest(featureType, INTERSECTS_OP, geomProperty, gmlCurveElem);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList geomNodes = this.findGeometryPropertyValues(featureType, geomProperty);
        if (geomNodes.getLength() == 0) {
            TestSuiteLogger.log(Level.INFO, String.format("intersectsCurve: No values found for geometry property %s (in %s)", geomProperty, featureType));
        }
        for (int i = 0; i < geomNodes.getLength(); ++i) {
            Node geom = geomNodes.item(i);
            if (GmlUtils.checkForAbstractSurfacePatchTypes((Node)geom)) {
                geom = GmlUtils.handleAbstractSurfacePatch((Node)geom);
            }
            boolean intersects = TopologicalRelationships.isSpatiallyRelated((SpatialOperator)SpatialOperator.INTERSECTS, (Node)gmlCurveElem, (Node)geom);
            Assert.assertTrue((boolean)intersects, (String)ErrorMessage.format("PredicateNotSatisfied", INTERSECTS_OP, XMLUtils.writeNodeToString(gmlCurveElem), XMLUtils.writeNodeToString(geom)));
        }
    }

    Document buildGetFeatureRequest(QName featureType, String operator, XSElementDeclaration propertyDecl, Element literal) {
        Document entity = WFSMessage.createRequestEntity("GetFeature-Minimal", this.wfsVersion);
        WFSMessage.appendSimpleQuery(entity, featureType);
        Element valueRef = WFSMessage.createValueReference(propertyDecl);
        this.addSpatialPredicate(entity, operator, literal, valueRef);
        return entity;
    }

    void addSpatialPredicate(Document request, String spatialOp, Element gmlGeom, Element valueRef) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        if (null == queryElem) {
            throw new IllegalArgumentException("No Query element found in GetFeature request entity.");
        }
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:" + spatialOp);
        filter.appendChild(predicate);
        if (null != valueRef) {
            predicate.appendChild(request.importNode(valueRef, true));
        }
        predicate.appendChild(request.importNode(gmlGeom, true));
    }

    private NodeList findGeometryPropertyValues(QName featureType, XSElementDeclaration geomProperty) throws XPathExpressionException {
        String featureTypeNs = featureType.getNamespaceURI();
        String featureTypePrefix = this.getFeatureTypePrefix(featureType);
        String geomPropNs = geomProperty.getNamespace();
        String geomPropPrefix = this.getGeomPropPrefix(featureTypeNs, featureTypePrefix, geomPropNs);
        String xpath = String.format("//%s:%s/%s:%s/*", featureTypePrefix, featureType.getLocalPart(), geomPropPrefix, geomProperty.getName());
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(featureTypeNs, featureTypePrefix);
        if (!geomPropPrefix.equals(featureTypePrefix)) {
            nsBindings.put(geomPropNs, geomPropPrefix);
        }
        return XMLUtils.evaluateXPath(this.rspEntity, xpath, nsBindings);
    }

    private String getFeatureTypePrefix(QName featureType) {
        String prefix = featureType.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            return prefix;
        }
        return "t1";
    }

    private String getGeomPropPrefix(String featureTypeNs, String featureTypePrefix, String geomPropNs) {
        if (geomPropNs != null && geomPropNs.equals(featureTypeNs) || geomPropNs == null && featureTypeNs == null) {
            return featureTypePrefix;
        }
        return "t2";
    }
}

