/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import java.util.UUID;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.SpecializedIdentifier;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.Identifier;

final class ObjectReference {
    UUID uuid;
    XLink xlink;

    ObjectReference() {
    }

    ObjectReference(UUID uuid, XLink link) {
        this.uuid = uuid;
        this.xlink = link;
    }

    final <T> T resolve(Context context, Class<T> type, T metadata) {
        if (metadata == null) {
            ReferenceResolver resolver = Context.resolver(context);
            if (!(this.uuid != null && (metadata = resolver.resolve((MarshalContext)context, type, this.uuid)) != null || this.xlink != null && (metadata = resolver.resolve((MarshalContext)context, type, this.xlink)) != null)) {
                int count = 0;
                Identifier[] identifiers = new SpecializedIdentifier[2];
                if (this.uuid != null) {
                    identifiers[count++] = new SpecializedIdentifier<UUID>(IdentifierSpace.UUID, this.uuid);
                }
                if (this.xlink != null) {
                    identifiers[count++] = new SpecializedIdentifier<XLink>(IdentifierSpace.XLINK, this.xlink);
                }
                identifiers = ArraysExt.resize(identifiers, count);
                metadata = resolver.newIdentifiedObject(context, type, identifiers);
            }
        } else if (metadata instanceof IdentifiedObject) {
            IdentifierMap map = ((IdentifiedObject)metadata).getIdentifierMap();
            ObjectReference.putInto(context, map, IdentifierSpace.UUID, this.uuid);
            ObjectReference.putInto(context, map, IdentifierSpace.XLINK, this.xlink);
        }
        return metadata;
    }

    private static <T> void putInto(Context context, IdentifierMap map, IdentifierSpace<T> authority, T value) {
        T previous;
        if (value != null && (previous = map.putSpecialized(authority, value)) != null && !previous.equals(value)) {
            Context.warningOccured(context, IdentifierMap.class, "putSpecialized", Errors.class, (short)67, authority.getName(), value);
            map.putSpecialized(authority, previous);
        }
    }
}

