/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Map;
import org.apache.sis.internal.jaxb.gco.GO_GenericName;
import org.apache.sis.internal.jaxb.metadata.replace.Parameter;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.quality.DefaultMeasureDescription;
import org.apache.sis.util.Classes;
import org.apache.sis.util.iso.Names;
import org.opengis.coverage.Coverage;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.quality.Description;
import org.opengis.metadata.quality.ValueStructure;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.InternationalString;
import org.opengis.util.TypeName;

@XmlType(name="DQM_Parameter_Type", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0", propOrder={"code", "definition", "description", "valueType", "valueStructure"})
@XmlRootElement(name="DQM_Parameter", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0")
public final class QualityParameter
extends Parameter {
    @XmlElement(name="name", required=true)
    String code;
    @XmlElement(required=true)
    InternationalString definition;
    @XmlElement
    Description description;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=GO_GenericName.class)
    TypeName valueType;
    @XmlElement
    ValueStructure valueStructure;

    QualityParameter() {
    }

    private QualityParameter(ParameterDescriptor<?> parameter) {
        super(parameter);
        InternationalString text;
        Identifier id = parameter.getName();
        if (id != null) {
            this.code = id.getCode();
            this.definition = id.getDescription();
        }
        if ((text = parameter.getDescription()) != null) {
            this.description = new DefaultMeasureDescription((CharSequence)text);
        }
        this.valueType = parameter.getValueType();
        this.valueStructure = ValueStructure.valueOf((Class)parameter.getValueClass()).orElse(null);
    }

    public static QualityParameter castOrCopy(ParameterDescriptor<?> parameter) {
        if (parameter == null || parameter instanceof QualityParameter) {
            return (QualityParameter)parameter;
        }
        return new QualityParameter(parameter);
    }

    @Override
    public synchronized Identifier getName() {
        if (this.name == null && this.code != null) {
            DefaultIdentifier id = new DefaultIdentifier(this.code);
            id.setDescription(this.definition);
            id.transitionTo(ModifiableMetadata.State.FINAL);
            this.name = id;
        }
        return this.name;
    }

    public InternationalString getDescription() {
        Description description = this.description;
        return description != null ? description.getTextDescription() : null;
    }

    public Class<?> getValueClass() {
        Class type = super.getValueClass();
        if (type == null) {
            ValueStructure s = this.valueStructure;
            type = s != null ? (Class)s.toJavaType().orElse(null) : Names.toClass(this.valueType);
        }
        return type;
    }

    @Override
    public TypeName getValueType() {
        return this.valueType;
    }

    public static TypeName getValueType(Class<?> valueClass) {
        if (valueClass.isArray()) {
            valueClass = valueClass.getComponentType();
        } else if (Iterable.class.isAssignableFrom(valueClass) || Map.class.isAssignableFrom(valueClass)) {
            valueClass = Classes.boundOfParameterizedDeclaration(valueClass);
        } else if (Matrix.class.isAssignableFrom(valueClass) || Coverage.class.isAssignableFrom(valueClass)) {
            valueClass = Double.class;
        }
        return Names.createTypeName(valueClass);
    }
}

