/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.metadata.sql.MetadataSource;

final class IdentifierGenerator
implements AutoCloseable {
    static final char SEPARATOR = '-';
    private final PreparedStatement statement;
    private final SQLBuilder buffer;
    private int parseAt;
    private int maximalSequenceNumber;
    private int freeSequenceNumber;

    IdentifierGenerator(MetadataSource source, String schema, String table, String column, SQLBuilder buffer) throws SQLException {
        assert (Thread.holdsLock(source));
        this.buffer = buffer;
        buffer.clear().append("SELECT DISTINCT ").appendIdentifier(column).append(" FROM ").appendIdentifier(schema, table).append(" WHERE ").appendIdentifier(column).append(" LIKE ? ORDER BY ").appendIdentifier(column);
        this.statement = source.connection().prepareStatement(buffer.toString());
    }

    final String identifier(String proposal) throws SQLException {
        this.statement.setString(1, this.buffer.clear().appendWildcardEscaped((String)proposal).append('%').toString());
        try (ResultSet rs = this.statement.executeQuery();){
            String current;
            if (rs.next() && (current = rs.getString(1)).equals(proposal)) {
                int n;
                this.parseAt = ((String)proposal).length() + 1;
                this.freeSequenceNumber = 0;
                this.maximalSequenceNumber = 0;
                int expected = 0;
                block5: while (rs.next()) {
                    int c;
                    current = rs.getString(1);
                    assert (current.startsWith((String)proposal)) : current;
                    while (current.length() > this.parseAt && (c = current.codePointBefore(this.parseAt)) >= 45) {
                        String prefix;
                        if (c > 45) break block5;
                        c = current.codePointAt(this.parseAt);
                        if (c < 49) continue block5;
                        if (c <= 57 && (current = this.search(rs, current, prefix = current.substring(0, this.parseAt), ++expected)) != null) continue;
                        break block5;
                    }
                }
                if ((n = this.freeSequenceNumber) == 0) {
                    n = this.maximalSequenceNumber + 1;
                }
                proposal = (String)proposal + "-" + n;
            }
        }
        return proposal;
    }

    private String search(ResultSet rs, String current, String prefix, int expected) throws SQLException {
        assert (current.startsWith(prefix));
        assert (current.length() > prefix.length()) : current;
        do {
            int n;
            try {
                n = Integer.parseInt(current.substring(this.parseAt));
            }
            catch (NumberFormatException e) {
                if (rs.next()) {
                    current = rs.getString(1);
                    continue;
                }
                return null;
            }
            if (n > expected) {
                this.freeSequenceNumber = expected;
                return null;
            }
            if (n != expected) {
                throw new SQLNonTransientException(current);
            }
            ++expected;
            if (n > this.maximalSequenceNumber) {
                this.maximalSequenceNumber = n;
            }
            if (!rs.next()) {
                return null;
            }
            String next = current.substring(0, prefix.length() + 1);
            current = rs.getString(1);
            if (!current.startsWith(next) || (current = this.search(rs, current, next, n * 10)) != null) continue;
            return null;
        } while (current.startsWith(prefix));
        return current;
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }
}

