/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts;

import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.referencing.CRS;
import org.geotoolkit.geometry.isoonjts.GeometryUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.JTSPositionFactory;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.aggregate.AbstractJTSAggregate;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.aggregate.JTSMultiCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.aggregate.JTSMultiPoint;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.aggregate.JTSMultiPrimitive;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.aggregate.JTSMultiSurface;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSGeometryFactory;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSPolygon;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPrimitiveFactory;
import org.geotoolkit.geometry.jts.SRIDGenerator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.FactoryException;

public final class JTSUtils {
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    private JTSUtils() {
    }

    public static Geometry toISO(org.locationtech.jts.geom.Geometry jtsGeom, CoordinateReferenceSystem crs) {
        int srid;
        if (jtsGeom == null) {
            return null;
        }
        if (crs == null && (srid = jtsGeom.getSRID()) != 0) {
            String strCRS = SRIDGenerator.toSRS(srid, SRIDGenerator.Version.V1);
            try {
                crs = CRS.forCode((String)strCRS);
            }
            catch (FactoryException ex) {
                Logger.getLogger("org.geotoolkit.geometry.isoonjts").log(Level.SEVERE, null, ex);
            }
        }
        JTSPrimitiveFactory pf = new JTSPrimitiveFactory(crs);
        JTSGeometryFactory gf = new JTSGeometryFactory(crs);
        if (jtsGeom instanceof Point) {
            Point candidate = (Point)jtsGeom;
            DirectPosition dp = JTSUtils.pointToDirectPosition(candidate, crs);
            return pf.createPoint((Position)dp);
        }
        if (jtsGeom instanceof org.locationtech.jts.geom.LineString) {
            org.locationtech.jts.geom.LineString candidate = (org.locationtech.jts.geom.LineString)jtsGeom;
            LineString ls = gf.createLineString(new ArrayList());
            PointArray pointList = ls.getControlPoints();
            int n = candidate.getNumPoints();
            for (int i = 0; i < n; ++i) {
                pointList.add((Object)JTSUtils.coordinateToDirectPosition(candidate.getCoordinateN(i), crs));
            }
            return (JTSLineString)ls;
        }
        if (jtsGeom instanceof LinearRing) {
            return JTSUtils.linearRingToRing((LinearRing)jtsGeom, crs);
        }
        if (jtsGeom instanceof Polygon) {
            Polygon jtsPolygon = (Polygon)jtsGeom;
            Ring externalRing = JTSUtils.linearRingToRing(jtsPolygon.getExteriorRing(), crs);
            ArrayList<Ring> internalRings = new ArrayList<Ring>();
            int n = jtsPolygon.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                internalRings.add(JTSUtils.linearRingToRing(jtsPolygon.getInteriorRingN(i), crs));
            }
            SurfaceBoundary boundary = pf.createSurfaceBoundary(externalRing, internalRings);
            org.opengis.geometry.coordinate.Polygon polygon = gf.createPolygon(boundary);
            return (JTSPolygon)polygon;
        }
        if (jtsGeom instanceof GeometryCollection) {
            AbstractJTSAggregate result;
            GeometryCollection jtsCollection = (GeometryCollection)jtsGeom;
            boolean multiPoint = jtsGeom instanceof MultiPoint;
            boolean multiCurve = jtsGeom instanceof MultiLineString;
            boolean multiSurface = jtsGeom instanceof MultiPolygon;
            if (!(multiPoint || multiCurve || multiSurface || jtsGeom.isEmpty())) {
                multiSurface = true;
                multiCurve = true;
                multiPoint = true;
                int n = jtsCollection.getNumGeometries();
                for (int i = 0; i < n && (multiPoint || multiCurve || multiSurface); ++i) {
                    if (!(jtsCollection.getGeometryN(i) instanceof Point)) {
                        multiPoint = false;
                    }
                    if (!(jtsCollection.getGeometryN(i) instanceof org.locationtech.jts.geom.LineString)) {
                        multiCurve = false;
                    }
                    if (jtsCollection.getGeometryN(i) instanceof Polygon) continue;
                    multiSurface = false;
                }
            }
            if (multiPoint) {
                result = new JTSMultiPoint(crs);
                Set elements = result.getElements();
                int n = jtsCollection.getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    elements.add(JTSUtils.toISO(jtsCollection.getGeometryN(i), crs));
                }
            } else if (multiCurve) {
                result = new JTSMultiCurve(crs);
                Set elements = result.getElements();
                int n = jtsCollection.getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    Geometry element = JTSUtils.toISO(jtsCollection.getGeometryN(i), crs);
                    if (element instanceof JTSLineString) {
                        JTSCurve curve = new JTSCurve(crs);
                        curve.getSegments().add((CurveSegment)((JTSLineString)element));
                        element = curve;
                    }
                    elements.add(element);
                }
            } else if (multiSurface) {
                result = new JTSMultiSurface(crs);
                Set elements = result.getElements();
                int n = jtsCollection.getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    elements.add(JTSUtils.toISO(jtsCollection.getGeometryN(i), crs));
                }
            } else {
                result = new JTSMultiPrimitive();
                Set elements = result.getElements();
                int n = jtsCollection.getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    elements.add(JTSUtils.toISO(jtsCollection.getGeometryN(i), crs));
                }
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + jtsGeom.getGeometryType());
    }

    public static Coordinate directPositionToCoordinate(DirectPosition dp) {
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        int d = dp.getDimension();
        if (d >= 1) {
            x = dp.getOrdinate(0);
            if (d >= 2) {
                y = dp.getOrdinate(1);
                if (d >= 3) {
                    z = dp.getOrdinate(2);
                }
            }
        }
        return new Coordinate(x, y, z);
    }

    public static void directPositionToCoordinate(DirectPosition dp, Coordinate result) {
        int d = dp.getDimension();
        if (d >= 1) {
            result.x = dp.getOrdinate(0);
            if (d >= 2) {
                result.y = dp.getOrdinate(1);
                result.z = d >= 3 ? dp.getOrdinate(3) : Double.NaN;
            } else {
                result.z = Double.NaN;
                result.y = Double.NaN;
            }
        } else {
            result.z = Double.NaN;
            result.y = Double.NaN;
            result.x = Double.NaN;
        }
    }

    public static Point directPositionToPoint(DirectPosition dp) {
        return GEOMETRY_FACTORY.createPoint(JTSUtils.directPositionToCoordinate(dp));
    }

    public static DirectPosition coordinateToDirectPosition(Coordinate c, CoordinateReferenceSystem crs) {
        double[] vertices;
        JTSPositionFactory pf = new JTSPositionFactory(crs);
        if (crs == null) {
            vertices = new double[]{c.x, c.y, c.z};
        } else {
            vertices = new double[crs.getCoordinateSystem().getDimension()];
            if (vertices.length > 0) {
                vertices[0] = c.x;
                if (vertices.length > 1) {
                    vertices[1] = c.y;
                    if (vertices.length > 2) {
                        vertices[2] = c.z;
                    }
                }
            }
        }
        return pf.createDirectPosition(vertices);
    }

    public static void coordinateToDirectPosition(Coordinate c, DirectPosition result) {
        CoordinateReferenceSystem crs = result.getCoordinateReferenceSystem();
        int d = crs != null ? crs.getCoordinateSystem().getDimension() : 2;
        CoordinateSystem cs = crs.getCoordinateSystem();
        if (d >= 1) {
            int xIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.EAST);
            result.setOrdinate(xIndex, c.x);
            if (d >= 2) {
                int yIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.NORTH);
                result.setOrdinate(yIndex, c.y);
                if (d >= 3) {
                    int zIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.UP);
                    result.setOrdinate(zIndex, c.z);
                    if (d > 3) {
                        for (int i = 3; i < d; ++i) {
                            result.setOrdinate(i, 0.0);
                        }
                    }
                }
            }
        }
    }

    public static DirectPosition pointToDirectPosition(Point p, CoordinateReferenceSystem crs) {
        return JTSUtils.coordinateToDirectPosition(p.getCoordinate(), crs);
    }

    public static Ring linearRingToRing(org.locationtech.jts.geom.LineString jtsLinearRing, CoordinateReferenceSystem crs) {
        int numPoints = jtsLinearRing.getNumPoints();
        if (numPoints != 0 && !jtsLinearRing.getCoordinateN(0).equals(jtsLinearRing.getCoordinateN(numPoints - 1))) {
            throw new IllegalArgumentException("LineString must be a ring");
        }
        JTSPrimitiveFactory pf = new JTSPrimitiveFactory(crs);
        JTSGeometryFactory gf = new JTSGeometryFactory(crs);
        LineString ls = gf.createLineString(new ArrayList());
        PointArray pointList = ls.getControlPoints();
        for (int i = 0; i < numPoints; ++i) {
            pointList.add(JTSUtils.coordinateToDirectPosition(jtsLinearRing.getCoordinateN(i), crs));
        }
        Curve curve = pf.createCurve(new ArrayList());
        curve.getSegments().add(ls);
        Ring result = pf.createRing(new ArrayList());
        result.getGenerators().add(curve);
        return result;
    }

    public static double distance(org.locationtech.jts.geom.Geometry g1, org.locationtech.jts.geom.Geometry g2) {
        if (g1 instanceof GeometryCollection) {
            double minDistance = Double.POSITIVE_INFINITY;
            GeometryCollection gc1 = (GeometryCollection)g1;
            int n = gc1.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                double d = JTSUtils.distance(gc1.getGeometryN(i), g2);
                if (!(d < minDistance)) continue;
                minDistance = d;
            }
            return minDistance;
        }
        if (g2 instanceof GeometryCollection) {
            double minDistance = Double.POSITIVE_INFINITY;
            GeometryCollection gc2 = (GeometryCollection)g2;
            int n = gc2.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                double d = JTSUtils.distance(g1, gc2.getGeometryN(i));
                if (!(d < minDistance)) continue;
                minDistance = d;
            }
            return minDistance;
        }
        return g1.distance(g2);
    }

    public static org.locationtech.jts.geom.Geometry union(org.locationtech.jts.geom.Geometry g1, org.locationtech.jts.geom.Geometry g2) {
        return null;
    }

    public static org.locationtech.jts.geom.Geometry intersection(org.locationtech.jts.geom.Geometry g1, org.locationtech.jts.geom.Geometry g2) {
        return null;
    }

    public static org.locationtech.jts.geom.Geometry difference(org.locationtech.jts.geom.Geometry g1, org.locationtech.jts.geom.Geometry g2) {
        return null;
    }

    public static org.locationtech.jts.geom.Geometry symmetricDifference(org.locationtech.jts.geom.Geometry g1, org.locationtech.jts.geom.Geometry g2) {
        return null;
    }

    public static boolean contains(org.locationtech.jts.geom.Geometry g1, org.locationtech.jts.geom.Geometry g2) {
        return false;
    }

    public static boolean equals(org.locationtech.jts.geom.Geometry g1, org.locationtech.jts.geom.Geometry g2) {
        return false;
    }

    public static boolean intersects(org.locationtech.jts.geom.Geometry g1, org.locationtech.jts.geom.Geometry g2) {
        if (g1 instanceof GeometryCollection) {
            GeometryCollection gc1 = (GeometryCollection)g1;
            int n = gc1.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                org.locationtech.jts.geom.Geometry g = gc1.getGeometryN(i);
                if (!JTSUtils.intersects(g, g2)) continue;
                return true;
            }
            return false;
        }
        if (g2 instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)g2;
            int n = gc2.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                org.locationtech.jts.geom.Geometry g = gc2.getGeometryN(i);
                if (!JTSUtils.intersects(g1, g)) continue;
                return true;
            }
            return false;
        }
        return g1.intersects(g2);
    }

    public static org.locationtech.jts.geom.Geometry getEnvelopeGeometry(Envelope envelope) {
        DirectPosition topCorner = envelope.getUpperCorner();
        DirectPosition botCorner = envelope.getLowerCorner();
        GeneralDirectPosition topLeft = new GeneralDirectPosition(topCorner);
        GeneralDirectPosition botRight = new GeneralDirectPosition(botCorner);
        topLeft.setOrdinate(1, botCorner.getOrdinate(1));
        botRight.setOrdinate(1, topCorner.getOrdinate(1));
        Coordinate jtsTopRight = JTSUtils.directPositionToCoordinate(topCorner);
        Coordinate jtsTopLeft = JTSUtils.directPositionToCoordinate((DirectPosition)topLeft);
        Coordinate jtsBotLeft = JTSUtils.directPositionToCoordinate(botCorner);
        Coordinate jtsBotRight = JTSUtils.directPositionToCoordinate((DirectPosition)botRight);
        org.locationtech.jts.geom.Geometry jtsEnv = GEOMETRY_FACTORY.createLineString(new Coordinate[]{jtsTopLeft, jtsTopRight, jtsBotRight, jtsBotLeft, jtsTopLeft}).getEnvelope();
        return jtsEnv;
    }
}

