/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSRing;
import org.geotoolkit.internal.jaxb.CoordinatesType;
import org.geotoolkit.internal.jaxb.PosListType;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.Primitive;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class LinearRingPosListType {
    @XmlElement(namespace="http://www.opengis.net/gml")
    private PosListType posList;
    @XmlElement(namespace="http://www.opengis.net/gml")
    private CoordinatesType coordinates;

    public LinearRingPosListType() {
    }

    public LinearRingPosListType(List<Double> value) {
        this.posList = new PosListType(value);
    }

    public LinearRingPosListType(JTSRing ring) {
        if (ring.getElements().size() == 1) {
            Primitive curveObj = ring.getElements().iterator().next();
            if (curveObj instanceof Curve) {
                Curve curve = (Curve)curveObj;
                ArrayList<Double> value = new ArrayList<Double>();
                for (CurveSegment cv : curve.getSegments()) {
                    JTSLineString line = (JTSLineString)cv;
                    for (Position p : line.getPositions()) {
                        for (int i = 0; i < p.getDirectPosition().getDimension(); ++i) {
                            value.add(p.getDirectPosition().getOrdinate(i));
                        }
                    }
                }
                this.posList = new PosListType(value);
            }
        } else {
            throw new IllegalArgumentException("the ring is not linear");
        }
    }

    public JTSRing getJTSRing() {
        List<Double> values = this.posList != null ? this.posList.getValue() : (this.coordinates != null ? this.coordinates.getValues() : new ArrayList<Double>());
        JTSLineString line = new JTSLineString();
        for (int i = 0; i < values.size() - 1; i += 2) {
            double x = values.get(i);
            double y = values.get(i + 1);
            GeneralDirectPosition pos = new GeneralDirectPosition(new double[]{x, y});
            line.getControlPoints().add((Object)pos);
        }
        JTSCurve curve = new JTSCurve();
        curve.getSegments().add((CurveSegment)line);
        JTSRing ring = new JTSRing();
        ring.getElements().add((Primitive)curve);
        return ring;
    }

    public PosListType getPosList() {
        return this.posList;
    }

    public void setPosList(PosListType posList) {
        this.posList = posList;
    }

    public CoordinatesType getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(CoordinatesType coordinates) {
        this.coordinates = coordinates;
    }
}

