/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.Namespaces;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class BasicGetFeatureTests
extends BaseFixture {
    private static final QName FEATURE_COLL = new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection");
    Validator hintsValidator;

    @BeforeClass
    public void buildValidator() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = factory.newSchema();
            this.hintsValidator = schema.newValidator();
            LSResourceResolver resolver = ValidationUtils.createSchemaResolver(Namespaces.XSD);
            this.hintsValidator.setResourceResolver(resolver);
        }
        catch (SAXException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator that heeds location hints.", e);
        }
    }

    @BeforeMethod
    public void buildRequestEntity() {
        this.reqEntity = WFSMessage.createRequestEntity("GetFeature-Minimal", this.wfsVersion);
        this.rspEntity = null;
    }

    @AfterMethod
    public void resetValidator() {
        this.hintsValidator.reset();
    }

    @Test(description="See ISO 19142: 11.2.2, 11.2.3", dataProvider="all-protocols-featureTypes")
    public void getFeaturesByType(ProtocolBinding binding, QName featureType) {
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        Response rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), FEATURE_COLL);
        ETSAssert.assertSchemaValid(this.hintsValidator, new DOMSource(this.rspEntity.getDocumentElement(), this.rspEntity.getDocumentURI()));
    }

    @Test(description="See OGC 09-025r2: 7.9.2.4.4")
    public void getFeatureInOtherCRS() {
        QName featureType;
        String otherCRSId = null;
        Iterator itr = this.featureTypes.iterator();
        do {
            FeatureTypeInfo typeInfo;
            if (!(typeInfo = (FeatureTypeInfo)this.featureInfo.get(featureType = (QName)itr.next())).isInstantiated() || typeInfo.getSupportedCRSIdentifiers().size() <= 1) continue;
            otherCRSId = typeInfo.getSupportedCRSIdentifiers().get(1);
            break;
        } while (itr.hasNext());
        if (null == otherCRSId) {
            throw new SkipException("No alternative (non-default) CRS supported for any feature type with data.");
        }
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        Element qry = (Element)this.reqEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        qry.setAttribute("srsName", otherCRSId);
        Response rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertSpatialReference(this.rspEntity, otherCRSId);
    }

    @Test(description="See OGC 09-025r2: A.2.22.1.4")
    public void getFeatureInUnsupportedCRS() {
        String crsId = this.wfsVersion.equals("2.0.0") ? "urn:ogc:def:crs:EPSG::32690" : "http://www.opengis.net/def/crs/EPSG/0/32690";
        QName featureType = this.getFeatureTypeWithInstanceData();
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        Element qry = (Element)this.reqEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        qry.setAttribute("srsName", crsId);
        Response rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertExceptionReport(this.rspEntity, "InvalidParameterValue", "SRSNAME");
    }

    void setFeatureAvailability(FeatureTypeInfo featureInfo, Document entity) {
        QName typeName = featureInfo.getTypeName();
        NodeList features = entity.getElementsByTagNameNS(typeName.getNamespaceURI(), typeName.getLocalPart());
        featureInfo.setInstantiated(features.getLength() > 0);
    }

    QName getFeatureTypeWithInstanceData() {
        FeatureTypeInfo typeInfo;
        Iterator itr = this.featureTypes.iterator();
        QName featureType = null;
        while (!(typeInfo = (FeatureTypeInfo)this.featureInfo.get(featureType = (QName)itr.next())).isInstantiated() && itr.hasNext()) {
        }
        return featureType;
    }
}

