/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyIsNullOperatorTests
extends QueryFilterFixture {
    @Test(description="See ISO 19143: 7.7.3.5", dataProvider="protocol-featureType")
    public void gmlNameIsNull(ProtocolBinding binding, QName featureType) {
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        QName gmlName = new QName("http://www.opengis.net/gml/3.2", "name", "gml");
        this.addPropertyIsNullPredicate(this.reqEntity, gmlName, false);
        Response rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(featureType.getNamespaceURI(), "tns");
        String xpath = String.format("not(//tns:%s[gml:name])", featureType.getLocalPart());
        ETSAssert.assertXPath(xpath, this.rspEntity, nsBindings);
    }

    @Test(description="See ISO 19143: 7.7.3.5, 7.10", dataProvider="protocol-featureType")
    public void propertyIsNotNull(ProtocolBinding binding, QName featureType) {
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        List<XSElementDeclaration> props = AppSchemaUtils.getAllFeatureProperties(this.getModel(), featureType);
        XSElementDeclaration lastProp = props.get(props.size() - 1);
        QName propName = new QName(lastProp.getNamespace(), lastProp.getName());
        this.addPropertyIsNullPredicate(this.reqEntity, propName, true);
        Response rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(featureType.getNamespaceURI(), "ns1");
        String nsPrefix = "ns1";
        if (!propName.getNamespaceURI().equals(featureType.getNamespaceURI())) {
            nsPrefix = "ns2";
            nsBindings.put(propName.getNamespaceURI(), nsPrefix);
        }
        String xpath = String.format("count(//ns1:%s[%s:%s]) = count(//wfs:member)", featureType.getLocalPart(), nsPrefix, propName.getLocalPart());
        ETSAssert.assertXPath(xpath, this.rspEntity, nsBindings);
    }

    void addPropertyIsNullPredicate(Document request, QName propertyName, boolean negate) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        if (null == propertyName) {
            throw new IllegalArgumentException("propertyName is required.");
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "PropertyIsNull");
        if (negate) {
            Element not = request.createElementNS("http://www.opengis.net/fes/2.0", "Not");
            filter.appendChild(not);
            not.appendChild(predicate);
        } else {
            filter.appendChild(predicate);
        }
        Element valueRef = request.createElementNS("http://www.opengis.net/fes/2.0", "ValueReference");
        predicate.appendChild(valueRef);
        String prefix = propertyName.getPrefix().length() > 0 ? propertyName.getPrefix() : "tns";
        String nsURI = request.lookupNamespaceURI(prefix);
        if (null == nsURI) {
            valueRef.setAttribute("xmlns:" + prefix, propertyName.getNamespaceURI());
        }
        valueRef.setTextContent(prefix + ":" + propertyName.getLocalPart());
    }
}

