/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class SimpleCapabilitiesTests
extends BaseFixture {
    private URI reqEndpointUsingGET;
    private Client client;

    @BeforeTest
    public void checkSuitePreconditions(ITestContext context) {
        Object failedPreconditions = context.getSuite().getAttribute(SuiteAttribute.FAILED_PRECONDITIONS.getName());
        if (null != failedPreconditions) {
            throw new SkipException("One or more test suite preconditions were not satisfied: " + failedPreconditions);
        }
    }

    @BeforeClass
    public void extractEndpoint(ITestContext testContext) {
        this.client = ClientBuilder.newClient();
        this.reqEndpointUsingGET = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", ProtocolBinding.GET);
    }

    @Test(description="See ISO 19142: 7.5")
    public void getCapabilities_missingServiceParam() {
        WebTarget target = this.client.target(this.reqEndpointUsingGET);
        target = target.queryParam("request", new Object[]{"GetCapabilities"});
        Response rsp = target.request(new String[]{"application/xml"}).get();
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        Object entity = rsp.getEntity();
        if (entity instanceof InputStream) {
            try {
                this.rspEntity = this.docBuilder.parse((InputStream)entity);
            }
            catch (IOException | SAXException e) {
                throw new AssertionError((Object)e.getMessage());
            }
        }
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("ExceptionReport.sch", "MissingParameterValuePhase");
        Result result = validator.validate((Source)new DOMSource(this.rspEntity));
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    @Test(description="See ISO 19142: 7.2")
    public void getFullCapabilities() {
        WebTarget target = this.client.target(this.reqEndpointUsingGET);
        target = target.queryParam("request", new Object[]{"GetCapabilities"});
        target = target.queryParam("service", new Object[]{"WFS"});
        Response rsp = target.request(new String[]{"application/xml"}).get();
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Object entity = rsp.getEntity();
        if (entity instanceof InputStream) {
            try {
                this.rspEntity = this.docBuilder.parse((InputStream)entity);
            }
            catch (IOException | SAXException e) {
                throw new AssertionError((Object)e.getMessage());
            }
        }
        Assert.assertNotNull((Object)this.rspEntity, (String)ErrorMessage.get("MissingXMLEntity"));
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("wfs-capabilities-2.0.sch", "SimpleWFSPhase");
        Result result = validator.validate((Source)new DOMSource(this.rspEntity, this.rspEntity.getDocumentURI()), false);
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    @Test(description="See ISO 19142: 7.2, 7.3.2", dataProvider="protocol-binding")
    public void getCapabilities_acceptVersions(ProtocolBinding binding) {
        InputStream entityStream = this.getClass().getResourceAsStream("getCapabilities_acceptVersions.xml");
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", binding);
        Response rsp = this.wfsClient.submitRequest(new StreamSource(entityStream), binding, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        String xpath = "/wfs:WFS_Capabilities/@version = '2.0.0'";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }
}

