/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.ResourceId;
import org.opengis.cite.iso19142.util.SOAPMessageConsumer;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WFSClient {
    private static final Logger LOGR = Logger.getLogger(WFSClient.class.getPackage().getName());
    protected Client client;
    protected Document wfsMetadata;
    protected Set<ProtocolBinding> globalBindings;
    protected List<QName> featureTypes;
    private String wfsVersion;

    public WFSClient() {
        ClientConfig config = new ClientConfig();
        config.register((Object)new LoggingFeature(LOGR, Level.ALL, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(5000)));
        this.client = ClientBuilder.newClient((Configuration)config);
        this.client.register((Object)new SOAPMessageConsumer());
    }

    public WFSClient(Document wfsMetadata) {
        this();
        String docElemName = wfsMetadata.getDocumentElement().getLocalName();
        if (!docElemName.equals("WFS_Capabilities")) {
            throw new IllegalArgumentException("Not a WFS service description: " + docElemName);
        }
        this.wfsMetadata = wfsMetadata;
        this.wfsVersion = wfsMetadata.getDocumentElement().getAttribute("version");
        this.featureTypes = ServiceMetadataUtils.getFeatureTypes(wfsMetadata);
        this.globalBindings = ServiceMetadataUtils.getGlobalBindings(wfsMetadata);
    }

    public Document getServiceDescription() {
        return this.wfsMetadata;
    }

    public Client getClient() {
        return this.client;
    }

    public void setServiceDescription(InputStream srvMetadata) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(srvMetadata);
            if (doc.getDocumentElement().getLocalName().equals("WFS_Capabilities")) {
                this.wfsMetadata = docBuilder.parse(srvMetadata);
            }
        }
        catch (ParserConfigurationException e) {
            LOGR.log(Level.WARNING, e.getMessage());
        }
    }

    public Document invokeStoredQuery(String queryId, Map<String, Object> params) {
        if (this.wfsVersion.equals("2.0.0") && queryId.equals("http://www.opengis.net/def/query/OGC-WFS/0/GetFeatureById")) {
            queryId = "urn:ogc:def:query:OGC-WFS::GetFeatureById";
        }
        Document req = WFSMessage.createRequestEntity("GetFeature", this.wfsVersion);
        WFSMessage.appendStoredQuery(req, queryId, params);
        ProtocolBinding binding = this.globalBindings.iterator().next();
        return this.retrieveXMLResponseEntity(req, binding);
    }

    public Document getFeatureByType(QName typeName, int count, ProtocolBinding binding) {
        if (null == binding) {
            binding = this.globalBindings.iterator().next();
        }
        Document req = WFSMessage.createRequestEntity("GetFeature", this.wfsVersion);
        if (count > 0) {
            req.getDocumentElement().setAttribute("count", Integer.toString(count));
        }
        WFSMessage.appendSimpleQuery(req, typeName);
        return this.retrieveXMLResponseEntity(req, binding);
    }

    public Response getFeature(Source reqEntity, ProtocolBinding binding) {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        return this.submitRequest(reqEntity, binding, endpoint);
    }

    public Document deleteFeatures(Map<String, QName> features, ProtocolBinding binding) {
        Document req = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        for (Map.Entry<String, QName> entry : features.entrySet()) {
            QName typeName = entry.getValue();
            Element delete = req.createElementNS("http://www.opengis.net/wfs/2.0", "Delete");
            delete.setPrefix("wfs");
            delete.setAttribute("xmlns:tns", typeName.getNamespaceURI());
            delete.setAttribute("typeName", "tns:" + typeName.getLocalPart());
            req.getDocumentElement().appendChild(delete);
            Element filter = req.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
            delete.appendChild(filter);
            Element resourceId = req.createElementNS("http://www.opengis.net/fes/2.0", "ResourceId");
            resourceId.setAttribute("rid", entry.getKey());
            filter.appendChild(resourceId);
        }
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, XMLUtils.writeNodeToString(req));
        }
        return this.executeTransaction(req, binding);
    }

    public Response deleteFeature(Document reqEntity, String id, QName typeName) {
        Element delete = reqEntity.createElementNS("http://www.opengis.net/wfs/2.0", "Delete");
        delete.setPrefix("wfs");
        delete.setAttribute("xmlns:tns", typeName.getNamespaceURI());
        delete.setAttribute("typeName", "tns:" + typeName.getLocalPart());
        reqEntity.getDocumentElement().appendChild(delete);
        Element filter = reqEntity.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        delete.appendChild(filter);
        Element resourceId = reqEntity.createElementNS("http://www.opengis.net/fes/2.0", "ResourceId");
        resourceId.setAttribute("rid", id);
        filter.appendChild(resourceId);
        return this.submitRequest(reqEntity, ProtocolBinding.POST);
    }

    public Response GetFeatureVersion(ResourceId rid, QName typeName) {
        Document req = WFSMessage.createRequestEntity("GetFeature-Minimal", this.wfsVersion);
        Element qry = WFSMessage.appendSimpleQuery(req, typeName);
        Element filter = req.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        filter.appendChild(req.importNode(rid.toElement(), true));
        qry.appendChild(filter);
        return this.submitRequest(req, ProtocolBinding.ANY);
    }

    public Document insert(List<Element> features, ProtocolBinding binding) {
        if (features.isEmpty()) {
            throw new IllegalArgumentException("No features instances to insert.");
        }
        Document req = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        Element insert = req.createElementNS("http://www.opengis.net/wfs/2.0", "Insert");
        insert.setPrefix("wfs");
        req.getDocumentElement().appendChild(insert);
        for (Element feature : features) {
            insert.appendChild(req.importNode(feature, true));
        }
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, XMLUtils.writeNodeToString(req));
        }
        return this.executeTransaction(req, binding);
    }

    public Document updateFeature(String id, QName featureType, Map<String, Object> properties) {
        Document req = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        return this.updateFeature(req, id, featureType, properties, ProtocolBinding.POST);
    }

    public Document updateFeature(Document req, String id, QName featureType, Map<String, Object> properties, ProtocolBinding binding) {
        Element update = req.createElementNS("http://www.opengis.net/wfs/2.0", "Update");
        update.setPrefix("wfs");
        update.setAttribute("handle", "Update");
        req.getDocumentElement().appendChild(update);
        WFSMessage.setTypeName(update, featureType);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            Element prop = req.createElementNS("http://www.opengis.net/wfs/2.0", "Property");
            prop.setPrefix("wfs");
            Element valueRef = req.createElementNS("http://www.opengis.net/wfs/2.0", "ValueReference");
            valueRef.setTextContent(property.getKey());
            valueRef.setPrefix("wfs");
            prop.appendChild(valueRef);
            Element value = req.createElementNS("http://www.opengis.net/wfs/2.0", "Value");
            value.setPrefix("wfs");
            if (Node.class.isInstance(property.getValue())) {
                value.appendChild((Node)property.getValue());
            } else {
                value.setTextContent(property.getValue().toString());
            }
            prop.appendChild(value);
            update.appendChild(prop);
        }
        Element filter = WFSMessage.newResourceIdFilter(id);
        update.appendChild(req.adoptNode(filter));
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, XMLUtils.writeNodeToString(req));
        }
        return this.executeTransaction(req, binding);
    }

    public Response submitRequest(Source entity, ProtocolBinding binding, URI endpoint) {
        WebTarget target = this.client.target(endpoint);
        target = target.queryParam("request", new Object[]{"GetCapabilities"});
        Invocation.Builder builder = target.request();
        LOGR.log(Level.FINE, String.format("Submitting %s request to URI %s", new Object[]{binding, target.getUri()}));
        Response response = null;
        switch (binding) {
            case GET: {
                String queryString = WFSMessage.transformEntityToKVP(entity);
                URI requestURI = UriBuilder.fromUri((URI)target.getUri()).replaceQuery(queryString).build(new Object[0]);
                LOGR.log(Level.FINE, String.format("Request URI: %s", requestURI));
                target = this.client.target(requestURI);
                builder = target.request();
                response = builder.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).buildGet().invoke();
                break;
            }
            case POST: {
                response = builder.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).buildPost(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_XML_TYPE)).invoke();
                break;
            }
            case SOAP: {
                Document soapEnv = WFSMessage.wrapEntityInSOAPEnvelope(entity, this.determineSoapVersion());
                response = builder.accept(new MediaType[]{MediaType.valueOf((String)"application/soap+xml")}).buildPost(Entity.entity((Object)new DOMSource(soapEnv), (MediaType)MediaType.valueOf((String)"application/soap+xml"))).invoke();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported message binding: " + binding);
            }
        }
        return response;
    }

    public Response submitRequest(Document reqEntity, ProtocolBinding binding) {
        String requestName = reqEntity.getDocumentElement().getLocalName();
        Map<String, URI> endpoints = ServiceMetadataUtils.getRequestEndpoints(this.wfsMetadata, requestName);
        if (null == endpoints) {
            throw new IllegalArgumentException("No HTTP method bindings found for " + requestName);
        }
        if (null == binding || binding.equals((Object)ProtocolBinding.ANY)) {
            String methodName = endpoints.keySet().iterator().next();
            binding = Enum.valueOf(ProtocolBinding.class, methodName);
        }
        String httpMethod = binding == ProtocolBinding.SOAP ? ProtocolBinding.POST.name() : binding.name();
        return this.submitRequest(new DOMSource(reqEntity), binding, endpoints.get(httpMethod));
    }

    public Document getCapabilities() {
        if (null == this.wfsMetadata) {
            throw new IllegalStateException("Service description is unavailable.");
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", ProtocolBinding.GET);
        WebTarget target = this.client.target(endpoint);
        target = target.queryParam("request", new Object[]{"GetCapabilities"});
        target = target.queryParam("service", new Object[]{"WFS"});
        Invocation.Builder builder = target.request();
        return (Document)builder.buildGet().invoke(Document.class);
    }

    public ProtocolBinding getAnyTransactionBinding() {
        Set<ProtocolBinding> trxBindings = ServiceMetadataUtils.getOperationBindings(this.wfsMetadata, "Transaction");
        return trxBindings.iterator().next();
    }

    Document executeTransaction(Document request, ProtocolBinding binding) {
        URI endpoint;
        if (binding == ProtocolBinding.ANY) {
            binding = this.getAnyTransactionBinding();
        }
        if (null == (endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", binding)).getScheme()) {
            throw new IllegalArgumentException("No Transaction endpoint found for binding " + binding);
        }
        LOGR.log(Level.FINE, String.format("Submitting request entity to URI %s \n%s", endpoint, XMLUtils.writeNodeToString(request)));
        Response rsp = this.submitRequest(new DOMSource(request), binding, endpoint);
        Document entity = null;
        if (rsp.hasEntity()) {
            entity = (Document)rsp.readEntity(Document.class);
        }
        return entity;
    }

    Document retrieveXMLResponseEntity(Document request, ProtocolBinding binding) {
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine("Request entity:\n" + XMLUtils.writeNodeToString(request));
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, request.getDocumentElement().getLocalName(), binding);
        Response rsp = this.submitRequest(new DOMSource(request), binding, endpoint);
        Document rspEntity = null;
        if (rsp.hasEntity()) {
            MediaType mediaType = rsp.getMediaType();
            if (!mediaType.getSubtype().endsWith("xml")) {
                throw new RuntimeException("Did not receive an XML entity: " + mediaType);
            }
            rspEntity = (Document)rsp.readEntity(Document.class);
            if (LOGR.isLoggable(Level.FINE)) {
                LOGR.fine("Response entity:\n" + XMLUtils.writeNodeToString(rspEntity));
            }
        }
        return rspEntity;
    }

    public int deleteStoredQuery(String queryId) {
        Document req = WFSMessage.createRequestEntity("DropStoredQuery", this.wfsVersion);
        req.getDocumentElement().setAttribute("id", queryId);
        ProtocolBinding binding = ProtocolBinding.POST;
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, req.getDocumentElement().getLocalName(), binding);
        Response rsp = this.submitRequest(new DOMSource(req), binding, endpoint);
        return rsp.getStatus();
    }

    public List<String> listStoredQueries() {
        Document req = WFSMessage.createRequestEntity("ListStoredQueries", this.wfsVersion);
        ProtocolBinding binding = ServiceMetadataUtils.getOperationBindings(this.wfsMetadata, "ListStoredQueries").iterator().next();
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "ListStoredQueries", binding);
        Response rsp = this.submitRequest(new DOMSource(req), binding, endpoint);
        Document rspEntity = (Document)rsp.readEntity(Document.class);
        NodeList qryList = rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "StoredQuery");
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < qryList.getLength(); ++i) {
            idList.add(((Element)Element.class.cast(qryList.item(i))).getAttribute("id"));
        }
        return idList;
    }

    private String determineSoapVersion() {
        if ("2.0.2".equals(this.wfsVersion)) {
            return "1.2";
        }
        return "1.1";
    }
}

