/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.versioning;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FES2;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.WFS2;
import org.opengis.cite.iso19142.basic.filter.ResourceId;
import org.opengis.cite.iso19142.transaction.InsertTests;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.Randomizer;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersioningTests
extends BaseFixture {
    private DataSampler dataSampler;
    private Map<String, QName> modifiedFeatures = new HashMap<String, QName>();

    @BeforeClass
    public void getDataSamplerFromContext(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.SAMPLER.getName());
        if (null != obj) {
            this.dataSampler = (DataSampler)DataSampler.class.cast(obj);
        }
    }

    @AfterClass
    public void deleteModifiedFeatures() {
        if (this.modifiedFeatures.isEmpty()) {
            return;
        }
        Document rspEntity = this.wfsClient.deleteFeatures(this.modifiedFeatures, ProtocolBinding.ANY);
        Element totalDeleted = (Element)rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "totalDeleted").item(0);
        if (null == totalDeleted || Integer.parseInt(totalDeleted.getTextContent().trim()) != this.modifiedFeatures.size()) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, String.format("Failed to delete all new features: %s \n%s", this.modifiedFeatures, XMLUtils.writeNodeToString(rspEntity)));
        }
        this.modifiedFeatures.clear();
    }

    @Test(description="See OGC 09-025: 11.3.3.2, 15.3.4; OGC 09-026: 7.11.2")
    public void firstVersionHasNoPredecessor() {
        this.reqEntity = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        Element feature = this.dataSampler.randomlySelectFeatureInstance();
        QName typeName = new QName(feature.getNamespaceURI(), feature.getLocalName());
        feature.setAttributeNS("http://www.opengis.net/gml/3.2", "id", "id-" + System.currentTimeMillis());
        InsertTests.insertRandomIdentifier(feature);
        WFSMessage.addInsertStatement(this.reqEntity, feature);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", ProtocolBinding.POST);
        Response rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        List<ResourceId> newFeatureIDs = InsertTests.extractFeatureIdentifiers(this.rspEntity, WFS2.Transaction.INSERT);
        Assert.assertEquals((int)newFeatureIDs.size(), (int)1, (String)"Unexpected number of fes:ResourceId elements in response entity (InsertResults).");
        ResourceId id = newFeatureIDs.get(0);
        this.modifiedFeatures.put(id.getRid(), typeName);
        Assert.assertNotNull((Object)id.getVersion(), (String)String.format("ResourceId is missing version designator (rid=%s)", id.getRid()));
        Assert.assertEquals((String)id.getVersion(), (String)"1", (String)"Unexpected designator for first version.");
        Assert.assertNull((Object)id.getPreviousRid(), (String)String.format("New feature has previousRid (rid=%s)", id.getRid()));
        ResourceId qryId = new ResourceId(id.getRid());
        qryId.setVersion(FES2.VersionAction.LAST.name());
        rsp = this.wfsClient.GetFeatureVersion(qryId, typeName);
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        int numReturned = Integer.parseInt(this.rspEntity.getDocumentElement().getAttribute("numberReturned"));
        Assert.assertEquals((int)numReturned, (int)1, (String)ErrorMessage.get("UnexpectedNumReturned"));
        feature = (Element)this.rspEntity.getElementsByTagNameNS(typeName.getNamespaceURI(), typeName.getLocalPart()).item(0);
        Element member = (Element)feature.getParentNode();
        Assert.assertEquals((String)member.getAttribute("state"), (String)WFS2.VersionState.VALID.toString(), (String)ErrorMessage.get("UnexpectedVersionState"));
    }

    @Test(description="See OGC 09-025: 15.3.5")
    public void updatedVersionHasSupersededPredecessor() {
        this.reqEntity = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        Element feature = this.dataSampler.randomlySelectFeatureInstance();
        QName typeName = new QName(feature.getNamespaceURI(), feature.getLocalName());
        String oldId = feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String newName = Randomizer.generateWords(2);
        properties.put("gml:name[1]", newName);
        this.rspEntity = this.wfsClient.updateFeature(this.reqEntity, oldId, typeName, properties, ProtocolBinding.POST);
        List<ResourceId> updatedIDs = InsertTests.extractFeatureIdentifiers(this.rspEntity, WFS2.Transaction.UPDATE);
        Assert.assertEquals((int)updatedIDs.size(), (int)1, (String)"Unexpected number of fes:ResourceId elements in response entity (UpdateResults).");
        ResourceId id = updatedIDs.get(0);
        this.modifiedFeatures.put(id.getRid(), typeName);
        Assert.assertNotNull((Object)id.getPreviousRid(), (String)String.format("Updated feature is missing previousRid (rid=%s)", id.getRid()));
        ResourceId qryId = new ResourceId(id.getPreviousRid());
        Response rsp = this.wfsClient.GetFeatureVersion(qryId, typeName);
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        int numReturned = Integer.parseInt(this.rspEntity.getDocumentElement().getAttribute("numberReturned"));
        Assert.assertEquals((int)numReturned, (int)1, (String)ErrorMessage.get("UnexpectedNumReturned"));
        feature = (Element)this.rspEntity.getElementsByTagNameNS(typeName.getNamespaceURI(), typeName.getLocalPart()).item(0);
        Element member = (Element)feature.getParentNode();
        Assert.assertEquals((String)member.getAttribute("state"), (String)WFS2.VersionState.SUPERSEDED.toString(), (String)ErrorMessage.get("UnexpectedVersionState"));
    }

    @Test(description="See OGC 09-025: Table 3, 15.4", enabled=false)
    public void updateSupersededVersion() {
        this.reqEntity = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        Element feature = this.dataSampler.randomlySelectFeatureInstance();
        QName typeName = new QName(feature.getNamespaceURI(), feature.getLocalName());
        String oldId = feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String newName = Randomizer.generateWords(2);
        properties.put("gml:name[1]", newName);
        this.rspEntity = this.wfsClient.updateFeature(this.reqEntity, oldId, typeName, properties, ProtocolBinding.POST);
        List<ResourceId> updatedIDs = InsertTests.extractFeatureIdentifiers(this.rspEntity, WFS2.Transaction.UPDATE);
        Assert.assertEquals((int)updatedIDs.size(), (int)1, (String)"Unexpected number of fes:ResourceId elements in response entity (UpdateResults).");
        ResourceId id = updatedIDs.get(0);
        this.modifiedFeatures.put(id.getRid(), typeName);
        Assert.assertFalse((boolean)id.getRid().equals(id.getPreviousRid()), (String)String.format("The rid and previousRid values should not match. ", id));
        this.rspEntity = this.wfsClient.updateFeature(this.reqEntity, oldId, typeName, properties, ProtocolBinding.POST);
        ETSAssert.assertExceptionReport(this.rspEntity, "OperationProcessingFailed", "Update");
    }

    @Test(description="See OGC 09-025: 15.3.6")
    public void replacementVersionHasNoSuccessor() {
        this.reqEntity = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        Element feature = this.dataSampler.randomlySelectFeatureInstance();
        QName typeName = new QName(feature.getNamespaceURI(), feature.getLocalName());
        InsertTests.insertRandomIdentifier(feature);
        InsertTests.addRandomName(feature);
        WFSMessage.addReplaceStatements(this.reqEntity, Collections.singletonList(feature));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", ProtocolBinding.POST);
        Response rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        List<ResourceId> newFeatureIDs = InsertTests.extractFeatureIdentifiers(this.rspEntity, WFS2.Transaction.REPLACE);
        Assert.assertEquals((int)newFeatureIDs.size(), (int)1, (String)"Unexpected number of fes:ResourceId elements in response entity (ReplaceResults).");
        ResourceId id = newFeatureIDs.get(0);
        this.modifiedFeatures.put(id.getRid(), typeName);
        Assert.assertNotNull((Object)id.getPreviousRid(), (String)String.format("Replacement feature is missing previousRid (rid=%s)", id.getRid()));
        ResourceId qryId = new ResourceId(id.getRid());
        qryId.setVersion(FES2.VersionAction.NEXT.name());
        rsp = this.wfsClient.GetFeatureVersion(qryId, typeName);
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        int numMatched = Integer.parseInt(this.rspEntity.getDocumentElement().getAttribute("numberMatched"));
        Assert.assertEquals((int)numMatched, (int)0, (String)ErrorMessage.get("UnexpectedNumMatched"));
    }

    @Test(description="See OGC 09-025: 15.2.7.1")
    public void deletedFeatureIsRetired() {
        this.reqEntity = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        Element feature = this.dataSampler.randomlySelectFeatureInstance();
        String gmlId = feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id");
        QName typeName = new QName(feature.getNamespaceURI(), feature.getLocalName());
        Response rsp = this.wfsClient.deleteFeature(this.reqEntity, gmlId, typeName);
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        int totalDeleted = Integer.parseInt(this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "totalDeleted").item(0).getTextContent());
        Assert.assertEquals((int)totalDeleted, (int)1, (String)ErrorMessage.format("UnexpectedValue", "totalDeleted"));
        ResourceId qryId = new ResourceId(gmlId);
        qryId.setVersion(FES2.VersionAction.LAST.name());
        rsp = this.wfsClient.GetFeatureVersion(qryId, typeName);
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        int numReturned = Integer.parseInt(this.rspEntity.getDocumentElement().getAttribute("numberReturned"));
        Assert.assertEquals((int)numReturned, (int)1, (String)ErrorMessage.get("UnexpectedNumReturned"));
        feature = (Element)this.rspEntity.getElementsByTagNameNS(typeName.getNamespaceURI(), typeName.getLocalPart()).item(0);
        Element member = (Element)feature.getParentNode();
        Assert.assertEquals((String)member.getAttribute("state"), (String)WFS2.VersionState.RETIRED.toString(), (String)ErrorMessage.get("UnexpectedVersionState"));
        Document doc = this.wfsClient.insert(Collections.singletonList(feature), ProtocolBinding.POST);
        int totalInserted = Integer.parseInt(doc.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "totalInserted").item(0).getTextContent());
        if (totalInserted != 1) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, String.format("Failed to restore deleted feature with id = %s", gmlId));
        }
    }
}

