/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.util.Arrays;
import java.util.Objects;
import org.geotoolkit.temporal.object.DefaultTemporalPosition;
import org.geotoolkit.util.StringUtilities;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultCalendarDate
extends DefaultTemporalPosition
implements CalendarDate {
    private InternationalString calendarEraName;
    private int[] calendarDate;

    public DefaultCalendarDate(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition, InternationalString calendarEraName, int[] calendarDate) {
        super(frame, indeterminatePosition);
        this.calendarDate = calendarDate;
        this.calendarEraName = calendarEraName;
    }

    public InternationalString getCalendarEraName() {
        return this.calendarEraName;
    }

    public int[] getCalendarDate() {
        return this.calendarDate;
    }

    public void setCalendarEraName(InternationalString calendarEraName) {
        this.calendarEraName = calendarEraName;
    }

    public void setCalendarDate(int[] calendarDate) {
        this.calendarDate = calendarDate;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultCalendarDate && super.equals(object)) {
            DefaultCalendarDate that = (DefaultCalendarDate)object;
            return Arrays.equals(this.calendarDate, that.calendarDate) && Objects.equals(this.calendarEraName, that.calendarEraName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.calendarDate != null ? Arrays.hashCode(this.calendarDate) : 0);
        hash = 37 * hash + (this.calendarEraName != null ? this.calendarEraName.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("CalendarDate:").append('\n');
        if (this.calendarEraName != null) {
            s.append("calendarEraName:").append((CharSequence)this.calendarEraName).append('\n');
        }
        if (this.calendarDate != null) {
            s.append("calendarDate:").append(StringUtilities.toCommaSeparatedValues(new Object[]{this.calendarDate})).append('\n');
        }
        return s.toString();
    }
}

